/* All Rights reserved */

#include <AppKit/AppKit.h>
#include "Todo.h"

@implementation Todo
{
}

- (id) initWithDescription: (NSString *) desc andImage: (NSImage *) img andTime:
  (double) tim
{
	self = [super init];
	ASSIGN(descr, desc);
	ASSIGN(image, img);
	time = tim;
	maxTime = time;
	return self;
}
-(void) setDescription: (NSString *) desc
{
	RELEASE(descr);
	ASSIGN(descr, desc);
}

-(void) setImage: (NSImage *) img
{
	RELEASE(image);
	ASSIGN(image, img);
}


- (NSImage *) getImage
{
	return image;
}

- (NSString *) getDescription
{
	return descr;
}

- (void) elapseTime: (int) t
{
	time = time - t;
}

- (double) getTime
{
	return time;
}

- (void) setTime: (double) t
{
	time = t;
	maxTime = t;
}

- (double) getMaxTime
{
	return maxTime;
}

- (BOOL) finished
{
	if(time<=0)
		return YES;
	else
		return NO;
}

- (void) resetTime
{
	time = maxTime;
}

- (NSString *) stringValue
{
	printf("stringValue\n");
	return descr;
}

-(void) dealloc
{
	RELEASE(image);
	RELEASE(descr);
	[super dealloc];
}


@end
