indexing

	description:

		"Eiffel identifiers followed by a comma"

	library: "Gobo Eiffel Tools Library"
	copyright: "Copyright (c) 2002, Eric Bezault and others"
	license: "Eiffel Forum License v2 (see forum.txt)"
	date: "$Date: 2003/02/07 13:05:00 $"
	revision: "$Revision: 1.7 $"

class ET_IDENTIFIER_COMMA

inherit

	ET_LOCAL_NAME
	ET_ARGUMENT_NAME

creation

	make

feature {NONE} -- Initialization

	make (a_name: like identifier; a_comma: like comma) is
			-- Create a new identifier-comma.
		require
			a_name_not_void: a_name /= Void
			a_comma_not_void: a_comma /= Void
		do
			identifier := a_name
			comma := a_comma
		ensure
			identifier_set: identifier = a_name
			comma_set: comma = a_comma
		end

feature -- Access

	identifier: ET_IDENTIFIER
			-- Identifier

	comma: ET_SYMBOL
			-- Comma separator

	position: ET_POSITION is
			-- Position of first character of
			-- current node in source code
		do
			Result := identifier.position
		end

	break: ET_BREAK is
			-- Break which appears just after current node
		do
			Result := comma.break
		end

feature -- Processing

	process (a_processor: ET_AST_PROCESSOR) is
			-- Process current node.
		do
			a_processor.process_identifier_comma (Current)
		end

invariant

	comma_not_void: comma /= Void

end
