create table GPC_PARAM (ID serial,
                        CODE varchar(30),
                        LABEL varchar(50),
                        VALUE varchar(50),
                        primary key (CODE));

create table GPC_KEY (ID serial,
                      CODE varchar(30),
                      primary key (CODE));

create table GPC_FILM_KIND (ID serial,
                            CODE varchar(30),
                            primary key (CODE));

create table GPC_FILM_MAKER (ID serial,
                             CODE varchar(30),
                             primary key (CODE));

create table GPC_FILM_MODEL (ID serial,
                             MAKER varchar(30),
                             CODE varchar(30),
                             primary key (MAKER, CODE));

create table GPC_CAMERA_MAKER (ID serial,
                               CODE varchar(30),
                               primary key (CODE));

create table GPC_CAMERA_MODEL (ID serial,
                               MAKER varchar(30),
                               CODE varchar(30),
                               primary key (MAKER, CODE));

create table GPC_LENS_MAKER (ID serial,
                             CODE varchar(30),
                             primary key (CODE));

create table GPC_LENS_MODEL (ID serial,
                             MAKER varchar(30),
                             CODE varchar(30),
                             primary key (MAKER, CODE));

create table GPC_FILM (ID serial,
                       PATHNAME varchar(255),
                       KIND varchar(30),
                       NUMBER varchar(30),
                       MAKER varchar(30),
                       MODEL varchar(30),
                       ISO int2,
                       SIZE int2,
                       CAMERA_MAKER varchar(30),
                       CAMERA_MODEL varchar(30),
                       PERIOD varchar(30),
                       DESCRIPTION text,
                       primary key (PATHNAME));

create table GPC_IMAGE (ID serial,
                        FILM_ID int4,
                        FILENAME varchar(255),
                        WIDTH int4,
                        HEIGHT int4,
                        MIME_TYPE varchar(255),
                        NUMBER varchar(30),
                        LENS_MAKER varchar(30),
                        LENS_MODEL varchar(30),
                        FOCAL int2,
                        APERTURE float4,
                        SPEED varchar(6),
			LATITUDE float4,
			LONGITUDE float4,
			ELEVATION float4,
			DIRECTION float4,
			PITCH float4,
			ROLL float4,
                        INTEREST_NOTE int2,
                        QUALITY_NOTE int2,
                        DESCRIPTION text,
                        primary key (FILM_ID, FILENAME));

create table GPC_KEYWORD (ID serial,
                          CODE varchar(30),
                          FILM_ID int4,
                          IMAGE_ID int4,
                          primary key (CODE, FILM_ID, IMAGE_ID));

create rule ON_GPC_FILM_DELETE_IMAGE as
    on delete to GPC_FILM
        do delete from GPC_IMAGE where FILM_ID = old.ID;

create rule ON_GPC_FILM_DELETE_KEYWORD as 
    on delete to GPC_FILM 
        do delete from GPC_KEYWORD where FILM_ID = old.ID;

create rule ON_GPC_IMAGE_DELETE_KEYWORD as
    on delete to GPC_IMAGE
        do delete from GPC_KEYWORD where IMAGE_ID = old.ID;

insert into GPC_PARAM (CODE, LABEL, VALUE)
    values ("PRODUCT_NAME", "GNOME Photo Collector", "gpc");
            
insert into GPC_PARAM (CODE, LABEL, VALUE)
    values ("DATABASE_VERSION", "GPC Database Version Level", "2");

