dnl
dnl Test for POSTGRES include files and libraries
dnl

AC_DEFUN(AC_SEARCH_POSTGRES, [

  AC_MSG_CHECKING(for Postgres files)

  AC_ARG_WITH(postgres,
  --with-postgres=<directory>	use Postgres backend in <directory>,[
  if test $withval != yes
  then
	  dir=$withval
  else
	  dir="/usr/local"
  fi
  ])

  postgresdir=""
  for d in $dir /usr /usr/local/postgres /usr/local/pgsql /opt/postgres /opt/packages/postgres /disk/postgres
  do
	  if test -f $d/lib/libpq.so
	  then
		  AC_MSG_RESULT(found Postgres in $d)
		  postgresdir=$d
		  break
	  fi
  done
  if test x$postgresdir = x
  then
	  AC_MSG_ERROR(Postgres backend not found)
  else
	  if test -f ${postgresdir}/include/libpq-fe.h
	  then
		  POSTGRES_INCLUDES=-I${postgresdir}/include
	  elif test -f ${postgresdir}/include/pgsql/libpq-fe.h
	  then
		  POSTGRES_INCLUDES=-I${postgresdir}/include/pgsql
	  elif test -f ${postgresdir}/include/postgresql/libpq-fe.h
	  then
		  POSTGRES_INCLUDES=-I${postgresdir}/include/postgresql
	  else
		  AC_MSG_ERROR(Postgres include files not found, backend not used)
		  postgresdir=""
	  fi
	  POSTGRES_LIBS=-L${postgresdir}/lib
  fi

  AM_CONDITIONAL(POSTGRES, test x$postgresdir != x)

  AC_SUBST(POSTGRES_INCLUDES)
  AC_SUBST(POSTGRES_LIBS)

])