/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 4 c-style: "K&R" -*- */

/*----------------------------------------------------------------------
 
  gpiv - Graphic program for Particle Image Velocimetry, based on gtk/gnome
          libraries.

   Copyright (C) 2002 Gerber van der Graaf

   This file is part of gpiv.

   Gpiv is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

----------------------------------------------------------------------*/

/*
 * (callback) functions for dac
 * $Log: dac.h,v $
 * Revision 1.2  2005/02/26 09:17:13  gerber
 * structured of interrogate function by using gpiv_piv_isiadapt
 *
 * Revision 1.1  2005/01/19 15:53:41  gerber
 * Initiation of Data Acquisition (DAC); trigerring of lasers and camera
 * by using RTAI and Realtime Linux, recording images from IEEE1394
 * (Firewire) IIDC compliant camera's
 *
 */

#ifndef DAC_H
#define DAC_H

/* #define MAX_COMBO_LIST 5 */

/* #define DACPAR_TIMING_MIN 3 */
/* #define DACPAR_TIMING_MAX 3 */
/* #define DACPAR_CAP_MIN 100 */
/* #define DACPAR_CAP_MAX 1000 */
/* #define DACPAR_NIMG_MIN 1 */
/* #define DACPAR_NIMG_MAX MAX_BUFS */


void
exec_trigger_start (void
                    );

void
exec_trigger_stop (void
                   );

void
exec_rec_start(GpivConsole *gpiv
               );

void
exec_rec_stop(void
              );

/*
 * Callback functions
 */

/* gboolean */
/* on_darea_expose (GtkWidget *widget, */
/*                  GdkEventExpose *event, */
/*                  gpointer user_data); */

void
on_entry_dac_fname(GtkSpinButton *widget, 
                   GtkWidget *entry);

void
on_checkbutton_fname_date_enter(GtkWidget *widget, 
                                gpointer data);

void
on_checkbutton_fname_date(GtkWidget *widget, 
                          gpointer data);

void
on_checkbutton_fname_time_enter(GtkWidget *widget, 
                                gpointer data);

void
on_checkbutton_fname_time(GtkWidget *widget, 
                          gpointer data);

void
on_radiobutton_dac_mouse_1_enter(GtkWidget * widget, 
                                 GtkWidget * entry);

void
on_radiobutton_dac_mouse_2_enter(GtkWidget * widget, 
                                  GtkWidget * entry);

void
on_radiobutton_dac_mouse_3_enter(GtkWidget * widget, 
                                  GtkWidget * entry);

void
on_radiobutton_dac_mouse_4_enter(GtkWidget * widget, 
                                  GtkWidget * entry);

void
on_radiobutton_dac_mouse_5_enter(GtkWidget * widget, 
                                  GtkWidget * entry);

void
on_radiobutton_dac_mouse_6_enter(GtkWidget * widget, 
                                  GtkWidget * entry);

void
on_radiobutton_dac_mouse(GtkWidget * widget, 
                          GtkWidget * entry);

void
on_spinbutton_dac_trigger_dt(GtkSpinButton * widget, 
                            GtkWidget * entry);

void
on_spinbutton_dac_trigger_incrdt(GtkSpinButton * widget, 
                                 GtkWidget * entry);
void
on_spinbutton_dac_trigger_cap(GtkSpinButton * widget, 
                            GtkWidget * entry);

void
on_spinbutton_dac_trigger_nf(GtkSpinButton * widget, 
                            GtkWidget * entry);

void 
on_button_dac_triggerstart_enter(GtkWidget *widget, 
                    gpointer data);

void
on_button_dac_triggerstart(GtkWidget *widget, 
		  gpointer data);

void 
on_button_dac_triggerstop_enter(GtkWidget *widget, 
                    gpointer data);

void
on_button_dac_triggerstop(GtkWidget *widget, 
		  gpointer data);

void
on_menu_camera_select(GtkWidget *widget, 
                          gpointer data);

void
on_menu_format(GtkWidget *widget, 
               gpointer data);

void
on_menu_fps(GtkWidget *widget, 
               gpointer data);

void
on_trigger_external_toggled            (GtkToggleButton *togglebutton,
                                        gpointer         user_data);

void
on_trigger_polarity_toggled            (GtkToggleButton *togglebutton,
                                        gpointer         user_data);

void
on_trigger_mode_activate(GtkWidget *widget, 
                         gpointer data);

void
on_checkbutton_camera_trigger_enter(GtkWidget *widget, 
                                    gpointer data);

void
on_checkbutton_camera_trigger(GtkWidget *widget, 
                              gpointer data);
void
on_man_auto_menu(GtkWidget *widget, 
                     gpointer data);

void
on_scale_changed(GtkAdjustment *adj, 
         gpointer user_data);

void 
on_button_dac_recstart_enter(GtkWidget *widget, 
                             gpointer data);

void
on_button_dac_recstart(GtkWidget *widget, 
		  gpointer data);

void 
on_button_dac_recstop_enter(GtkWidget *widget, 
                    gpointer data);

void
on_button_dac_recstop(GtkWidget *widget, 
		  gpointer data);


#endif  /* DAC_H */
