/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 4 c-style: "K&R" -*- */
 
/*----------------------------------------------------------------------

  gpiv - Graphic program for Particle Image Velocimetry, based on gtk/gnome
          libraries.

   Copyright (C) 2002 Gerber van der Graaf

   This file is part of gpiv.

   Gpiv is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

----------------------------------------------------------------------*/


/*
 * (callback) functions for the display
 * $Log: display.h,v $
 * Revision 1.9  2006/01/31 14:28:12  gerber
 * version 0.3.0
 *
 * Revision 1.8  2005/06/15 09:40:40  gerber
 * debugged, optimized
 *
 * Revision 1.7  2004/10/15 19:24:05  gerber
 * GPIV_ and Gpiv prefix to defines and structure names of libgpiv
 *
 * Revision 1.6  2004/06/14 21:19:23  gerber
 * Image depth up to 16 bits.
 * Improvement "single int" and "drag int" in Eval tab.
 * Viewer's pop-up menu.
 * Adaption for gpiv_matrix_* and gpiv_vector_*.
 * Resizing console.
 * See Changelog for further info.
 *
 * Revision 1.5  2003/09/01 11:17:14  gerber
 * improved monitoring of interrogation process
 *
 * Revision 1.4  2003/08/22 15:24:52  gerber
 * interactive spatial scaling
 *
 * Revision 1.3  2003/07/31 11:43:26  gerber
 * display images in gnome canvas (HOERAreset)
 *
 * Revision 1.2  2003/06/27 13:47:26  gerber
 * display ruler, line/point evaluation
 *
 * Revision 1.1.1.1  2003/06/17 17:10:52  gerber
 * Imported gpiv
 *
 */

#ifndef DISPLAY_H
#define DISPLAY_H


/*
 * Public display functions
 * Image in a Gnome canvas
 */

void 
create_img(Display * disp);

void 
hide_img1(Display * disp);

void 
show_img1(Display * disp);

void 
hide_img2(Display * disp);

void 
show_img2(Display * disp);

void 
destroy_img(Display * disp);


/*
 * Background in a Gnome canvas
 */

void 
create_background(Display *disp);

void 
destroy_background(Display *disp);


/*
 * Interrogation regions of first and second image frame in a Gnome canvas
 */

void 
create_all_intregs(Display * disp);

void 
destroy_all_intregs(Display * disp);

char *
create_intreg_data(Display * disp);

void
destroy_intreg_data(Display * disp);

void 
show_all_intregs(Display * disp);

void 
hide_all_intregs(Display * disp);

void 
create_all_intregs1(Display * disp);

void 
create_intreg1(Display * disp,
               gint i, 
               gint j);

void 
update_intreg1(Display * disp,
               gint i, 
               gint j);

void 
destroy_intreg1(Display * disp,
                gint i, 
                gint j);

void 
show_all_intregs1(Display * disp);

void 
hide_all_intregs1(Display * disp);

void 
destroy_all_intregs1(Display * disp);

void 
create_all_intregs2(Display * disp);

void 
create_intreg2(Display * disp,
               gint i, 
               gint j);

void 
update_intreg2(Display * disp,
               gint i, 
               gint j);   

void 
destroy_intreg2(Display * disp,
                gint i, 
                gint j);

void 
show_all_intregs2(Display * disp);

void 
hide_all_intregs2(Display * disp);

void 
destroy_all_intregs2(Display * disp);


/*
 * PIV vectors in a Gnome canvas
 */
/* Determines maximum for scaling */
gfloat
dxdy_max(GpivPivData piv_data);

/* Displays a single PIV vector */
void 
create_vector(GpivData * gpd,
              gint i, 
              gint j);  

/* Updates a single PIV vector */
void 
update_vector(GpivData * gpd,
              gint i, 
              gint j); 

/* Destroys a single PIV vector  */
void 
destroy_vector(GpivData * gpd,
               gint i, 
               gint j); 

/* Displays all PIV vectors*/
void 
create_all_vectors(GpivData * gpd);

/* Shows all PIV vectors */
void 
show_all_vectors(GpivData * gpd);

/* Hides all PIV vectors */
void 
hide_all_vectors(GpivData * gpd); 

/* Updates all PIV vectors */
void 
update_all_vectors(GpivData * gpd);

/* Destroys all PIV vectors */
void 
destroy_all_vectors(GpivData * gpd);


/*
 * Scalar data in a Gnome canvas
 */

void 
create_scalar(/* ScalarData * scalar_data,  */
              Display * disp,
              gint i, 
              gint j, 
              gint type,
              guint col_val
              );
void 
create_all_scalars(/* ScalarData scalar_data,   */
                   Display * disp,
                   gint type
                   );
void 
show_all_scalars(/* ScalarData * scalar_data,  */
                 Display * disp,
                 gint type
                 );
void 
hide_all_scalars(/* ScalarData * scalar_data, */
                 Display * disp,
                 gint type
                 );
void 
destroy_all_scalars(/* ScalarData * scalar_data,  */
                    Display * disp,
                    gint type
                    );



/*
 * Callback functions for the display
 */

void
/* on_display_set_focus(gpointer data, guint action, GtkWidget *widget); */
on_display_set_focus (GtkWidget *widget, 
                      gpointer data);

void 
delete_display(GtkWidget *widget,
                  GdkEvent  *event,
                  gpointer   data);

void 
on_scrolledwindow_display_adj_changed (GtkAdjustment *adj, 
                                       gpointer data);

gboolean 
canvas_display_enter_notify (GtkWidget *widget, 
                             GdkEventMotion *event,
                             gpointer data);

gboolean 
canvas_display_motion_notify (GtkWidget *widget, 
                              GdkEventMotion *event,
                              gpointer data);

gboolean 
canvas_display_button_press(GtkWidget *widget,
                            GdkEventButton *event,
                            gpointer data);

gboolean 
canvas_display_button_release(GtkWidget *widget, 
                              GdkEventButton *event,
                              gpointer data);

gboolean 
canvas_display_leave_notify(GtkWidget *widget, 
                            GdkEventMotion *event,
                            gpointer data);


/*
 * Callback functions for the display menu
 */

void 
select_zoomscale(gpointer data, guint action, 
                 GtkWidget * widget);

/* void  */
/* select_zoomscale(GtkMenuItem * menuitem, gpointer data, guint action); */

void 
zoom_display(Display *disp, 
             gint zoom_index);


/* ORIGINAL CALLBACK (DIDN'T WORK) gpointer data, guint action, GtkWidget*widgetvoid  */
void
view_toggle_stretch_display(GtkWidget *widget, 
                            gpointer data);

void
view_visible_grid(GtkWidget *widget, 
                  gpointer data);

void
select_view_background(gpointer data, 
                       guint action, 
                       GtkWidget *widget);

/* void */
/* view_toggle_img1(GtkWidget *widget,  */
/*                  gpointer data); */

/* void */
/* view_toggle_img2(GtkWidget *widget,  */
/*                  gpointer data); */

void
view_toggle_intregs(GtkWidget *widget, 
                    gpointer data);

void
view_toggle_piv(GtkWidget *widget, 
                gpointer data);

void
select_view_scalardata(gpointer data, 
                       guint action, 
                       GtkWidget *widget);

/* void */
/* view_toggle_vor(GtkWidget *widget,  */
/*                 gpointer data); */

/* void */
/* view_toggle_sstrain(GtkWidget *widget,  */
/*                     gpointer data); */

/* void */
/* view_toggle_nstrain(GtkWidget *widget,  */
/*                     gpointer data); */

void
select_vectorscale(gpointer data, 
                   guint action, 
                   GtkWidget *widget);

void
select_vectorcolor(gpointer data, 
                   guint action, 
                   GtkWidget *widget);

void 
on_view_options_clicked(GtkButton * button, 
                        gpointer user_data);


#endif /* DISPLAY_H */
