/* -*- Mode1: C; indent-tabs-mode: nil; c-basic-offset: 4 c-style: "K&R" -*- */

/*----------------------------------------------------------------------
 
  gpiv - Graphic program for Particle Image Velocimetry, based on gtk/gnome
          libraries.

   Copyright (C) 2002, 2003, 2004 Gerber van der Graaf

   This file is part of gpiv.

   Gpiv is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

----------------------------------------------------------------------*/

/*
 * main routines of gpiv
 * $Log: main.c,v $
 * Revision 1.21  2006/01/31 15:15:33  gerber
 * version 0.3.0b; minor change
 *
 * Revision 1.20  2006/01/31 14:28:12  gerber
 * version 0.3.0
 *
 * Revision 1.18  2005/03/04 12:52:01  gerber
 * print message if gpiv_scan_resourcefiles returns with err_msg != NULL ==>
 * this is not an error, but defaults are read
 *
 * Revision 1.17  2005/03/01 15:23:22  gerber
 * removed warning message
 *
 * Revision 1.16  2005/03/01 14:43:46  gerber
 * updated documentation
 *
 * Revision 1.15  2005/02/26 09:43:30  gerber
 * parameter flags (parameter_logic) defined as gboolean
 *
 * Revision 1.14  2005/02/26 09:17:13  gerber
 * structured of interrogate function by using gpiv_piv_isiadapt
 *
 * Revision 1.13  2005/01/19 15:53:42  gerber
 * Initiation of Data Acquisition (DAC); trigerring of lasers and camera
 * by using RTAI and Realtime Linux, recording images from IEEE1394
 * (Firewire) IIDC compliant camera's
 *
 * Revision 1.12  2004/10/15 19:24:05  gerber
 * GPIV_ and Gpiv prefix to defines and structure names of libgpiv
 *
 * Revision 1.11  2004/06/14 21:19:23  gerber
 * Image depth up to 16 bits.
 * Improvement "single int" and "drag int" in Eval tab.
 * Viewer's pop-up menu.
 * Adaption for gpiv_matrix_* and gpiv_vector_*.
 * Resizing console.
 * See Changelog for further info.
 *
 * Revision 1.10  2003/09/04 13:31:55  gerber
 * init of printing (unfinished)
 *
 * Revision 1.9  2003/09/01 11:17:15  gerber
 * improved monitoring of interrogation process
 *
 * Revision 1.8  2003/08/22 15:24:52  gerber
 * interactive spatial scaling
 *
 * Revision 1.7  2003/07/25 15:40:23  gerber
 * removed/disabled setting of correlation in Eval tab, Correlation type in Image info tab
 *
 * Revision 1.6  2003/07/13 14:38:18  gerber
 * changed error handling of libgpiv
 *
 * Revision 1.5  2003/07/12 21:21:16  gerber
 * changed error handling libgpiv
 *
 * Revision 1.3  2003/07/10 11:56:07  gerber
 * added man page
 *
 * Revision 1.2  2003/06/27 13:47:26  gerber
 * display ruler, line/point evaluation
 *
 * Revision 1.1.1.1  2003/06/17 17:10:52  gerber
 * Imported gpiv
 *
 */


/* 
 * some header inclusions for gtk/gnome (by glade)
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "support.h"

/*
 * all variables are read by a header
 */
#include "gpiv_gui.h"	
#include "console.h"
/* #include "console_interface.h" */
#include "utils.h"
#include "main.h"


/* #define USAGE "\ */
/* Usage: gpiv-gui [-f filename][-s N][-t] \n\ */
/* \n\ */
/* keys: \n\ */
/* -f filename: loads project \n\ */
/* -s N:        vector scale N \n\ */
/* -t:          show tooltips \n" */

/* [-p] */
/* -p:          print parameters and other info to stdout \n\ */



/* #define HELP "\n\ */
/* gpiv processes and analyzes images for (Digital) Particle Image  \n\ */
/* Velocimetry, post-processes the PIV data and visualizes its \n\ */
/* results in a graphical way. \n" */



static void
scan_parameters()
/*-----------------------------------------------------------------------------
 * Obtains parameter settings of the Graphic User Interface
 */
{
    gchar *err_msg;
    gboolean used_default = 0;

    gnome_config_push_prefix("/gpiv/General/");

    print_par = 
        gnome_config_get_bool_with_default("print_par=FALSE", &used_default);
    if (used_default) {
        g_message("print_par = %d from default", print_par);
        gnome_config_set_bool("print_par", print_par);
    }
    
    verbose = 
        gnome_config_get_bool_with_default("verbose=FALSE", &used_default);
    if (used_default) {
        g_message("verbose = %d from default", verbose);
        gnome_config_set_bool("verbose", verbose);
    }
    
    default_par.show_tooltips = 
        gnome_config_get_bool_with_default("show_tooltips=TRUE", 
                                           &used_default);
    if (used_default) {
        g_message("show_tooltips = %d from default", 
                  default_par.show_tooltips);
        gnome_config_set_bool("show_tooltips", default_par.show_tooltips);
    }
    
    default_par.view_gpivbuttons = 
        gnome_config_get_bool_with_default("view_gpivbuttons=TRUE", 
                                           &used_default);
    if (used_default) {
        g_message("view_gpivbuttons = %d from default", 
                  default_par.view_gpivbuttons);
        gnome_config_set_bool("view_gpivbuttons", 
                              default_par.view_gpivbuttons);
    }
    
    default_par.view_tabulator = 
        gnome_config_get_bool_with_default("view_tabulator=TRUE", 
                                           &used_default);
    if (used_default) {
        g_message("view_tabulator = %d from default", 
                  default_par.view_tabulator);
        gnome_config_set_bool("view_tabulator", 
                              default_par.view_tabulator);
    }
    
    default_par.nbins = 
        gnome_config_get_int_with_default("nbins=10", &used_default);
    if (used_default) {
        g_message("nbins = %d from default", default_par.nbins);
        gnome_config_set_int("nbins", default_par.nbins);
    }
    
    default_par.hdf = 
        gnome_config_get_bool_with_default("hdf=FALSE", &used_default);
    if (used_default) {
        g_message("hdf = %d from default ??", default_par.hdf);
        gnome_config_set_bool("hdf", default_par.hdf);
    }
    
    default_par.hdf_img = 
        gnome_config_get_bool_with_default("hdf_img=FALSE", &used_default);
    if (used_default) {
        g_message("hdf_img = %d from default ??", default_par.hdf_img);
        gnome_config_set_bool("hdf_img", default_par.hdf_img);
    }




    gnome_config_push_prefix("/gpiv/Image/");

    default_par.x_corr = 
        gnome_config_get_bool_with_default("x_corr=TRUE", &used_default);
    if (used_default) {
        g_message("x_corr = %d from default", default_par.x_corr);
        gnome_config_set_bool("x_corr", default_par.x_corr);
    }
    
    default_par.img_width = 
        gnome_config_get_int_with_default("columns=256", &used_default);
    if (used_default) {
        g_message("img_width = %d from default", default_par.img_width);
        gnome_config_set_int("columns", default_par.img_width);
    }
    
    default_par.img_height = 
        gnome_config_get_int_with_default("rows=256", &used_default);
    if (used_default) {
        g_message("img_height = %d from default", default_par.img_height);
        gnome_config_set_int("rows", default_par.img_height);
    }
    
    default_par.img_depth = 
        gnome_config_get_int_with_default("depth=8", &used_default);
    if (used_default) {
        g_message("img_depth = %d from default", default_par.img_depth);
        gnome_config_set_int("depth", default_par.img_depth);
    }
    
    
    
    
    gnome_config_push_prefix("/gpiv/Processes/");
    
#ifndef DISABLE_DAC
    default_par.process_dac = 
        gnome_config_get_bool_with_default("process_dac=FALSE", &used_default);
    if (used_default) {
        g_message("process_dac = %d from default", default_par.process_dac);
        gnome_config_set_bool("process_dac", default_par.process_dac);
    }
#endif /* DISABLE_DAC */
    
    default_par.process_piv = 
        gnome_config_get_bool_with_default("process_piv=TRUE", &used_default);
    if (used_default) {
        g_message("process_piv = %d from default", default_par.process_piv);
        gnome_config_set_bool("process_piv", default_par.process_piv);
    }
    
    default_par.process_gradient = 
        gnome_config_get_bool_with_default("process_gradient=FALSE", 
                                           &used_default);
    if (used_default) {
        g_message("process_gradient = %d from default", 
                  default_par.process_gradient);
        gnome_config_set_bool("process_gradient", 
                              default_par.process_gradient);
    }
    
    default_par.process_resstats = 
        gnome_config_get_bool_with_default("process_resstats=FALSE", 
                                           &used_default);
    if (used_default) {
        g_message("process_resstats = %d from default", 
                  default_par.process_resstats);
        gnome_config_set_bool("process_resstats", 
                              default_par.process_resstats);
    }
    
    default_par.process_errvec = 
        gnome_config_get_bool_with_default("process_errvec=FALSE", 
                                           &used_default);
    if (used_default) {
        g_message("process_errvec = %d from default", 
                  default_par.process_errvec);
        gnome_config_set_bool("process_errvec", 
                              default_par.process_errvec);
    }
    
    default_par.process_peaklock = 
        gnome_config_get_bool_with_default("process_peaklock=FALSE", 
                                           &used_default);
    if (used_default) {
        g_message("process_peaklock = %d from default", 
                  default_par.process_peaklock);
        gnome_config_set_bool("process_peaklock", 
                              default_par.process_peaklock);
    }
    
    default_par.process_average = 
        gnome_config_get_bool_with_default("process_average=FALSE", 
                                           &used_default);
    if (used_default) {
        g_message("process_average = %d from default", 
                  default_par.process_average);
        gnome_config_set_bool("process_average", 
                              default_par.process_average);
    }
    
    default_par.process_scale = 
        gnome_config_get_bool_with_default("process_scale=FALSE", 
                                           &used_default);
    if (used_default) {
        g_message("process_scale = %d from default", 
                  default_par.process_scale);
        gnome_config_set_bool("process_scale", 
                              default_par.process_scale);
    }
    
    default_par.process_subtract = 
        gnome_config_get_bool_with_default("process_subtract=FALSE", 
                                           &used_default);
    if (used_default) {
        g_message("process_subtract = %d from default", 
                  default_par.process_subtract);
        gnome_config_set_bool("process_subtract", 
                              default_par.process_subtract);
    }
    
    default_par.process_vorstra = 
        gnome_config_get_bool_with_default("process_vorstra=FALSE", 
                                           &used_default);
    if (used_default) {
        g_message("process_vorstra = %d from default", 
                  default_par.process_vorstra);
        gnome_config_set_bool("process_vorstra", default_par.process_vorstra);
    }
    
    
    
    gnome_config_push_prefix("/gpiv/Display/");
    
    default_par.background = 
        gnome_config_get_int_with_default("background=1", &used_default);
    if (used_default) {
        g_message("background = %d from default", default_par.background);
        gnome_config_set_int("background", default_par.background);
    }
    
    default_par.zoom_index = 
        gnome_config_get_int_with_default("zoom_index=1", &used_default);
    if (used_default) {
        g_message("zoom_index = %d from default", default_par.zoom_index);
        gnome_config_set_int("zoom_index", default_par.zoom_index);
    }
    
    default_par.vector_scale = 
        gnome_config_get_int_with_default("vector_scale=8", &used_default);
    if (used_default) {
        g_message("vector_scale = %d from default", default_par.vector_scale);
        gnome_config_set_int("vector_scale", default_par.vector_scale);
    }
    
    default_par.vector_color = 
        gnome_config_get_int_with_default("vector_color=SHOW_PEAKNR", 
                                          &used_default);
    if (used_default) {
        g_message("vector_color = %d from default", default_par.vector_color);
        gnome_config_set_int("vector_color", default_par.vector_color);
    }
    
/*     default_par.stretch_window =  */
/*         gnome_config_get_int_with_default("stretch_window=0", &used_default); */
/*     if (used_default) { */
/*         g_message("stretch_window = %d from default",  */
/*                   default_par.stretch_window); */
/*         gnome_config_set_int("stretch_window", default_par.stretch_window); */
/*     } */
    
    default_par.display_img1 = 
        gnome_config_get_bool_with_default("display_img1=TRUE", 
                                           &used_default);
    if (used_default) {
        g_message("display_img1 = %d from default", 
                  default_par.display_img1);
        gnome_config_set_bool("display_img1", default_par.display_img1);
    }
    
    default_par.display_img2 = 
        gnome_config_get_bool_with_default("display_img2=TRUE", 
                                           &used_default);
    if (used_default) {
        g_message("display_img2 = %d from default", 
                  default_par.display_img2);
        gnome_config_set_bool("display_img2", default_par.display_img1);
    }
    
    default_par.display_intregs = 
        gnome_config_get_bool_with_default("display_intregs=TRUE", 
                                           &used_default);
    if (used_default) {
        g_message("display_intregs = %d from default", 
                  default_par.display_intregs);
        gnome_config_set_bool("display_intregs", default_par.display_intregs);
    }
    
    default_par.display_piv = 
        gnome_config_get_bool_with_default("display_piv=TRUE", &used_default);
    if (used_default) {
        g_message("display_piv = %d from default", default_par.display_piv);
        gnome_config_set_bool("display_piv", default_par.display_piv);
    }
    
    default_par.display_none = 
        gnome_config_get_bool_with_default("display_none=TRUE", &used_default);
    if (used_default) {
        g_message("display_none = %d from default", default_par.display_none);
        gnome_config_set_bool("display_none", default_par.display_none);
    }
    
    default_par.display_vor = 
        gnome_config_get_bool_with_default("display_vor=FALSE", &used_default);
    if (used_default) {
        g_message("display_vor = %d from default", default_par.display_vor);
        gnome_config_set_bool("display_vor", default_par.display_vor);
    }
    
    default_par.display_sstrain = 
        gnome_config_get_bool_with_default("display_sstrain=FALSE", 
                                           &used_default);
    if (used_default) {
        g_message("display_sstrain = %d from default", 
                  default_par.display_sstrain);
        gnome_config_set_bool("display_sstrain", default_par.display_sstrain);
    }
    
    default_par.display_nstrain = 
        gnome_config_get_bool_with_default("display_nstrain=FALSE", 
                                           &used_default);
    if (used_default) {
        g_message("display_nstrain = %d from default", 
                  default_par.display_nstrain);
        gnome_config_set_bool("display_nstrain", default_par.display_nstrain);
    }

    gnome_config_pop_prefix();
    gnome_config_sync();

    
    gpiv_par.show_tooltips = default_par.show_tooltips;
    gpiv_par.view_tabulator = default_par.view_tabulator;
    gpiv_par.view_gpivbuttons = default_par.view_gpivbuttons;
    gpiv_par.nbins = default_par.nbins;
    gpiv_par.x_corr = default_par.x_corr;

#ifndef DISABLE_DAC
    gpiv_par.process_dac = default_par.process_dac;
    if ((err_msg = gpiv_dac_get_camvar(&cam_var)) != NULL) {
/*             g_warning("from: scan_parameters\n from: gpiv_dac_get_dacvar\n %s",  */
/*                         err_msg); */
            g_warning("from: scan_parameters\n from: gpiv_dac_get_dacvar\n %s", 
                        err_msg);
    }
    if (cam_var.numCameras > 0) {
        if (dc1394_setup_capture(cam_var.camera[0].handle, 
                                 cam_var.camera[0].id, 
                                 cam_var.misc_info[0].iso_channel, 
                                 cam_var.misc_info[0].format, 
                                 cam_var.misc_info[0].mode, 
                                 cam_var.maxspeed,
/* cam_var.misc_info[0].framerate */ FRAMERATE_7_5, 
                                 &cam_var.capture[0])
            != DC1394_SUCCESS) {
            dc1394_release_camera(cam_var.handle, &cam_var.capture[0]);
            raw1394_destroy_handle(cam_var.handle);
            g_warning("unable to setup camera-\n\
check line %d of %s to make sure\n\
that the video mode,framerate and format are\n\
supported by your camera\n",
                        __LINE__,__FILE__);
            return;
        }
        gpiv_par.img_width = cam_var.capture[0].frame_width;
        gpiv_par.img_height = cam_var.capture[0].frame_height;

/*         g_warning("scan_parameters:: cam_var.numCameras = %d\n\ */
/*                from camera at Node 0: ncolumns=%d nrows=%d", */
/*                       cam_var.numCameras, gpiv_par.img_width, gpiv_par.img_height); */
/*         dc1394_release_camera(cam_var.handle, &cam_var.capture[0]);     */
        raw1394_destroy_handle(cam_var.handle);
/*         g_warning("scan_parameters:: default_par.img_width = %d default_par.img_height = %d", */
/*                   default_par.img_width, default_par.img_height); */
    } else {
        gpiv_par.img_width = default_par.img_width;
        gpiv_par.img_height = default_par.img_height;
    }
                                                                
#else
    gpiv_par.img_width = default_par.img_width;
    gpiv_par.img_height = default_par.img_height;
#endif /* DISABLE_DAC */
    gpiv_par.img_depth = default_par.img_depth;
    gpiv_par.process_piv = default_par.process_piv;
    gpiv_par.process_gradient = default_par.process_gradient;
    gpiv_par.process_resstats = default_par.process_resstats;
    gpiv_par.process_errvec = default_par.process_errvec;
    gpiv_par.process_peaklock = default_par.process_peaklock;
    gpiv_par.process_average = default_par.process_average;
    gpiv_par.process_scale = default_par.process_scale;
    gpiv_par.process_subtract = default_par.process_subtract;
    gpiv_par.process_vorstra = default_par.process_vorstra;
    gpiv_par.background = default_par.background;
    gpiv_par.zoom_index = default_par.zoom_index;
    gpiv_par.vector_scale = default_par.vector_scale;
    gpiv_par.vector_color = default_par.vector_color;
/*     gpiv_par.stretch_window = default_par.stretch_window; */
    gpiv_par.display_img1 = default_par.display_img1;
    gpiv_par.display_img2 = default_par.display_img2;
    gpiv_par.display_intregs = default_par.display_intregs;
    gpiv_par.display_piv = default_par.display_piv;
    gpiv_par.display_none = default_par.display_none;
    gpiv_par.display_vor = default_par.display_vor;
    gpiv_par.display_sstrain = default_par.display_sstrain;
    gpiv_par.display_nstrain = default_par.display_nstrain;
    gpiv_par.hdf = default_par.hdf;
    gpiv_par.hdf_img = default_par.hdf_img;
    
}



static void
scan_variables()
/*-----------------------------------------------------------------------------
 * Obtains additional variables, stored from previous sessions
 */
{
    gboolean used_default = 0;
    gchar fname_nr[GPIV_MAX_CHARS], fname_nr_default[GPIV_MAX_CHARS];
    gint i = 0;


    gnome_config_push_prefix("/gpiv/RuntimeVariables/");
    
    gpiv_var.tab_pos = 
        gnome_config_get_int_with_default("tab_pos=1", &used_default);
    if (used_default) {
        g_message("tab_pos = %d from default", 
                  gpiv_var.tab_pos);
        gnome_config_set_int("tab_pos", gpiv_var.tab_pos);
    }
    


    gpiv_var.number_fnames_last = 
        gnome_config_get_int_with_default("number_fnames_last=0", 
                                          &used_default);
    if (used_default) {
        g_message("number_fnames_last = %d from default", 
                  gpiv_var.number_fnames_last);
        gnome_config_set_int("number_fnames_last", 
                             gpiv_var.number_fnames_last);
    }
    
    
    for (i = 0; i < gpiv_var.number_fnames_last; i++) {
        g_snprintf(fname_nr, GPIV_MAX_CHARS,"fname_last_%d", i);
        g_snprintf(fname_nr_default, GPIV_MAX_CHARS,"fname_last_%d=./", i);
        
        gpiv_var.fn_last[i] = 
            gnome_config_get_string_with_default(fname_nr_default, 
                                                 &used_default);
        if (used_default) {
            g_message("fnames_nr_default = %s from default", 
                      gpiv_var.fn_last[i]);
            gnome_config_set_string(fname_nr, gpiv_var.fn_last[i]);
        }
    }


    gpiv_var.fname_date = 
        gnome_config_get_bool_with_default("fname_date=FALSE", 
                                           &used_default);
    if (used_default) {
        g_message("fname_date = %d from default", 
                  gpiv_var.fname_date);
        gnome_config_set_bool("fname_date", gpiv_var.fname_date);
    }
    

    gpiv_var.fname_time = 
        gnome_config_get_bool_with_default("fname_time=FALSE", 
                                           &used_default);
    if (used_default) {
        g_message("fname_time = %d from default", 
                  gpiv_var.fname_time);
        gnome_config_set_bool("fname_time", gpiv_var.fname_time);
    }
    

    gpiv_var.fname_last = 
        gnome_config_get_string_with_default("fname_last=./", &used_default);
    if (used_default) {
        g_message("fname_last = %s from default", gpiv_var.fname_last);
        gnome_config_set_string("fname_last", gpiv_var.fname_last);
    }


    gpiv_var.img_span_px = 
        gnome_config_get_float_with_default("span=1.0", &used_default);
    if (used_default) {
        g_message("img_span_px = %f from default", gpiv_var.img_span_px);
        gnome_config_set_float("span", gpiv_var.img_span_px);
    }
    
    gpiv_var.img_length_mm = 
        gnome_config_get_float_with_default("length=1.0", &used_default);
    if (used_default) {
        g_message("img_length_mm = %f from default", gpiv_var.img_length_mm);
        gnome_config_set_float("length", gpiv_var.img_length_mm);
    }
    
    gpiv_var.piv_disproc_zoom = 
        gnome_config_get_float_with_default("zoom_factor=1.0", &used_default);
    if (used_default) {
        g_message("piv_disproc_zoom = %f from default", 
                  gpiv_var.piv_disproc_zoom);
        gnome_config_set_float("zoom_factor", gpiv_var.piv_disproc_zoom);
    }
    
    gpiv_var.piv_disproc_vlength = 
        gnome_config_get_int_with_default("vector_length=1", &used_default);
    if (used_default) {
        g_message("piv_disproc_vlength = %d from default", 
                  gpiv_var.piv_disproc_vlength);
        gnome_config_set_int("vector_length", gpiv_var.piv_disproc_vlength);
    }
    
    gnome_config_pop_prefix();
    gnome_config_sync();
}



int main(int argc, 
         char *argv[]
         )
/*-----------------------------------------------------------------------------
 * Main routine of gpiv
 */
{
/*     GnomeProgram *Gpiv_app = NULL; */
/*     GpivConsole *gpiv = g_new0 (GpivConsole, 1); */
    GtkWidget *window1;

    char *err_msg = NULL;
    gchar *msg = "Welcome to gpiv.";
    GtkWidget *menu_gpiv_popup = NULL;
    GpivConsole *gpiv = NULL;
    gint image_width, image_height;
    gboolean dac_trig = TRUE;
    gint dac_init, dac_start, dac_stop, dac_error;
    gint i;
#ifdef ENABLE_NLS
setlocale (LC_ALL, "");
    bindtextdomain(PACKAGE, PACKAGE_LOCALE_DIR);
    textdomain(PACKAGE);
#endif

/* 
 * parameter initializing of gpiv-gui, image
 */
    msg_default = "";
    m_select = 0;
    nbufs = 0;
    exec_process = FALSE;
    cancel_process = FALSE;
    display_act = NULL;
    gci_aoi = NULL;
    gci_line = NULL; 
    gpiv_img_parameters_logic(&image_par, FALSE);

/*
 * Reading parameters and variables from gnome parameter file (~/.gnome2/gpiv)
 * See: http://developer.gnome.org/doc/GGAD/z79.html
 */
/*     for (i=0; i<argc; i++) { */
/*     g_message ("main:: 0 argc = %d argv[%d] = %s",  */
/*                i, i, argv[i]); */
/*     } */
    scan_parameters();
    scan_variables();


/*
 * Initialize gnome program
 * command line keys: using POPT
 */
    Gpiv_app = NULL;
    Gpiv_app = gnome_program_init(PACKAGE, 
                              VERSION, 
                              LIBGNOMEUI_MODULE,
                              argc, 
                              argv,
                              GNOME_PARAM_POPT_TABLE, options,
                              GNOME_PARAM_HUMAN_READABLE_NAME, 
                              _("Image analyser for Particle Image Velocimetry"),
                              GNOME_PROGRAM_STANDARD_PROPERTIES, 
                              NULL);
    gdk_rgb_init();

/* image_width/height used to check if changed by commnand line keys */
    image_width = gpiv_par.img_width;
    image_height = gpiv_par.img_height;    
    
    if (gpiv_par.x_corr) {
        g_snprintf(IMAGE_CORRELATION_LABEL, GPIV_MAX_CHARS, "cross-correlation");
    } else {
        g_snprintf(IMAGE_CORRELATION_LABEL, GPIV_MAX_CHARS, "auto-correlation");
    }
    g_snprintf(IMAGE_WIDTH_LABEL, GPIV_MAX_CHARS, "%d", gpiv_par.img_width);
    g_snprintf(IMAGE_HEIGHT_LABEL, GPIV_MAX_CHARS, "%d", gpiv_par.img_height);
    g_snprintf(IMAGE_DEPTH_LABEL, GPIV_MAX_CHARS, "%d", gpiv_par.img_depth);


#ifndef DISABLE_DAC
/*
 * parameter and variables initializing of data acquisition 
 * (trigger timings and camera)
 */
    gpiv_dac_parameters_logic(&dac_par, FALSE);
    if ((err_msg = 
         gpiv_scan_resourcefiles(GPIV_DAC_PAR_KEY, &dac_par, print_par))
        != NULL) /* g_message */ message_gpiv("%s: %s", RCSID, err_msg);
    gpiv_dac_default_parameters(&dac_par_default, TRUE);
    gpiv_dac_check_parameters_read(&dac_par, dac_par_default);

    if ((err_msg = gpiv_dac_get_camvar(&cam_var)) != NULL) {
        if (verbose) 
            warning_gpiv("from: main\n from: gpiv_dac_get_dacvar\n %s", 
                        err_msg);
        dac_trig = FALSE;
    }


    if (image_width != gpiv_par.img_width
        || image_height != gpiv_par.img_height) {
        message_gpiv(_("Image dimensions defined by command keys and differ from camera. Disabling camera"));
        cam_var.numCameras = 0;
    }

#endif /* DISABLE_DAC */

/* 
 * Reading image parameters. checking image_par is done in open_img (concole.c)
 */
    gpiv_img_parameters_logic(&image_par, FALSE);
    if ((err_msg = 
         gpiv_scan_resourcefiles(GPIV_IMAGE_PAR_KEY, &image_par, print_par))
        != NULL) g_message ("%s: %s", RCSID, err_msg);
    g_snprintf(image_par.software, GPIV_MAX_CHARS, "%s %s", PACKAGE, VERSION);
    image_par.software_logic = TRUE;

    g_snprintf(image_par.author, GPIV_MAX_CHARS, "%s", g_get_real_name ());
    image_par.author_logic = TRUE;

    gpiv_img_default_parameters(&image_par, FALSE);

    g_snprintf(IMAGE_WIDTH_LABEL, GPIV_MAX_CHARS, "%d", gpiv_par.img_width);

/* 
 * Reading piv_eval parameters.
 */
    gpiv_piv_parameters_logic(&piv_eval_par, FALSE);
    if ((err_msg = 
         gpiv_scan_resourcefiles(GPIV_EVAL_PAR_KEY, &piv_eval_par, print_par))
        != NULL) g_message ("%s: %s", RCSID, err_msg);
    gpiv_piv_default_parameters(&piv_eval_par_default, TRUE);
    gpiv_piv_check_parameters_read(&piv_eval_par, piv_eval_par_default);

    if (piv_eval_par.col_start > gpiv_par.img_width) {
        piv_eval_par.col_start = 0;
        if (verbose) 
            g_warning(_("col_start larger than img_width; \nset to zero"));
    }

    if (piv_eval_par.col_end > gpiv_par.img_width) {
        piv_eval_par.col_end = gpiv_par.img_width - 1;
        if (verbose) 
            g_warning(_("col_end larger than img_width; \nset to img_width - 1"));
    }

    if (piv_eval_par.row_start > gpiv_par.img_height) {
        piv_eval_par.row_start = 0;
        if (verbose) 
            g_warning(_("row_start larger than img_height; \nset to zero"));
    }

    if (piv_eval_par.row_end > gpiv_par.img_height) {
        piv_eval_par.row_end = gpiv_par.img_height - 1;
        if (verbose) 
            g_warning(_("row_end larger than img_height; \nset to img_height - 1"));
    }


/* 
 * Reading piv_valid parameters.
 */
    gpiv_valid_parameters_logic(&piv_valid_par, FALSE);
    if ((err_msg = 
         gpiv_scan_resourcefiles(GPIV_VALID_PAR_KEY, &piv_valid_par, print_par))
        != NULL) g_message ("%s: %s", RCSID, err_msg);
    gpiv_valid_default_parameters(&piv_valid_par_default, TRUE);
    gpiv_valid_check_parameters_read(&piv_valid_par, piv_valid_par_default);


/* 
 * Reading piv_post parameters.
 */
    gpiv_post_parameters_logic(&piv_post_par, FALSE);
    if ((err_msg = 
         gpiv_scan_resourcefiles(GPIV_POST_PAR_KEY, &piv_post_par, print_par))
        != NULL) g_message ("%s: %s", RCSID, err_msg);
    gpiv_post_default_parameters(&piv_post_par_default, TRUE);
    gpiv_post_check_parameters_read(&piv_post_par, piv_post_par_default);



    if(gpiv_par.img_width > 0 
       && gpiv_par.img_width <= IMAGE_WIDTH_MAX 
       && gpiv_par.img_height > 0
       && gpiv_par.img_height <= IMAGE_HEIGHT_MAX
       && gpiv_par.img_depth > 0
       && gpiv_par.img_depth <= IMAGE_DEPTH_MAX
       ) {
        image_par.ncolumns = gpiv_par.img_width;
        image_par.ncolumns_logic = TRUE;
        image_par.nrows = gpiv_par.img_height;
        image_par.nrows_logic = TRUE;
        image_par.depth = gpiv_par.img_depth;
        image_par.depth_logic = TRUE;
        
        if (verbose) 
            g_warning(_("image width = %d image height = %d\
 image colour depth = %d"),
                      gpiv_par.img_width, gpiv_par.img_height, 
                      gpiv_par.img_depth);
        
/*
 * creating the Graphic interface
 */
        gpiv = create_gpiv();
        gtk_widget_show(GTK_WIDGET (gpiv->console));        
        menu_gpiv_popup = create_menu_gpiv_popup(gpiv);
        gtk_signal_connect_object(GTK_OBJECT(gpiv->console), 
                                  "button_press_event",
                                  GTK_SIGNAL_FUNC (on_my_popup_handler), 
                                  GTK_OBJECT (menu_gpiv_popup));
        
        gnome_appbar_set_default(GNOME_APPBAR(gpiv->appbar), msg_default);
        gnome_appbar_push(GNOME_APPBAR(gpiv->appbar), msg);
        
        if(gpiv_par.show_tooltips) {
            gtk_tooltips_enable(gpiv->tooltips);
        } else {
            gtk_tooltips_disable(gpiv->tooltips);
        }
        
#ifndef DISABLE_DAC
/*
 * Widgets will be enabled / disabled if camera is connected 
 * and trigger kernel modules are loaded and accessible.
 * An info message will be displayed if features are absent
 */
        if (!gpiv_dac_openrtfs(&dac_init, &dac_start, &dac_stop, &dac_error)) {
            message_gpiv(_("Trigger system not available"));
            dac_trig = FALSE;
        }
        exec_trigger_stop ();
        sensitive(gpiv, DAC_TRIG, dac_trig);
        sensitive(gpiv, DAC_TIMING, dac_trig);
        
        if (!dac_trig && cam_var.numCameras == 0) {
            sensitive(gpiv, DAC, FALSE);
        } else {
            sensitive(gpiv, DAC, TRUE);
        }
        
        if (cam_var.numCameras > 0) { 
            sensitive(gpiv, DAC_CAM, TRUE);
            if (!dac_trig) {
                sensitive(gpiv, DAC_TIMING, TRUE);
            }
        } else{
            sensitive(gpiv, DAC_CAM, FALSE);
            if (!dac_trig) {
                sensitive(gpiv, DAC_TIMING, FALSE);
            }
            message_gpiv(_("No camera connected"));
        }
#endif /* DISABLE_DAC */
        
        sensitive(gpiv, IMG, TRUE);
        sensitive(gpiv, EVAL, TRUE);
        sensitive(gpiv, INTREGS, FALSE);
        sensitive(gpiv, VALID, TRUE);
        sensitive(gpiv, POST, TRUE);
    

    } else {
        error_gpiv(_("Image dimensions or depth are smaller than 0 or larger \
than %dx%d, %d)."),
                  (int)IMAGE_WIDTH_MAX, (int)IMAGE_HEIGHT_MAX, 
                  (int)IMAGE_DEPTH_MAX);
    }

    gtk_main();
    exit(0);
}
