/*
 * GooCanvas. Copyright (C) 2005 Damon Chaplin.
 * Released under the GNU LGPL license. See COPYING for details.
 *
 * goocanvasrectview.h - view for rect item.
 */
#ifndef __GOO_CANVAS_RECT_VIEW_H__
#define __GOO_CANVAS_RECT_VIEW_H__

#include <gtk/gtk.h>
#include "goocanvasitemviewsimple.h"
#include "goocanvasrect.h"

G_BEGIN_DECLS


#define GOO_TYPE_CANVAS_RECT_VIEW            (goo_canvas_rect_view_get_type ())
#define GOO_CANVAS_RECT_VIEW(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GOO_TYPE_CANVAS_RECT_VIEW, GooCanvasRectView))
#define GOO_CANVAS_RECT_VIEW_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GOO_TYPE_CANVAS_RECT_VIEW, GooCanvasRectViewClass))
#define GOO_IS_CANVAS_RECT_VIEW(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GOO_TYPE_CANVAS_RECT_VIEW))
#define GOO_IS_CANVAS_RECT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GOO_TYPE_CANVAS_RECT_VIEW))
#define GOO_CANVAS_RECT_VIEW_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GOO_TYPE_CANVAS_RECT_VIEW, GooCanvasRectViewClass))


typedef struct _GooCanvasRectView       GooCanvasRectView;
typedef struct _GooCanvasRectViewClass  GooCanvasRectViewClass;

/**
 * GooCanvasRectView
 *
 * The #GooCanvasRectView-struct struct contains private data only.
 */
struct _GooCanvasRectView
{
  GooCanvasItemViewSimple parent_object;
};

struct _GooCanvasRectViewClass
{
  GooCanvasItemViewSimpleClass parent_class;
};


GType              goo_canvas_rect_view_get_type (void) G_GNUC_CONST;
GooCanvasItemView* goo_canvas_rect_view_new      (GooCanvasView     *canvas_view,
						  GooCanvasItemView *parent_view,
						  GooCanvasRect     *rect);


G_END_DECLS

#endif /* __GOO_CANVAS_RECT_VIEW_H__ */
