/* $Id: userbox.cc,v 1.12 2002/03/10 18:37:10 bergo Exp $ */

/*

    GPS - Graphical Process Statistics
    Copyright (C) 1999-2002 Felipe Paulo Guazzi Bergo
    bergo@seul.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <unistd.h>
#include <pwd.h>
#include <grp.h>
#include <sys/types.h>
#include <gtk/gtk.h>
#include "transient.h"

#include "polling.h"
#include "userbox.h"
#include "userinfo.h"
#include "importglobals.h"

GtkWidget *ubox=NULL;
GtkWidget *da;
GdkPixmap *ucanvas=NULL;

GdkCursor *point,*hand;

GList *dcpu=NULL,*dmem=NULL;
GList *ulinks=NULL;

gint to_ubox=-1;

void pop_user_box(GtkWidget *gw,gpointer data) {
  GtkWidget *v1,*h1,*b1,*hs;
  char title[512],bu[128];

  if (netcritical)
    return;

  if (ubox!=NULL)
    return;

  point=gdk_cursor_new(GDK_LEFT_PTR);
  hand=gdk_cursor_new(GDK_HAND2);

  ubox=gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_position(GTK_WINDOW(ubox),GTK_WIN_POS_CENTER);
  gtk_widget_realize(ubox);
  gtk_window_set_policy(GTK_WINDOW(ubox),TRUE,TRUE,TRUE);
  gethostname(bu,256);
  snprintf(title,512,"gPS: User CPU and Memory Demand (%s)",bu);
  gtk_window_set_title(GTK_WINDOW(ubox),title);
  gtk_container_set_border_width(GTK_CONTAINER(ubox),4);

  v1=gtk_vbox_new(FALSE,2);
  gtk_container_add(GTK_CONTAINER(ubox),v1);

  da=gtk_drawing_area_new();
  gtk_widget_set_events(da,GDK_EXPOSURE_MASK|GDK_BUTTON_PRESS_MASK|
			GDK_POINTER_MOTION_MASK);
  gtk_drawing_area_size(GTK_DRAWING_AREA(da),500,300);

  gtk_box_pack_start(GTK_BOX(v1),da,TRUE,TRUE,2);

  hs=gtk_hseparator_new();
  gtk_box_pack_start(GTK_BOX(v1),hs,FALSE,FALSE,4);

  h1=gtk_hbutton_box_new();
  gtk_button_box_set_layout(GTK_BUTTON_BOX(h1), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing(GTK_BUTTON_BOX(h1), 5);

  gtk_box_pack_start(GTK_BOX(v1),h1,FALSE,FALSE,6);

  b1=gtk_button_new_with_label("Dismiss");
  GTK_WIDGET_SET_FLAGS(b1,GTK_CAN_DEFAULT);
  gtk_box_pack_start(GTK_BOX(h1),b1,TRUE,TRUE,0);

  gtk_signal_connect(GTK_OBJECT(b1),"clicked",
		     GTK_SIGNAL_FUNC(close_user_box),NULL);
  gtk_signal_connect (GTK_OBJECT (ubox), "destroy",
		      GTK_SIGNAL_FUNC (destroy_user_box), NULL);

  gtk_signal_connect (GTK_OBJECT (da), "expose_event",
		      (GtkSignalFunc) ubox_expose_event, NULL);
  gtk_signal_connect (GTK_OBJECT (da), "configure_event",
		      (GtkSignalFunc) ubox_configure_event, NULL);
  gtk_signal_connect (GTK_OBJECT (da), "button_press_event",
		      (GtkSignalFunc) ubox_bpress_event, NULL);
  gtk_signal_connect (GTK_OBJECT (da), "motion_notify_event",
		      (GtkSignalFunc) ubox_motion_event, NULL);

  gtk_widget_grab_default(b1);

  gtk_widget_show(v1);
  gtk_widget_show(da);
  gtk_widget_show(h1);
  gtk_widget_show(hs);
  gtk_widget_show(b1);

  gtk_widget_show(ubox);

  refresh_ubox(NULL);
  to_ubox=gtk_timeout_add(1000,refresh_ubox,NULL);
}

void close_user_box(GtkWidget *w, gpointer data) {
  gtk_widget_destroy(ubox);
  ubox=NULL;
}

void destroy_user_box(GtkWidget *w,gpointer data) {
  int i;
  if (to_ubox>=0)
    gtk_timeout_remove(to_ubox);
  to_ubox=-1;

  gdk_pixmap_unref(ucanvas); ucanvas=NULL;
  gdk_cursor_destroy(point);
  gdk_cursor_destroy(hand);
  ubox_reset_lists();
  ubox_reset_links();
  ubox=NULL;
}

// drawing

gboolean ubox_configure_event(GtkWidget *widget,GdkEventConfigure *ce,
			    gpointer data) {
  GdkGC *mygc;
  int x,y;
  int b,cy,h,lw,gb,gh,gsy;
  GList *pt;
  UserBoxMemTuple *p1;
  UserBoxCpuTuple *p2;
  GdkFont *fnt;
  float pct,gpct;
  char zb[16];
  UserLink *ul;
  char *lastgr;
  static char *placeholder="aaa";
  
  ubox_reset_links();

  if (ucanvas!=NULL)
    gdk_pixmap_unref(ucanvas);

  mygc=gdk_gc_new(widget->window);
  
  ucanvas=gdk_pixmap_new(widget->window,x=widget->allocation.width,
			  y=widget->allocation.height,-1);
  gdk_draw_rectangle(ucanvas,widget->style->black_gc,TRUE,0,0,x,y);

  fnt=gdk_font_load("-*-helvetica-medium-r-*-*-12-*-*-*-*-*-*-*");

  if (dmem!=NULL) {
    cy=20;
    b=0;

    lastgr=placeholder;
    gb=0;
    gsy=20;
    gh=0;
    gpct=0.0;

    for(pt=dmem;pt!=NULL;pt=g_list_next(pt)) {
      p1=(UserBoxMemTuple *)(pt->data);
      h=(int)(((float)(y-40))*(pct=ubox_mem_fraction(p1->membytes)));

      if (g_list_next(pt)==NULL)
	h=(y-20)-cy;
     
      // group
      if (strcmp(p1->groupname,lastgr)!=0) {
	gb=(++gb)%2;

	// paint label of last one
	if (gh>12) {
	  gdk_rgb_gc_set_foreground(mygc,c_ubox_link);
	  gdk_draw_string(ucanvas,fnt,mygc,
			  x/2+48-3-gdk_string_width(fnt,lastgr),
			  gsy+gh/2+5,lastgr);
	  gdk_rgb_gc_set_foreground(mygc,0);
	  snprintf(zb,16,"%d%%",(int)rint(gpct*100.0));
	  zb[15]=0;
	  gdk_draw_string(ucanvas,fnt,mygc,
			  x/2+48+24-gdk_string_width(fnt,zb)/2,
			  gsy+gh/2+5,zb);
	}

	gsy+=gh;
	gh=0;
	gpct=0.0;
      }

      gh+=h;
      gpct+=pct;
      lastgr=p1->groupname;

      if (gb%2)
	gdk_rgb_gc_set_foreground(mygc,c_ubox_mem_a&0x00ffff);
      else
	gdk_rgb_gc_set_foreground(mygc,c_ubox_mem_b&0x00ffff);

      gdk_draw_rectangle(ucanvas,mygc,TRUE,x/2+48,cy,48,h);

      // individual
      if (b%2)
	gdk_rgb_gc_set_foreground(mygc,c_ubox_mem_a);
      else
	gdk_rgb_gc_set_foreground(mygc,c_ubox_mem_b);

      gdk_draw_rectangle(ucanvas,mygc,TRUE,96+x/2,cy,48,h);
      b=(++b)%2;

      if (h>12) {
	if (b%2)
	  gdk_rgb_gc_set_foreground(mygc,c_ubox_mem_c);
	else
	  gdk_rgb_gc_set_foreground(mygc,c_ubox_mem_d);

	snprintf(zb,16,"%d%%",(int)rint(pct*100.0));
	zb[15]=0;
	gdk_draw_string(ucanvas,fnt,mygc,
			x/2+96+(48-gdk_string_width(fnt,zb))/2,
			cy+h/2+5,zb);
      }

      if (h>12) {
	gdk_rgb_gc_set_foreground(mygc,c_ubox_uline);
	gdk_draw_line(ucanvas,mygc,x/2+144+24,cy+h/2+6+3,
		      x/2+144+24+(lw=gdk_string_width(fnt,p1->username)),
		      cy+h/2+6+3);
	gdk_rgb_gc_set_foreground(mygc,c_ubox_link);
	gdk_draw_line(ucanvas,mygc,x/2+144,cy+h/2,x/2+144+16,cy+h/2);
	gdk_draw_string(ucanvas,fnt,mygc,x/2+144+24,cy+h/2+6,p1->username);

	ul=new UserLink();
	strcpy(ul->username,p1->username);
	ul->x=x/2+144+24;
	ul->y=cy+h/2+6-12;
	ul->w=lw;
	ul->h=15;
	ulinks=g_list_append(ulinks,(gpointer)ul);
      }

      cy+=h;
    }

    // paint last one
    if (gh>12) {
      gdk_rgb_gc_set_foreground(mygc,c_ubox_link);
      gdk_draw_string(ucanvas,fnt,mygc,
		      x/2+48-3-gdk_string_width(fnt,lastgr),
		      gsy+gh/2+5,lastgr);
      gdk_rgb_gc_set_foreground(mygc,0);
      snprintf(zb,16,"%d%%",(int)rint(gpct*100.0));
      zb[15]=0;
      gdk_draw_string(ucanvas,fnt,mygc,
		      x/2+48+24-gdk_string_width(fnt,zb)/2,
		      gsy+gh/2+5,zb);
    }

    gdk_rgb_gc_set_foreground(mygc,c_ubox_border);
    gdk_draw_rectangle(ucanvas,mygc,FALSE,x/2+48,20,96,y-41);
  }

  if (dcpu!=NULL) {
    cy=20;
    b=0;

    lastgr=placeholder;
    gb=0;
    gsy=20;
    gh=0;
    gpct=0.0;

    for(pt=dcpu;pt!=NULL;pt=g_list_next(pt)) {
      p2=(UserBoxCpuTuple *)(pt->data);
      h=(int)(((float)(y-40))*(pct=ubox_cpu_fraction(p2->cpuusage)));

      if (g_list_next(pt)==NULL)
	h=(y-20)-cy;

      // group
      if (strcmp(p2->groupname,lastgr)!=0) { 
	gb=(++gb)%2;

	// paint label of last one
	if (gh>12) {
	  gdk_rgb_gc_set_foreground(mygc,c_ubox_link);
	  gdk_draw_string(ucanvas,fnt,mygc,
			  15+48-3-gdk_string_width(fnt,lastgr),
			  gsy+gh/2+5,lastgr);
	  gdk_rgb_gc_set_foreground(mygc,0);
	  snprintf(zb,16,"%d%%",(int)rint(gpct*100.0));
	  zb[15]=0;
	  gdk_draw_string(ucanvas,fnt,mygc,
			  15+48+24-gdk_string_width(fnt,zb)/2,
			  gsy+gh/2+5,zb);
	}
	gsy+=gh;
	gh=0;
	gpct=0.0;
      }

      gh+=h;
      gpct+=pct;

      if (gb%2)
	gdk_rgb_gc_set_foreground(mygc,0xff8050);
      else
	gdk_rgb_gc_set_foreground(mygc,0xffff80);

      gdk_draw_rectangle(ucanvas,mygc,TRUE,15+48,cy,48,h);
      lastgr=p2->groupname;

      // individual
      if (b%2)
	gdk_rgb_gc_set_foreground(mygc,c_ubox_cpu_a);
      else
	gdk_rgb_gc_set_foreground(mygc,c_ubox_cpu_b);

      gdk_draw_rectangle(ucanvas,mygc,TRUE,15+96,cy,48,h);
      b=(++b)%2;

      if (h>12) {
	if (b%2)
	  gdk_rgb_gc_set_foreground(mygc,c_ubox_cpu_c);
	else
	  gdk_rgb_gc_set_foreground(mygc,c_ubox_cpu_d);
	snprintf(zb,16,"%d%%",(int)rint(pct*100.0));
	zb[15]=0;
	gdk_draw_string(ucanvas,fnt,mygc,
			15+96+(48-gdk_string_width(fnt,zb))/2,
			cy+h/2+5,zb);
      }

      if (h>12) {
	gdk_rgb_gc_set_foreground(mygc,c_ubox_uline);
	gdk_draw_line(ucanvas,mygc,15+144+24,cy+h/2+6+3,
		      15+144+24+gdk_string_width(fnt,p2->username),
		      cy+h/2+6+3);
	gdk_rgb_gc_set_foreground(mygc,c_ubox_link);
	gdk_draw_line(ucanvas,mygc,15+144,cy+h/2,15+144+16,cy+h/2);
	gdk_draw_string(ucanvas,fnt,mygc,15+144+24,cy+h/2+6,p2->username);

	ul=new UserLink();
	strcpy(ul->username,p2->username);
	ul->x=15+144+24;
	ul->y=cy+h/2+6-12;
	ul->w=lw;
	ul->h=15;
	ulinks=g_list_append(ulinks,(gpointer)ul);
      }

      cy+=h;
    }

    // last one
    if (gh>12) {
      gdk_rgb_gc_set_foreground(mygc,c_ubox_link);
      gdk_draw_string(ucanvas,fnt,mygc,
		      15+48-3-gdk_string_width(fnt,lastgr),
		      gsy+gh/2+5,lastgr);
      gdk_rgb_gc_set_foreground(mygc,0);
      snprintf(zb,16,"%d%%",(int)rint(gpct*100.0));
      zb[15]=0;
      gdk_draw_string(ucanvas,fnt,mygc,
		      15+48+24-gdk_string_width(fnt,zb)/2,
		      gsy+gh/2+5,zb);
    }

    gdk_rgb_gc_set_foreground(mygc,c_ubox_border);
    gdk_draw_rectangle(ucanvas,mygc,FALSE,15+48,20,96,y-41);
  }

  gdk_rgb_gc_set_foreground(mygc,c_ubox_label);
  gdk_draw_string(ucanvas,fnt,mygc,15+96-gdk_string_width(fnt,"%CPU")/2,
		  y-5,"%CPU");
  gdk_draw_string(ucanvas,fnt,mygc,1+15+96-gdk_string_width(fnt,"%CPU")/2,
		  y-5,"%CPU");

  gdk_draw_string(ucanvas,fnt,mygc,15+48-gdk_string_width(fnt,"groups"),
		  y-5,"groups");
  gdk_draw_string(ucanvas,fnt,mygc,15+144,
		  y-5,"users");

  gdk_draw_string(ucanvas,fnt,mygc,x/2+96-gdk_string_width(fnt,"Memory")/2,
		  y-5,"Memory");
  gdk_draw_string(ucanvas,fnt,mygc,1+x/2+96-gdk_string_width(fnt,"Memory")/2,
		  y-5,"Memory");

  gdk_draw_string(ucanvas,fnt,mygc,x/2+48-gdk_string_width(fnt,"groups"),
		  y-5,"groups");
  gdk_draw_string(ucanvas,fnt,mygc,x/2+144,
		  y-5,"users");

  gdk_font_unref(fnt);
  gdk_gc_destroy(mygc);
  return FALSE;
}

gboolean ubox_expose_event(GtkWidget *widget,GdkEventExpose *ee,
			    gpointer data) {
  gdk_draw_pixmap(widget->window,
		  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		  ucanvas,
		  ee->area.x, ee->area.y,
		  ee->area.x, ee->area.y,
		  ee->area.width, ee->area.height);
  return FALSE;
}

/* update */

gint refresh_ubox(gpointer data) {
  GList *pd;
  GList *pr,*ps;
  UserBoxCpuTuple *ubct,*p1;
  UserBoxMemTuple *ubmt,*p2;
  ProcessListItem *pli;
  int ac;

  if (ubox==NULL)
    return FALSE;

  list_poller->poll();
  pd=g_list_copy(list_poller->process_list);

  ubox_reset_lists();

  for(pr=pd;pr!=NULL;pr=g_list_next(pr)) {
    
    pli=(ProcessListItem *)(pr->data);

    // cpu
    ac=0;
    for(ps=dcpu;ps!=NULL;ps=g_list_next(ps)) {
      p1=(UserBoxCpuTuple *)(ps->data);
      if (!strcmp(p1->username,pli->owner)) {
	ac=1;
	p1->cpuusage+=atof(strtok(pli->cpu,"%\n"));
      }	
    }
    
    if (!ac) {
      ubct=new UserBoxCpuTuple();
      strcpy(ubct->username,pli->owner);
      query_group(ubct->groupname,ubct->username,64);
      ubct->cpuusage=atof(strtok(pli->cpu,"%\n"));
      dcpu=g_list_append(dcpu,(gpointer)(ubct));
    }

    // mem
    ac=0;
    for(ps=dmem;ps!=NULL;ps=g_list_next(ps)) {
      p2=(UserBoxMemTuple *)(ps->data);
      if (!strcmp(p2->username,pli->owner)) {
	ac=1;
	p2->membytes+=gps_memvalue(pli->size);
      }	
    }
    
    if (!ac) {
      ubmt=new UserBoxMemTuple();
      strcpy(ubmt->username,pli->owner);
      query_group(ubmt->groupname,ubmt->username,64);
      ubmt->membytes=gps_memvalue(pli->size);
      dmem=g_list_append(dmem,(gpointer)(ubmt));
    }

  }

  /* sort everybody */

  dcpu=g_list_sort(dcpu,(GCompareFunc)ubox_cpu_cmp);
  dmem=g_list_sort(dmem,(GCompareFunc)ubox_mem_cmp);

  // now sort for group name
  dcpu=g_list_sort(dcpu,(GCompareFunc)ubox_cpu_cmp_gr);
  dmem=g_list_sort(dmem,(GCompareFunc)ubox_mem_cmp_gr);

  ubox_configure_event(da,NULL,NULL);
  gtk_widget_queue_draw(da);
  g_list_free(pd);
  return TRUE;
}

long gps_memvalue(char *s) {
  char t[128];
  long v;

  strcpy(t,s);
  v=atol(strtok(t,"KMGTP"));
  
  switch(s[strlen(s)-1]) {
  case 'K': v<<=10; break;
  case 'M': v<<=20; break;
  case 'G': v<<=30; break;
  }
  return v;
}

void query_group(char *dest,char *user,int maxc) {
  struct passwd *pws;
  struct group  *grs;
  pws=getpwnam(user);
  if (pws==NULL) { strncpy(dest,"(UNKNOWN)",maxc); return; }
  grs=getgrgid(pws->pw_gid);
  if (grs==NULL) { strncpy(dest,"(UNKNOWN)",maxc); return; }
  strncpy(dest,grs->gr_name,maxc);
}

gint ubox_mem_cmp(const gpointer a,const gpointer b) {
  UserBoxMemTuple *p1,*p2;
  p1=(UserBoxMemTuple *)a;
  p2=(UserBoxMemTuple *)b;
  if ((p1->membytes)>(p2->membytes))
    return 1;
  if ((p1->membytes)<(p2->membytes))
    return -1;
  return 0;
}

gint ubox_cpu_cmp(const gpointer a,const gpointer b) {
  UserBoxCpuTuple *p1,*p2;
  p1=(UserBoxCpuTuple *)a;
  p2=(UserBoxCpuTuple *)b;
  if ((p1->cpuusage)>(p2->cpuusage))
    return 1;
  if ((p1->cpuusage)<(p2->cpuusage))
    return -1;
  return 0;
}

gint ubox_mem_cmp_gr(const gpointer a,const gpointer b) {
  UserBoxMemTuple *p1,*p2;
  p1=(UserBoxMemTuple *)a;
  p2=(UserBoxMemTuple *)b;
  return(strcmp(p1->groupname,p2->groupname));
}

gint ubox_cpu_cmp_gr(const gpointer a,const gpointer b) {
  UserBoxCpuTuple *p1,*p2;
  p1=(UserBoxCpuTuple *)a;
  p2=(UserBoxCpuTuple *)b;
  return(strcmp(p1->groupname,p2->groupname));
}

void ubox_reset_lists() {
  GList *pt;
  if (dcpu!=NULL) {
    for(pt=dcpu;pt!=NULL;pt=g_list_next(pt))
      delete( (UserBoxCpuTuple *)(pt->data) );
    g_list_free(dcpu);
    dcpu=NULL;
  }
  if (dmem!=NULL) {
    for(pt=dmem;pt!=NULL;pt=g_list_next(pt))
      delete( (UserBoxMemTuple *)(pt->data) );
    g_list_free(dmem);
    dmem=NULL;
  }
}

void ubox_reset_links() {
  GList *pt;
  if (ulinks!=NULL) {
    for(pt=ulinks;pt!=NULL;pt=g_list_next(pt))
      delete( (UserLink *)(pt->data) );
    g_list_free(ulinks);
    ulinks=NULL;
  }
}

float ubox_mem_fraction(long value) {
  long tt;
  float a,b;
  GList *pt;
  UserBoxMemTuple *p1;
  if (dmem==NULL) return 0.0;
  
  tt=0;
  for(pt=dmem;pt!=NULL;pt=g_list_next(pt)) {
    p1=(UserBoxMemTuple *)(pt->data);
    tt+=p1->membytes;
  }

  a=(float)tt;
  if (a==0.0) a=1.0;
  b=(float)value;

  a=b/a;
  return(a);
}

float ubox_cpu_fraction(float value) {
  float tt;
  float b;
  GList *pt;
  UserBoxCpuTuple *p1;
  if (dcpu==NULL) return 0.0;
  
  tt=0.0;
  for(pt=dcpu;pt!=NULL;pt=g_list_next(pt)) {
    p1=(UserBoxCpuTuple *)(pt->data);
    tt+=p1->cpuusage;
  }

  if (tt==0.0) tt=1.0;

  b=value/tt;
  return(b);
}

/// USER LINK

int UserLink::hit(int a,int b) {
  if ((a>=x)&&(a<(x+w))&&(b>=y)&&(b<(y+h)))
    return 1;
  else
    return 0;
}

gboolean ubox_bpress_event(GtkWidget *widget,GdkEventButton *be,
			   gpointer data) {
  GList *pt;
  UserLink *ul;
  int x,y;

  if ((be==NULL)||(ulinks==NULL))
    return FALSE;

  x=(int)(be->x);
  y=(int)(be->y);

  for(pt=ulinks;pt!=NULL;pt=g_list_next(pt)) {
    ul=(UserLink *)(pt->data);
    if (ul->hit(x,y)) {
      uinfo_pop(ul->username);
      break;
    }
  }

  return FALSE;
}

gboolean ubox_motion_event(GtkWidget *widget,GdkEventMotion *gem,
			   gpointer data) {
  GList *pt;
  UserLink *ul;
  int x,y;

  if ((gem==NULL)||(ulinks==NULL))
    return FALSE;

  x=(int)(gem->x);
  y=(int)(gem->y);

  for(pt=ulinks;pt!=NULL;pt=g_list_next(pt)) {
    ul=(UserLink *)(pt->data);
    if (ul->hit(x,y)) {
      gdk_window_set_cursor(da->window,hand);
      return FALSE;
    }
  }
  gdk_window_set_cursor(da->window,point);
  return FALSE;
}
