/* gpsk31  - PSK31 for Linux with a GTK+ Interface
 * Copyright (C) 2000 Luc Langehegermann, LX2GT
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 */

/*
 * These are the functions needed for the file send/receive functions
 */


#include <gtk/gtk.h>
#include <string.h>
#include <stdio.h>
#include <time.h>
#include "file.h"
#include "misc.h"
#include "server.h"
#include "globals.h"
#include "main.h"
#include "text.h"

FILE *log_fp = (FILE *) 0;

/*
 *  First the send file handling
 */

/*
 * This function creates an File dialog for the file to be send
 */

void
file_send_dialog ()
{
  static GtkWidget *window = NULL;

  if (!window)
    {
      window = gtk_file_selection_new ("Send File");
      gtk_signal_connect (GTK_OBJECT (window), "destroy",
			  GTK_SIGNAL_FUNC (gtk_widget_destroyed), &window);

      gtk_window_set_policy (GTK_WINDOW (window), 0, 0, 0);
      gtk_window_set_position (GTK_WINDOW (window), GTK_WIN_POS_CENTER);

      gtk_signal_connect_object (GTK_OBJECT
				 (GTK_FILE_SELECTION (window)->cancel_button),
				 "clicked",
				 GTK_SIGNAL_FUNC (gtk_widget_destroy),
				 GTK_OBJECT (window));

      gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (window)->ok_button),
			  "clicked", GTK_SIGNAL_FUNC (file_send), window);

      gtk_widget_show (window);
    }

}

/*
 * Here we read the file, and put it into the TX Buffer/Screen
 * We use a GTimer here, so that the main loop will still be processed
 * While we read the file
 */


void
file_send (GtkWidget * widget, GtkFileSelection * fs)
{
  char buffer[256];
  FILE *fp = (FILE *) 0;
  /*
   * Read the Filename from the Dialog and put it into the
   * filename array
   */

  char
    filename[strlen
	     (gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs)))];
  strcpy (filename,
	  gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs)));
  gtk_widget_destroy (GTK_WIDGET (fs));

  /*
   * Try to open the file for reading - if it fails
   * Display an error dialog and return
   */

  fp = fopen (filename, "r");
  if (!fp)
    error_dialog ("\n Unable to find File! \n");
  else
    {
      while (fgets (buffer, 255, fp) != NULL)
	{
	  commPutData (buffer, 0);
	  put_tx_window (buffer);
	}

    }
  fclose (fp);
  fp = (FILE *) 0;
}


void
save_log_dialog ()
{
  static GtkWidget *window;

  if (log_fp)
    error_dialog ("\nLogfile already open!\n");
  else if (!window)
    {
      window = gtk_file_selection_new ("Log to File");
      gtk_signal_connect (GTK_OBJECT (window), "destroy",
			  GTK_SIGNAL_FUNC (gtk_widget_destroyed), &window);

      gtk_window_set_policy (GTK_WINDOW (window), 0, 0, 0);
      gtk_window_set_position (GTK_WINDOW (window), GTK_WIN_POS_CENTER);

      gtk_signal_connect_object (GTK_OBJECT
				 (GTK_FILE_SELECTION (window)->cancel_button),
				 "clicked",
				 GTK_SIGNAL_FUNC (gtk_widget_destroy),
				 GTK_OBJECT (window));

      gtk_signal_connect (GTK_OBJECT
			  (GTK_FILE_SELECTION (window)->ok_button),
			  "clicked", GTK_SIGNAL_FUNC (open_logfile), window);

      gtk_widget_show (window);
    }

}

void
logfile(char *filename)
{
  char *time_string;
  
  log_fp = fopen (filename, "a");
  if (!log_fp)
    error_dialog ("\n Unable to Open File! \n");
  else
    {
      time_string = get_time_string (NULL);

      /* Write a string, so that the uses sees when the log was started */

      put_logfile ("\n\n<<<<<< Log Opened at: ");
      put_logfile (time_string);
      put_logfile (" >>>>>>\n\n");
      g_free (time_string);
    }
}

/*
 * Opens the file for writing - but does actually no writing
 */


void
open_logfile (GtkWidget * widget, GtkFileSelection * fs)
{
  char  filename[strlen
	     (gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs)))];
  strcpy (filename,
	  gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs)));
  gtk_widget_destroy (GTK_WIDGET (fs));
  logfile(filename);
}

/*
 * Writes characters to the log file it open
 * Called by the main loop
 */

void
put_logfile (gchar * text)
{
  if (log_fp)
    fputs (text, log_fp);
}

void
close_logfile ()
{
  if (log_fp)
    {
      char *time_string = get_time_string (NULL);
      put_logfile ("\n\n<<<<<< Log Closed at: ");
      put_logfile (get_time_string (NULL));
      put_logfile (" >>>>>>\n\n");
      g_free (time_string);
      fclose (log_fp);
      log_fp = (FILE *) 0;
    }
  else
    error_dialog ("\n No Logfile Open! \n");
}

void
error_dialog (gchar * text)
{
  static GtkWidget *window = NULL;
  static GtkWidget *label;
  static GtkWidget *ok_button;

  if (!window)
    {

      window = gtk_dialog_new ();
      gtk_signal_connect (GTK_OBJECT (window), "destroy",
			  GTK_SIGNAL_FUNC (gtk_widget_destroyed), &window);
      gtk_window_set_title (GTK_WINDOW (window), "ERROR");
      label = gtk_label_new (text);
      gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window)->vbox), label, TRUE,
			  TRUE, 0);
      ok_button = gtk_button_new_with_label ("OK");
      gtk_widget_set_usize (ok_button, 75, 0);
      gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window)->action_area),
			  ok_button, TRUE, FALSE, 0);
      gtk_window_set_policy (GTK_WINDOW (window), 0, 0, 0);
      gtk_widget_grab_focus (ok_button);

      gtk_signal_connect_object (GTK_OBJECT (ok_button), "clicked",
				 GTK_SIGNAL_FUNC (gtk_widget_destroy),
				 GTK_OBJECT (window));

    }
  if (!GTK_WIDGET_VISIBLE (window))
    gtk_widget_show_all (window);
}
