### Copyright (C) 2005 Peter Williams <pwil3058@bigpond.net.au>

### This program is free software; you can redistribute it and/or modify
### it under the terms of the GNU General Public License as published by
### the Free Software Foundation; version 2 of the License only.

### This program is distributed in the hope that it will be useful,
### but WITHOUT ANY WARRANTY; without even the implied warranty of
### MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
### GNU General Public License for more details.

### You should have received a copy of the GNU General Public License
### along with this program; if not, write to the Free Software
### Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import gtk, gtk.gdk, os

pop = "gquilt_pop"
push = "gquilt_push"
fold = "gquilt_fold"
import_patch = "gquilt_import"
diff = "gquilt_diff"
meld = "gquilt_meld"
applied_ok = "gquilt_tick"
applied_not_ok = "gquilt_cross"
top_ok = "gquilt_tick"
top_not_ok = "gquilt_cross"

libdir = os.environ['GQUILT_LIB_DIR'] + "/icons"

factory = gtk.IconFactory()

def add_icon(factory, name):
    pb = gtk.gdk.pixbuf_new_from_file(libdir + "/" + name + ".png")
    iset = gtk.IconSet(pb)
    factory.add(name, iset)

add_icon(factory, pop)
add_icon(factory, push)
add_icon(factory, fold)
add_icon(factory, import_patch)
add_icon(factory, diff)
add_icon(factory, meld)
add_icon(factory, applied_ok)
add_icon(factory, applied_not_ok)
add_icon(factory, top_ok)
add_icon(factory, top_not_ok)

factory.add_default()
