# -*- python -*-

### Copyright (C) 2005 Peter Williams <pwil3058@bigpond.net.au>

### This program is free software; you can redistribute it and/or modify
### it under the terms of the GNU General Public License as published by
### the Free Software Foundation; version 2 of the License only.

### This program is distributed in the hope that it will be useful,
### but WITHOUT ANY WARRANTY; without even the implied warranty of
### MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
### GNU General Public License for more details.

### You should have received a copy of the GNU General Public License
### along with this program; if not, write to the Free Software
### Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# This file describes the interface that must be implemented for each
# underlying tool in order for gquilt to provide an interface to for the tool

OK = 0
ERROR = 1
ERROR_FORCE = 2
ERROR_REFRESH = 4
ERROR_FORCE_OR_REFRESH = 6

NOT_APPLIED = " "
APPLIED = "+"
APPLIED_NEEDS_REFRESH = "?"
TOP_PATCH = "="
TOP_PATCH_NEEDS_REFRESH = "!"

EXTANT = " "
ADDED = "+"
DELETED = "-"

class interface:
    def __init__(self, name):
        self.name = name
    def is_patch_applied(self, patch):
        assert 0, 'is_patch_applied() must be provided in child class!!!'
    def top_patch(self):
        assert 0, 'top_patch() must be provided in child class!!!'
    def last_patch_in_series(self):
        assert 0, 'last_patch_in_series() must be provided in child class!!!'
    def display_file_diff_in_viewer(self, viewer, file, patch=None):
        assert 0, 'display_file_diff_in_viewer() must be provided in child class!!!'
    def get_patch_status(self, patch):
        assert 0, 'get_patch_status() must be provided in child class!!!'
    def get_patch_description(self, patch):
        assert 0, 'get_patch_description() must be provided in child class!!!'
    def get_series(self):
        assert 0, 'get_series() must be provided in child class!!!'
    def get_diff(self, filelist=[], patch=None):
        assert 0, 'get_diff() must be provided in child class!!!'
    def get_combined_diff(self, start_patch=None, end_patch=None):
        assert 0, 'get_combined_diff() must be provided in child class!!!'
    def get_patch_files(self, patch=None, withstatus=True):
        assert 0, 'get_patch_files() must be provided in child class!!!'
    def do_set_patch_description(self, console, patch, description):
        assert 0, 'do_set_patch_description() must be provided in child class!!!'
    def do_rename_patch(self, console, patch, newname):
        assert 0, 'do_rename_patch() must be provided in child class!!!'
    def do_pop_patch(self, console, force=False):
        assert 0, 'do_pop_patch() must be provided in child class!!!'
    def do_push_patch(self, console, force=False):
        assert 0, 'do_push_patch() must be provided in child class!!!'
    def do_pop_to_patch(self, console, patch=None):
        assert 0, 'do_pop_to_patch() must be provided in child class!!!'
    def do_push_to_patch(self, console, patch=None):
        assert 0, 'do_push_to_patch() must be provided in child class!!!'
    def do_refresh_patch(self, console, patch=None, force=False):
        assert 0, 'do_refresh_patch() must be provided in child class!!!'
    def do_create_new_patch(self, console, name):
        assert 0, 'do_create_new_patch() must be provided in child class!!!'
    def do_import_patch(self, console, filename):
        assert 0, 'do_import_patch() must be provided in child class!!!'
    def do_merge_patch(self, console, filename):
        assert 0, 'do_merge_patch() must be provided in child class!!!'
    def do_delete_patch(self, console, patch):
        assert 0, 'do_delete_patch() must be provided in child class!!!'
    def do_add_files_to_patch(self, console, filelist, patch=None):
        assert 0, 'do_add_files_to_patch() must be provided in child class!!!'
    def do_remove_files_from_patch(self, console, filelist, patch=None):
        assert 0, 'do_remove_files_from_patch() must be provided in child class!!!'
    def do_exec_tool_cmd(self, console, cmd):
        assert 0, 'do_exec_tool_cmd() must be provided in child class!!!'
