/* interface.c
 * Contains detection routines for the kernel interface to the card.
 */

/* (c) 1998-2000 by Keith Wesolowski (wesolows@foobazco.org)

 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version. 

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details. 

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 */

#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <linux/videodev.h>
#include "gradio.h"

extern radio_status gr_stat;

void gradio_get_interface (void)
{

    /* First determine whether we can use the kernel interface */
    int fd;
    struct video_tuner vt;
    double fact;
        if ((fd = open (gr_stat.dev_name, O_RDONLY)) > 0) {
	gr_stat.fd = fd;
	vt.tuner = 0;
	fact = gradio_get_freq_fact ();
	if (ioctl (fd, VIDIOCGTUNER, &vt)) {
	    gr_stat.freq_max = GR_FREQ_MAX;
	    gr_stat.freq_min = GR_FREQ_MIN;
	} else {
#ifdef OVERRIDE_FREQ
	    gr_stat.freq_max = GR_FREQ_MAX;
	    gr_stat.freq_min = GR_FREQ_MIN;
#else
	    gr_stat.freq_max = (int)(vt.rangehigh / fact);
	    gr_stat.freq_min = (int)(vt.rangelow / fact);
#endif
	}
    } else {
	fprintf (stderr, "No interface found!\n");
	exit (1);
    }
}
