// -*- c++ -*-
// Generated by assa-genesis
//------------------------------------------------------------------------------
// $Id: DeckManager.h,v 1.13 2005/05/16 03:02:02 vlg Exp $
//------------------------------------------------------------------------------
//                            DeckManager.h
//------------------------------------------------------------------------------
//  Copyright (c) 2004 by Vladislav Grinchenko 
//
//  This program is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License   
//  as published by the Free Software Foundation; either version  
//  2 of the License, or (at your option) any later version.      
//------------------------------------------------------------------------------
//
// Date   : Tue Feb  3 13:40:25 EST 2004
//
//------------------------------------------------------------------------------
#ifndef DECK_MANAGER_H
#define DECK_MANAGER_H

#ifdef HAVE_CONFIG_H
#    include "config.h"
#endif

#include <vector>
#include <sigc++/object.h>

#include "Granule-main.h"

class Deck;
class DeckPlayer;
class DeckList;
class CardRef;

class DeckManager : public virtual sigc::trackable
{
public:
    DeckManager ();
    ~DeckManager ();

	/** -*- Toolbar Callbacks -*-
        [Deck] Menu
	*/
    void new_deck_cb      ();
	void play_deck_cb     ();
	void insert_deck_cb   ();
	void import_deck_cb   ();
    void open_deck_cb     ();
    void save_deck_cb     ();
    void save_as_deck_cb  ();
	void save_all_deck_cb ();
	void add_deck_to_box  (int idx_);

	/** Deck reports back to the manager when it is
		completely loaded into memory from XML file.

		If parsing succeeded, status is set to 'completed'.
		Otherwise, it is set to 'failed'.
	*/
	void on_deck_loaded (Deck* deck_, DeckLoadStatus status_);
	
	/** Look up the card in the list of decks by (ID, PATH) pair.
		If deck is not loaded, it will be. The card is searched
		in the deck by its ID.

		@param id_   Card's ID
		@param path_ Deck's full path

		@return pointer to a newly created CardRef if found; NULL if either
		deck cannot be loaded or card is not found.
	*/
	CardRef* lookup_card (long id_, const string& path_);

	/** Some preferences might have changed. 
		Ask each opened DeckPlayer repaint itself according
		to the new configuration.
	*/
	void repaint_deck_players ();

private:
	typedef std::vector<DeckPlayer*> DeckPlayerVector;
	typedef DeckPlayerVector::iterator DeckPlayerVectorIter;

private:
	DeckPlayerVector m_players;
	unsigned         m_untitled_count;
};

#endif // DECK_MANAGER_H

