/* $Id: gv_cairo_select_font_face.c,v 1.2 2005/11/28 21:28:50 ellson Exp $ $Revision: 1.2 $ */
/* vim:set shiftwidth=4 ts=8: */

/**********************************************************
*      This software is part of the graphviz package      *
*                http://www.graphviz.org/                 *
*                                                         *
*            Copyright (c) 1994-2004 AT&T Corp.           *
*                and is licensed under the                *
*            Common Public License, Version 1.0           *
*                      by AT&T Corp.                      *
*                                                         *
*        Information and Software Systems Research        *
*              AT&T Research, Florham Park NJ             *
**********************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <strings.h>

#ifdef HAVE_CAIRO
#include <cairo.h>
#endif

#ifdef CAIRO_HAS_FT_FONT

/* #define NO_POSTSCRIPT_ALIAS 1 */
#ifndef NO_POSTSCRIPT_ALIAS
/* Code to find font path, with special mapping for Postscript font names.
 * Adapted from code in libgd by: Dag Lem <dag@nimrod.no>
 */

typedef struct _PostscriptAlias {
  char* name;
  char* family;
  cairo_font_slant_t slant; /* style ~= slant + weight    cairo only supports limited slant & weight props*/
  cairo_font_weight_t weight;
} PostscriptAlias;

/* FIXME - not sure of mappings for: "Book" "Demi" "Light" "Narrow" "Roman" */

/* This table maps standard Postscript font names to URW Type 1 fonts.
   The mapping is converted from Ghostscript (Fontmap.GS)
   for use with fontconfig. */
static PostscriptAlias postscript_alias[] = {
  { "AvantGarde-Book", "URW Gothic L", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_NORMAL },
  { "AvantGarde-BookOblique", "URW Gothic L", CAIRO_FONT_SLANT_OBLIQUE, CAIRO_FONT_WEIGHT_NORMAL },
  { "AvantGarde-Demi", "URW Gothic L", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD },
  { "AvantGarde-DemiOblique", "URW Gothic L", CAIRO_FONT_SLANT_OBLIQUE, CAIRO_FONT_WEIGHT_BOLD },

  { "Bookman-Light", "URW Bookman L", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_NORMAL },
  { "Bookman-LightItalic", "URW Bookman L", CAIRO_FONT_SLANT_ITALIC, CAIRO_FONT_WEIGHT_NORMAL },
  { "Bookman-Demi", "URW Bookman L", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD },
  { "Bookman-DemiItalic", "URW Bookman L", CAIRO_FONT_SLANT_ITALIC, CAIRO_FONT_WEIGHT_BOLD },

  { "Courier", "Nimbus Mono L", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_NORMAL },
  { "Courier-Oblique", "Nimbus Mono L", CAIRO_FONT_SLANT_OBLIQUE, CAIRO_FONT_WEIGHT_NORMAL },
  { "Courier-Bold", "Nimbus Mono L", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD },
  { "Courier-BoldOblique", "Nimbus Mono L", CAIRO_FONT_SLANT_OBLIQUE, CAIRO_FONT_WEIGHT_BOLD },

  { "Helvetica", "Nimbus Sans L", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_NORMAL },
  { "Helvetica-Oblique", "Nimbus Sans L", CAIRO_FONT_SLANT_OBLIQUE, CAIRO_FONT_WEIGHT_NORMAL },
  { "Helvetica-Bold", "Nimbus Sans L", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD },
  { "Helvetica-BoldOblique", "Nimbus Sans L", CAIRO_FONT_SLANT_OBLIQUE, CAIRO_FONT_WEIGHT_BOLD },

  { "Helvetica-Narrow", "Nimbus Sans L", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_NORMAL },
  { "Helvetica-Narrow-Oblique", "Nimbus Sans L", CAIRO_FONT_SLANT_OBLIQUE, CAIRO_FONT_WEIGHT_NORMAL },
  { "Helvetica-Narrow-Bold", "Nimbus Sans L", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD },
  { "Helvetica-Narrow-BoldOblique", "Nimbus Sans L", CAIRO_FONT_SLANT_OBLIQUE, CAIRO_FONT_WEIGHT_BOLD },

  { "NewCenturySchlbk-Roman", "Century Schoolbook L", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_NORMAL },
  { "NewCenturySchlbk-Italic", "Century Schoolbook L", CAIRO_FONT_SLANT_ITALIC, CAIRO_FONT_WEIGHT_NORMAL },
  { "NewCenturySchlbk-Bold", "Century Schoolbook L", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD },
  { "NewCenturySchlbk-BoldItalic", "Century Schoolbook L", CAIRO_FONT_SLANT_ITALIC, CAIRO_FONT_WEIGHT_BOLD },

  { "Palatino-Roman", "URW Palladio L", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_NORMAL },
  { "Palatino-Italic", "URW Palladio L", CAIRO_FONT_SLANT_ITALIC, CAIRO_FONT_WEIGHT_NORMAL },
  { "Palatino-Bold", "URW Palladio L", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD },
  { "Palatino-BoldItalic", "URW Palladio L", CAIRO_FONT_SLANT_ITALIC, CAIRO_FONT_WEIGHT_BOLD },

  { "Symbol", "Standard Symbols L", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_NORMAL },

  { "Times-Roman", "Nimbus Roman No9 L", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_NORMAL },
  { "Times-Italic", "Nimbus Roman No9 L", CAIRO_FONT_SLANT_ITALIC, CAIRO_FONT_WEIGHT_NORMAL },
  { "Times-Bold", "Nimbus Roman No9 L", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD },
  { "Times-BoldItalic", "Nimbus Roman No9 L", CAIRO_FONT_SLANT_ITALIC, CAIRO_FONT_WEIGHT_BOLD },

  { "ZapfChancery-MediumItalic", "URW Chancery L", CAIRO_FONT_SLANT_ITALIC, CAIRO_FONT_WEIGHT_NORMAL },

  { "ZapfDingbats", "Dingbats", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_NORMAL },
};
#endif /* NO_POSTSCRIPT_ALIAS */

void gv_cairo_select_font_face(cairo_t *cr, char *fontname)
{
#ifndef NO_POSTSCRIPT_ALIAS
    int i, ps_font_found = 0;
    static int j;   /* try to speed things up by starting with last found */

    for (i = 0; i < sizeof(postscript_alias)/sizeof(*postscript_alias); i++) {
	if (strcasecmp(fontname, postscript_alias[j].name) == 0) {
	    cairo_select_font_face(cr,
			postscript_alias[j].family,
			postscript_alias[j].slant,
			postscript_alias[j].weight);
	    ps_font_found++;
	    break;
        }
	j++;
	if (j >= sizeof(postscript_alias)/sizeof(*postscript_alias))
	    j = 0;
    }
    if (!ps_font_found)
#endif /* NO_POSTSCRIPT_ALIAS */
	cairo_select_font_face(cr,
			fontname,
			CAIRO_FONT_SLANT_NORMAL,
			CAIRO_FONT_WEIGHT_NORMAL);
}

#endif
