/*
 * Theme search paths header
 *
 * Maintain search paths of theme directory.
 * Paths are typically such as /usr/share/groach/theme etc.
 * This module is used to find the appropriate theme path.
 * For example, it returns "/usr/share/groach/theme/default"
 * by theme name "default".
 * Note, "/usr/share/groach/theme/default" is still a directory name.
 * This module also provides a feature to enumerate theme names.
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifndef __GRO_THEME_SEARCH_H__
#define __GRO_THEME_SEARCH_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/* Data structure definitions */
typedef struct _ThemeSearchPrivate ThemeSearchPrivate;

struct _ThemeSearch {
	ThemeSearchPrivate *privat;
};


/* Global function declarations */
extern ThemeSearch* theme_search_new(char *paths);
extern void theme_search_delete(ThemeSearch *theme_search);
extern void theme_search_prepend_paths(ThemeSearch *theme_search, char *paths);
extern char* theme_search_find_path(ThemeSearch *theme_search, const char *theme_name);
extern GList* theme_search_enum_themes(ThemeSearch *theme_search);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __GRO_THEME_SEARCH_H__ */
