/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 */

#import <AwayMessageWindow.h>
#import <String.h>
#import <ClientInstance.h>

#import <Grouch/GrouchStringTool.h>

#import <Renaissance/Renaissance.h>
#import <AppKit/AppKit.h>

@implementation AwayMessageWindow

+ windowWithMessage:(NSString*)msg forInstance:(ClientInstance*)c
{
	return [[self alloc] initWithMessage:msg forInstance:c];
}

- initWithMessage:(NSString*)msg forInstance:(ClientInstance*)c
{
	cli = c;
	[NSBundle loadGSMarkupNamed:@"AwayMessageWindow" owner:self];
	[window orderFront:nil];
	[window makeKeyWindow];
	[label setStringValue:[[label stringValue]
	 createUserString:1,[c nick]]];
	[[message textStorage] setAttributedString:[msg parseHtml]];
	[window makeKeyAndOrderFront:self];
	[cli addDependentWindow:window];
	return self;
}

- (void)dealloc
{
	[self closeWindow];
	[super dealloc];
}

- (void)closeWindow
{
	if( window )
		[window performClose:self];
}

- (BOOL)windowShouldClose:sender
{
	[cli removeDependentWindow:window];
	[window autorelease];
	window = nil;
	[label release];
	[message release];
	[cli returnFromAway];
	[self release];
	return YES;
}

@end
