/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 * --
 * Glue that binds all the FLAP services together.
 */

#import <Oscar/OscarFlap.h>
#import <Grouch/GrouchClient.h>

@class NSMutableDictionary;
@class OscarAuth, OscarBos, OscarChatNavQueue, OscarChatNav, OscarChat;
@class OscarAuthCookie, OscarSsiList;
@class OscarCapHandler;

@interface OscarClient : NSObject <GrouchSession>
{
	OscarBos *bos;
	OscarChatNavQueue *queue;
	OscarChatNav *chatnav;
	NSMutableDictionary *chatRooms;
	OscarSsiList *buddyList;
	id <GrouchClient> ui;
	NSString *myNick;
	id tag;
	BOOL icq;
}

+ clientForServer:(NSString*)str atPort:(int)port
  withCredentials:(id<OscarCredentials>)creds
  andUI:(id <GrouchClient>)ui andTag:tag;
- initForServer:(NSString*)str atPort:(int)port
  withCredentials:(id<OscarCredentials>)creds
  andUI:(id <GrouchClient>)ui andTag:tag;
- init;
- (void)dealloc;

- (id <GrouchClient>)getUI;

- (void)startBos:(NSString*)host withCookie:(id<OscarCredentials>)cookie;
- (void)welcome;
- (void)gotChatNav:(NSString*)host withCookie:(id<OscarCredentials>)cookie;
- (void)gotChannel:(NSString*)chan atHost:(NSString*)host
	withCookie:(id<OscarCredentials>)cookie;
- (void)askForChannel:(NSString*)chan withCookie:(NSString*)cookie
	andExchange:(int)exchange andInstance:(int)instance;
- (void)chatNavDied;
- (void)gotChannel:(OscarChat*)chan;
- (void)lostChannel:(OscarChat*)chan;
- (void)lostBos;

- (OscarCapHandler*)capHandler;
- (OscarSsiList*)buddyList;

// From GrouchSession
- tag;
- (void)tag:tag;
- (void)sendMessage:(NSString*)msg to:(NSString*)user
  withFlags:(GrouchMessageFlags)f;
- (void)sendMessage:(NSString*)msg toChannel:(NSString*)chan
	withFlags:(GrouchMessageFlags)fl;
- (void)profile:(NSString*)str;
- (void)away:(NSString*)str;
- (void)idle:(time_t)i;
- (void)getInfo:(id<GrouchProfile>)prof forUser:(NSString*)str;
- (void)getAwayMessage:(id<GrouchProfile>)prof forUser:(NSString*)str;
- (void)joinChannel:(NSString*)chan;
- (void)partChannel:(NSString*)chan;
- (NSArray*)getContactList:(BOOL)showOfflineUsers;
- (void)removeFromList:item;
- (void)addUser:(NSString*)user toGroup:(NSString*)group;
- (void)setAlias:(NSString*)alias forUser:(id<GrouchUser>)user;

@end

