/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 * --
 * The protocol that defines a SNAC handler, and two wrappers around
 * NSDictionary that implement it.
 */

#import <Foundation/NSObject.h>

@class NSEnumerator;
@class OscarFlap, OscarIncomingSnac;

@protocol OscarSnacHandler

// Handle a snac.
// args:
//	flap:		the socket you are handling.
//	family:		SNAC family.
//	type:		SNAC type.
//	flags:		SNAC flags.  almost always zero.
//			there's one time when they're not but I forget
//			when that is.
//	tag:		see note at OscarCache.h.
//	buffer:		SNAC payload.
- (void)handleSnacForClient:(OscarFlap*)flap
		   ofFamily:(int)family andType:(int)type
		   withFlags:(int)flags andTag:tag
		   buffer:(OscarIncomingSnac*)buf;
@end

@class NSMutableDictionary;

@interface OscarSnacFamilyHandler : NSObject <OscarSnacHandler>
{
	NSMutableDictionary *handlers;
	int family, version, dll;
}

+ handlerForFamily:(int)fam andVersion:(int)vers andDLL:(int)dll;
- initForFamily:(int)fam andVersion:(int)vers andDLL:(int)dll;

- init;
- (void)dealloc;

- (void)addHandler:(id<OscarSnacHandler>)handler forType:(int)type;

- (int)family;
- (int)version;
- (int)dll;

- (void)handleSnacForClient:(OscarFlap*)flap
		   ofFamily:(int)family andType:(int)type
		   withFlags:(int)flags andTag:tag
		   buffer:(OscarIncomingSnac*)buf;

- copy;

@end

@interface OscarSnacHandler : NSObject <OscarSnacHandler>
{
	NSMutableDictionary *families;
}

- init;
- (void)dealloc;

- (void)addFamily:(OscarSnacFamilyHandler*)fam;
- (void)addHandler:(id<OscarSnacHandler>)handler forFamily:(int)fam
						 andType:(int)type;

- (OscarSnacFamilyHandler*)getFamily:(int)fam;

- (void)handleSnacForClient:(OscarFlap*)flap
		   ofFamily:(int)family andType:(int)type
		   withFlags:(int)flags andTag:tag
		   buffer:(OscarIncomingSnac*)buf;

- (NSEnumerator*)familyEnumerator;
@end

