/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 * --
 * When you get an event in a chat room, it shows up here.
 */

#import <Oscar/OscarHandlers.h>
#import <Oscar/OscarClient.h>
#import <Oscar/OscarChat.h>
#import <Oscar/OscarTlvList.h>
#import <Oscar/OscarIncomingSnac.h>
#import <Oscar/OscarEncoding.h>
#import <Grouch/GrouchClient.h>

// join/part
@interface OscarSnac000e0003_0004 : NSObject <OscarSnacHandler>
- (void)handleSnacForClient:(OscarFlap*)flap
	ofFamily:(int)family andType:(int)type
	withFlags:(int)flags andTag:tag
	buffer:(OscarIncomingSnac*)buf;
@end

@implementation OscarSnac000e0003_0004
- (void)handleSnacForClient:(OscarFlap*)flap
	ofFamily:(int)family andType:(int)type
	withFlags:(int)flags andTag:tag
	buffer:(OscarIncomingSnac*)buf
{
	OscarChat *chat = (OscarChat*)flap;
	id<GrouchChannel> chan = [[[chat client] getUI] getChannel:[chat name]];
	while( [buf bytesRemaining] )
	{
		NSString *user = [buf readPascalString];
		int warn = [buf readInt16];
		id<GrouchUser> u = [[[chat client] getUI] getUser:user];
		OscarTlvListIn *tlv = [buf readTlvList];
		oscar_process_buddy( warn, tlv, u ); 

		if( type == 0x03 )
			[chan join:user];
		else if( type == 0x04 )
			[chan part:user];
	}
	[chan reloadData];
}
@end

// message
@interface OscarSnac000e0006 : NSObject <OscarSnacHandler>
- (void)handleSnacForClient:(OscarFlap*)flap
	ofFamily:(int)family andType:(int)type
	withFlags:(int)flags andTag:tag
	buffer:(OscarIncomingSnac*)buf;
@end

@implementation OscarSnac000e0006
- (void)handleSnacForClient:(OscarFlap*)flap
	ofFamily:(int)family andType:(int)type
	withFlags:(int)flags andTag:tag
	buffer:(OscarIncomingSnac*)buf
{
	OscarClient *cli = [flap client];
	OscarTlvListIn *tlv;
	NSString *who, *msg;

	[buf readInt32];
	[buf readInt32];
	if( [buf readInt16] != 3 )
		return;

	tlv = [buf readTLVs];
	buf = [tlv getTLV:0x03];	// User
	if( !buf )
		return;
	{
		int warn;
		OscarTlvListIn *tlv2;
		id<GrouchUser> u;
		who = [buf readPascalString];
		warn = [buf readInt16];
		tlv2 = [buf readTlvList];
		u = [[cli getUI] getUser:who];
		oscar_process_buddy( warn, tlv2, u ); 
	}
	buf = [tlv getTLV:0x05];
	if( !buf )
		return;
	tlv = [buf readTLVs];
	buf = [tlv getTLV:0x02];
	if( !buf )
		return;
	{
		NSString *encoding = [buf readRawString];
		buf = [tlv getTLV:0x01];
		if( !buf )
			return;
		msg = [buf readRawStringWithEncoding:
			[OscarEncoding get:encoding]]; 
	}

	{
		OscarChat *chat = (OscarChat*)flap;
		id<GrouchChannel> c = [[cli getUI] getChannel:[chat name]];
		[c message:msg from:who withFlags:0];
	}
}
@end

@implementation OscarChatHandler
+ get
{
	static id r = nil;
	if( r )
		return r;
	else
		return r = [self new];
}
- init
{
	id add_join;
	[super init];
	[super initForFamily:0x0e andVersion:0x01 andDLL:0x0629];
	add_join = [OscarSnac000e0003_0004 new];
	[super addHandler:add_join forType:0x03];
	[super addHandler:add_join forType:0x04];
	[super addHandler:[OscarSnac000e0006 new] forType:0x06];
	return self;
}
@end
