/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 * --
 * All of the Oscar services have the same basic login sequence.
 * 	For auth, you need your password.
 * 	For others, you need a cookie.
 * Lo!  Through the magic of object orientation, they are one and the same!
 *
 * TODO: make passwords use md5.  that's right folks, your passwords
 * can be sniffed.  I'm sorry.
 */

#import <Oscar/OscarCredentials.h>
#import <Oscar/OscarTlvList.h>
#import <Oscar/OscarIncomingSnac.h>

#import <Grouch/GrouchException.h>

#include <stdlib.h>
#include <string.h>

@implementation OscarPassword

+ passwordWithLogin:(NSString*)user andPassword:(NSString*)pass
{
	OscarPassword *r = [OscarPassword new];
	if( ![r initWithLogin:user andPassword:pass] )
	{
		[r release];
		return nil;
	}
	else
		return [r autorelease];
}

- initWithLogin:(NSString*)user andPassword:(NSString*)pass
{
	[login=user retain];
	[password=pass retain];
	return self;
}

- (void)dealloc
{
	[login release];
	[password release];
	[super dealloc];
}

- (void)writeCredentials:(OscarBuffer*)buf
{
	NSString *aolSucks = @"AOL Instant Messenger, version 5.1.3036/WIN32";
	[buf addTLV:0x01 withString:login];
	[self addPasswordHash:buf];
	// Garbage follows.  This is meaningful to someone.
	[buf addTLV:0x03 withString:aolSucks];
	[buf addTLV:0x16 withInt16:0x0109];	// Client ID
	[buf addTLV:0x17 withInt16:0x0005];	// Version major
	[buf addTLV:0x18 withInt16:0x0001];	// Version minor
	[buf addTLV:0x19 withInt16:0x0000];	// Point release
	[buf addTLV:0x1a withInt16:0x0bdc];	// Build
	[buf addTLV:0x14 withInt32:0x0000];	// Distrib	why 32 bits??
	[buf addTLV:0x0f withString:@"en"];
	[buf addTLV:0x0e withString:@"us"];
}

static unsigned char aol_is_dumb[] =
{
	0xf3, 0x26, 0x81, 0xc4, 0x39, 0x86, 0xdb, 0x92,
	0x71, 0xa3, 0xb9, 0xe6, 0x53, 0x7a, 0x95, 0x7c
};

- (void)addPasswordHash:(OscarBuffer*)tlv
{
	const char *src = [password cString];
	char *buf, *dest;
	const unsigned char *xor = aol_is_dumb;
	size_t len = 0;

	dest = buf = malloc(sizeof(aol_is_dumb)+1);
	if( !buf )
		[GrouchException raiseMemoryException];

	while( *src && (dest-buf) < sizeof(aol_is_dumb) )
	{
		*dest++ = (((unsigned char)*src++) ^ *xor++);
		++len;
	}

	[tlv addTLV:0x02 withBuffer:buf andLength:len];
	free(buf);
}

- (NSString*)login
{
	return login;
}

@end

@implementation OscarAuthCookie

+ cookieFromTLV:(OscarTlvListIn*)tlvs
{
	OscarAuthCookie *r = [OscarAuthCookie new];
	if( ![r initFromTLV:tlvs] )
	{
		[r release];
		return nil;
	}
	else
		return [r autorelease];
}

- initFromTLV:(OscarTlvListIn*)tlvs
{
	OscarIncomingSnac *snac = [tlvs getTLV:0x06];
	if( snac )
	{
		cookie = malloc(len = [snac bytesRemaining]);
		if( !cookie )
			[GrouchException raiseMemoryException];
		memcpy( cookie, [snac buffer], len );
		return self;
	}
	else
		return nil;
}

- init
{
	cookie = NULL;
	len = 0;
	return self;
}

- (void)dealloc
{
	if( cookie )
		free(cookie);
	[super dealloc];
}

- (void)writeCredentials:(OscarBuffer*)tlv
{
	[tlv addTLV:0x06 withBuffer:cookie andLength:len];	
}

@end
