/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 * --
 * See note at OscarTlvList.h
 */

#import <Oscar/OscarTlvList.h>

#include <stdlib.h>		/* For free() */

@implementation OscarTlvListOut

- init
{
	[super init];
	n = 0;
	return self;
}

- createHeapBuffer:(void**)ptrptr withLength:(size_t*)len
{
	OscarBuffer *buf = [OscarBuffer new];
	void *parent;	size_t plen;
	[super createHeapBuffer:&parent withLength:&plen];
	[[buf addInt16:n] addBuffer:parent withLength:plen];
	[buf createHeapBuffer:ptrptr withLength:len];
	if( parent )
		free( parent );
	[buf release];
	return self;
}

- addTLV:(int)type
{
	[super addTLV:type];
	++n;
	return self;
}
- addTLV:(int)type with:obj
{
	[super addTLV:type with:obj];
	++n;
	return self;
}
- addTLV:(int)type withBuffer:(const void*)buf andLength:(size_t)l
{
	[super addTLV:type withBuffer:buf andLength:l];
	++n;
	return self;
}
- addTLV:(int)type withInt16:(int)i
{
	[super addTLV:type withInt16:i];
	++n;
	return self;
}
- addTLV:(int)type withInt32:(int)i
{
	[super addTLV:type withInt32:i];
	++n;
	return self;
}
- addTLV:(int)type withString:(NSString*)s
{
	[super addTLV:type withString:s];
	++n;
	return self;
}

@end
