#     G-Tablix, graphical user interface for Tablix
#     Copyright (C) 2004,2005 Bostjan Spetic
# 
#     This program is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 2 of the License, or
#     (at your option) any later version.
# 
#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.
# 
#     You should have received a copy of the GNU General Public License
#     along with this program; if not, write to the Free Software
#     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# module for exporting everything to tablix 1 format
# author: Bostjan Spetic, igzebedze@cyberpipe.org
# contributions: Tomaz Solc
# 19.12.2004

use strict;

sub XML_params {	# modules
	my ($output,$form,$how) = @_;
	
	if ($how == 1) {
		$output = $output."<parameters>\n";
		my $days = int($form->get_widget('entry_days')->get_text);
		my $periods = int($form->get_widget('entry_periods')->get_text);	
		if (($days < 8) && $periods) { $output = $output."\t<time days=\"$days\" periods=\"$periods\"/>\n"; }
	} elsif ($how == 2) {
		$output = $output."\t<modules>\n";
	}
	my $tv = $form->get_widget('treeview_modules')->get_model;
	$tv->foreach(sub {
 		my (undef,undef,$child_iter) = @_; 	 	 
		my ($id,$weight,$mand,$active,$opts,$comments) = $tv->get($child_iter,0,1,2,3,4,5);
			if ($mand == 1) { $mand = "yes";	} else {	$mand = "no"; }

		if ($active == 1) {	
			if ($comments) { $output = $output."\t"."<!-- $comments -->\n"; }
			$output = $output."\t\t".'<module name="'.$id.'" weight="'.$weight.'" mandatory="'.$mand.'"';

						my $version = &get_tablix;	# the only change in format... *sigh*
						if ($version eq 'tablix') { $version = 'type'; }
						elsif ($version eq 'tablix2') { $version = 'name'; }

#			$output = $output.write_rests($opts,'module','option');
 			if (defined $opts) {
 				$output = $output.">\n";
 				foreach my $rest (split/\;/,$opts) { 			
 					my @specc = split/:/,$rest;
 					
 					if (defined $specc[1]) { 
 						foreach my $spec (split/,/,$specc[1]) {
 							my $type = $specc[0];
 							$output = $output."\t\t\t<option $version=\"$type\">$spec</option>\n";
 					#  <option type="morning-ends">7</option>
 						}
 					}
 				}
 				$output = $output."\t\t</module>\n";
 			} else { $output = $output."/>\n"; }
		 }
		$form->get_widget('progressbar_main')->pulse;
		Gtk2->main_iteration;		 
		 return 0;
#        <module name="sametime.so" weight="60" mandatory="yes"/>
	});
# se internal
	if ($how == 1) {
		if (my $internal = $form->get_widget('entry_impossible')->get_text) {
			$output = $output."\t<internal name=\"impossible\" weight=\"$internal\"/>\n";
		}
		$output = $output."</parameters>\n";
	} elsif ($how == 2) {
		$output = $output."\t</modules>\n";
	}
	
	return $output;
}

sub XML_subjects {	# subjects + teachers
	my ($output,$form,$how) = @_;
	$output = $output."<subjects>\n";
	my $tw = $form->get_widget('treeview_teachers')->get_model;
	my $tw_s = $form->get_widget('treeview_subjects')->get_model;
# za vsakega ucitlja
# in vse njegove predmete	
# poiscemo morebitne notese in restrictione predmeta
	my %subjects;
	my %teachers;
	$tw->foreach(sub {
		(undef, undef, my $iter) = @_;			
			my $teacher = $tw->get($iter,0);
			my $subject = $tw->get($iter,1);
			my $rests_t = $tw->get($iter,2);
			my $notes_t = $tw->get($iter,3);
			
			#if (!defined $subject) { return 0; }	# go next if empty
			my $s_row = 'new';
			if ((!defined $subject) or ($subject eq "")) {
	# add empty teacher entry only if it has no subjects defined
				if ($tw->iter_has_child($iter)) {
					return 0;
				} else {
					$subject = ""; 
				}
	# mark the subject, so that it wont get added again
			} else { 
				$subjects{$subject} = 1; 
				$s_row = &find_clist_row("subjects",$subject);
			}
			my ($s_rests,$s_comments);
			if ($s_row ne "new") {
				($s_rests,$s_comments) = $tw_s->get($tw_s->get_iter_from_string($s_row),1,2);
				if (!defined $s_rests) { $s_rests = ""; }
			}

# in vse skupaj vpisemo v enem koraku.
 			if ((defined $notes_t) and ($notes_t ne "")) { 
				$output = $output."\t"."<!-- Teacher: $notes_t -->\n"; } 
 			if ((defined $s_comments) and ($s_comments ne "")) { 
				$output = $output."\t"."<!-- Subject: $s_comments -->\n"; } 
	# write tuple
			$output = $output."\t".'<subject title="'.$subject.'"'." teacher=\"$teacher\">\n";
	# write teachers restrictions
			$output = $output.&split_rests($rests_t);
	# write subjects restrictions
			$output = $output.&split_rests($s_rests);
	# end
			$output = $output."\t</subject>\n";	
	# pulse
			$form->get_widget('progressbar_main')->pulse;
			Gtk2->main_iteration;
	# again
			return 0;	
		});
	$tw_s->foreach(sub {
		(undef, undef, my $iter) = @_;
			my $subject = $tw_s->get($iter,0);
			my $rests_t = $tw_s->get($iter,1);
			my $notes_t = $tw_s->get($iter,2);
			my $teacher = "";
# for subjects that weren't used with teachers...		
			if (!$subjects{$subject}) {
	 			if ((defined $notes_t) and ($notes_t ne "")) { 
					$output = $output."\t"."<!-- Subject: $notes_t -->\n"; } 
	# write tuple
					$output = $output."\t".'<subject title="'.$subject.'"'." teacher=\"$teacher\"";
	# write restrictions
					$output = $output.&write_rests($rests_t,'subject');
			}
		$form->get_widget('progressbar_main')->pulse;
		Gtk2->main_iteration;
			return 0;
	});
#	}
#                 <subject title="SVZ-Z" teacher="Prof. SVZ 1">
#                 <restriction type="capability-place">Telovadba</restriction>
#                 </subject>

	$output = $output."</subjects>\n";
	return $output;
}

sub XML_rooms {		# building
	my ($output,$form,$how) = @_;

#TODO: zaporedno stevilcene najdi in dodaj kot classrooms
	$output = $output."<building>\n";
	my $tv = $form->get_widget('treeview_classrooms')->get_model;
	$tv->foreach(sub {
 		my (undef,undef,$child_iter) = @_; 	 	 
# room notes
		my ($id,$rests,$comments) = $tv->get($child_iter,0,1,2);
		if (!defined $id) { return 0; }
		if ((defined $comments) and ($comments ne "")) { 
			$output = $output."\t"."<!-- $comments -->\n"; }
		$output = $output."\t".'<classroom id="'.$id.'"';
		$output = $output.&write_rests($rests,'classroom','capability');
#                 <classroom id="1">
#                         <capability type="capability-place">Nemscina</capability>
#                         <capability type="capability-place">Normal</capability>
#                 </classroom>
		$form->get_widget('progressbar_main')->pulse;
		Gtk2->main_iteration;
		return 0;
	});
	$output = $output."</building>\n";
	return $output;
}
sub XML_tt {		# timetables
	my ($output,$form,$defined_tt_entries,$uid_tt_entries,$how) = @_;
	my $tw_c = $form->get_widget('treeview_classs')->get_model;
	my $tw = $form->get_widget('treeview_tt')->get_model;
	my %classs;
	$tw_c->foreach(sub {
		my (undef,undef,$child_iter) = @_; 	 	 
		my ($class,$c_rests,$c_comments) = $tw_c->get($child_iter,0,1,2);
			if (!defined $class) { return 0; }
			if (!defined $c_rests) { $c_rests = ""; }
		my $row = &find_clist_row("tt",$class);
			#if ($row eq 'new') { return 0; }

# NOTE: might be annoying...		
		my @class = split/ /,$class;		
#		if ($#class > 0) {
	 		my $year = shift(@class);
			my $classname = join(' ',@class);
			
			$classs{$class} = 1;
			
			$output = $output."<timetable>\n";
	 	 	if ((defined $c_comments) and ($c_comments ne "")) { 
				$output = $output."\t"."<!-- $c_comments -->\n"; }
	 		$output = $output."\t<class year=\"$year\" name=\"$classname\"/>\n";	# class name	
	 		
	 		if ($row ne 'new') {
	 			my $iter = $tw->get_iter_from_string($row);
	 	 		#$output = $output.&tt_output($class,$iter,$form,$uid_tt_entries);
	 	 		if (defined $tw->iter_has_child($iter)) {
	 	 			for (my $child = $tw->iter_children($iter); $child; $child = $tw->iter_next($child)) {
	 	 				$output = $output.&tt_output($class,$child,$form,$uid_tt_entries);
	 	 			}
	 	 		}	
			}		
	 	# class restrictions from clist_classes	
			$output = $output.&split_rests($c_rests);
	 		$output = $output."</timetable>\n";
#		}
		$form->get_widget('progressbar_main')->pulse;
		Gtk2->main_iteration;
		
		return 0;
	});
	return $output;
#         <timetable>
#                 <class year="3" name="A"/>
#                 <subject title="SOC" teacher="Prof. SOC 1" perweek="2"/>
#                 <subject title="SVZ" teacher="Prof. SVZ 1" perweek="3"/>
#                 <restriction type="conflicts-with">3 MA-FIZ</restriction>
#                 <restriction type="conflicts-with">3 MA-BIO</restriction>
#         </timetable>
}
sub tt_output {
	my ($class,$iter,$form,$uid_tt_entries,$how) = @_;
	my $tw = $form->get_widget('treeview_tt')->get_model;
	my @values = $tw->get($iter);
	my $output = "";
	
	my $id = $values[0];
	my $title = $values[1];
	my $teacher = $values[2];
	my $perweek = $values[3];
	my $room = $values[4];
	my $period = $values[5];
	my $day = $values[6];
	my $restss = $values[7];
	my $comments = $values[8];

#	if ($id and $teacher and $title and ($room or ($period and $day and $room))) {
 		if ((defined $comments) and ($comments ne "")) { 
			$output = $output."\t"."<!-- $comments -->\n"; }	# tuple notes
		$output = $output."\t\t<subject "."title=\"$title\" "."teacher=\"$teacher\" ";
	# either perweek or (period and day) can and must be specified
		if ($perweek ne "") { $output = $output."perweek=\"$perweek\" ";
	 	} elsif (($room ne "") and ($period ne "") and ($day ne "")) { 
			$output = $output."room=\"$room\" period=\"$period\" day=\"$day\"";
	 	} else { # TODO: error message
			return "";
		}
	# if we're dealing with results file...
		my $uid;
		foreach my $id (sort(keys(%{$uid_tt_entries}))) {
			my $who = ${$uid_tt_entries}{$id};
			if ($who eq "$class||$title||$teacher") {
				$uid = $id; 
				last;
			}
		}
		if (defined $uid) {	$output = $output." uid=\"$uid\""; }				
	# if tuple restrictions are specified		
		$output = $output.&write_rests($restss,'subject');
#	}
	return $output;
}
sub XML_chromo {	# chromo output
	my ($output,$form,$defined_tt_entries,$uid_tt_entries,$how) = @_;

	my $grade = $form->get_widget('label-chromo')->get_text;

	if ($grade) { 
		$output = $output."\n\t<chromo grade=\"$grade\">\n";

	  	while ((my $when, my $who) = each (%{$defined_tt_entries})) {	
	 		my $uid = (split/\|\|/,$who)[3];
	 		if ($uid) {
 				my $room = (split/\|\|/,$when)[0];
  				my $period = (split/\|\|/,$when)[1];
  				my $day = (split/\|\|/,$when)[2];
  			
	  			$output = $output."\t\t<gen period=\"$period\" day=\"$day\" room=\"$room\" uid=\"$uid\"/>\n";
	  		}
	 	}
		
		$output = $output."\t</chromo>\n";
	}	
	return $output;
#	${$uid_tt_entries}{$i} = "$class||$title||$teacher";	uid=>what, multiple whats!
#	${$defined_tt_entries}{"$room||$period||$day"} = "$class||$title||$teacher";	when=>what            

# 	<chromo grade="323">
# 		<gen period="1" day="0" room="Music Room" uid="1"/>
# 		<gen period="0" day="1" room="Music Room" uid="2"/>
# 		<gen period="1" day="3" room="JW" uid="3"/>
# 		<gen period="1" day="1" room="VW" uid="4"/>
}


return 1;
