#     G-Tablix, graphical user interface for Tablix
#     Copyright (C) 2004,2005 Bostjan Spetic
# 
#     This program is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 2 of the License, or
#     (at your option) any later version.
# 
#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.
# 
#     You should have received a copy of the GNU General Public License
#     along with this program; if not, write to the Free Software
#     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# module for importing everything from FET 
# author: Bostjan Spetic, igzebedze@cyberpipe.org
# contributions: Tomaz Solc
# 19.12.2004

use strict;

my %fet_days;
my %fet_periods;

####################################################################################################
# fet file format

sub fet_hours {
	my ($what,$form) = @_; 
	my @fet_hours;
	foreach my $info ($what->getChildNodes) {		
		if ($info->getFirstChild) {
			if ($info->nodeName eq "Number") { 
				my $no = $info->firstChild->data;
				$form->get_widget('entry_periods')->set_text($no);
			} elsif ($info->nodeName eq "Name") { 
				my $no = $info->firstChild->data;
				push (@fet_hours,$no);
			}
		}
	}
	my $count = 0;
	foreach my $hour (sort(@fet_hours)) {
		$fet_periods{$hour} = $count;
		$count++;
	}
}
sub fet_days {
	my ($what,$form) = @_; 
	my @fet_days;
	foreach my $info ($what->getChildNodes) {		
		if ($info->getFirstChild) {
			if ($info->nodeName eq "Number") { 
				my $no = $info->firstChild->data;
				$form->get_widget('entry_days')->set_text($no);
			} elsif ($info->nodeName eq "Name") { 
				my $no = $info->firstChild->data;
				push (@fet_days,$no);
			}
		}
	}
	my $count = 0;
	foreach my $hour (sort(@fet_days)) {
		$fet_days{$hour} = $count;
		$count++;
	}
}
sub fet_students {
	my ($what,$form) = @_; 
	my $tv_c = $form->get_widget('treeview_classs')->get_model;
	foreach my $year ($what->getChildNodes) {
		if ($year->getFirstChild) {
			my $named = "";
			foreach my $some ($year->getChildNodes) {
	 			if ($some->getFirstChild) {
	 				if ($some->nodeName eq "Name") { 			# year name
	 					$named = $some->firstChild->data;	
	 				} elsif ($some->nodeName eq "Group") { 	# class names
	 					my $class = "";
						foreach my $grp ($some->getChildNodes) {	# read groups info
							if ($grp->nodeName eq "Name") {
								my $no = $grp->firstChild->data;
								$class = $named." $no";
	 	 	 	 	 	 		my $row = &find_clist_row("classs",$class);
	 	 	 	 	 	 		if ($row eq "new") { # add group only if new
									$tv_c->set($tv_c->append,0,$class);
	 	 	 	 	 	 		} 
							} elsif ($grp->nodeName eq "Subgroup") { 
	 	 	 					foreach my $sgrp ($grp->getChildNodes) {	# read subgroups
	 	 							if ($sgrp->nodeName eq "Name") {
	 	 								my $no = $sgrp->firstChild->data;									
	 	 								$no = $named." $no";
										my $type = "conflicts-with:$class;";
	 	 	 	 	 	 	 	 		my $row = &find_clist_row("classs",$no);
	 	 	 	 	 	 	 	 		if ($row eq "new") {
	 	 	 	 	 	 	 	 			$tv_c->set($tv_c->append,0,$no,1,$type);
	 	 	 	 	 	 	 	 		} else {
											$row = $tv_c->get_iter_from_string($row);
	 										$tv_c->set($row,1,$type);
										}
	 	 							}
	 	 						}						
	 	 	 				} 
						}						
	 				} 
	 			}
	 		}
		}
	}
	&combo_change("classs");
}
sub fet_teachers {
	my ($what,$form) = @_; 
	my $tv_t = $form->get_widget('treeview_teachers')->get_model;
	foreach my $teacher ($what->getChildNodes) {		
		foreach my $name ($teacher->getChildNodes) {
			if ($name->getFirstChild) {
				if ($name->nodeName eq "Name") { 
					my $no = $name->firstChild->data;
					my $row = &find_clist_row("teachers",$no);
	 	 			if (($row eq "new") and (defined $no)) { # add teacher only if new
	 	 				$row = $tv_t->insert(undef,-1); 
	 	 				$tv_t->set($row,0,$no);
	 	 			} 				
				}
			}
		}
	}
	&combo_change("teachers");
}
sub fet_subjects {
	my ($what,$form) = @_; 
	my $tv_t = $form->get_widget('treeview_subjects')->get_model;
	foreach my $teacher ($what->getChildNodes) {		
		foreach my $name ($teacher->getChildNodes) {
			if ($name->getFirstChild) {
				if ($name->nodeName eq "Name") { 
					my $no = $name->firstChild->data;
	 	 			my $row = &find_clist_row("subjects",$no);
	 	 			if (($row eq "new") and (defined $no)) { # add subject only if new
	 	 				$tv_t->set($tv_t->append,0,$no);
	 	 			} 				
				}
			}
		}
	}
	&combo_change("subjects");
}
sub fet_activities {
	my ($what,$form) = @_; 
	my $tv_tt = $form->get_widget('treeview_tt')->get_model;
	my $tv_t = $form->get_widget('treeview_teachers')->get_model;
	foreach my $act ($what->getChildNodes) {		# each activity
		if ($act->getFirstChild) {
		my $teacher = "";
		my $subject = "";
		my $duration = "";
		my $total_duration = "";
		my $class = "";
		my $rests = "";
		my $id = "";
		my $aid = "";
		foreach my $some ($act->getChildNodes) {		# its preferences
			if ($some->nodeName eq "Teacher") {
				if ($teacher ne "") {
					$rests = $rests."teacher-also:$teacher;";
				} else {
					$teacher = $some->firstChild->data;
				}
			} elsif ($some->nodeName eq "Subject") {
				$subject = $some->firstChild->data;
	 			my $row = &add_to_tree($form,"teachers",$teacher,$subject);
	 	 		$tv_t->set($row,0,$teacher,1,$subject);
			} elsif ($some->nodeName eq "Duration") {
				$duration = $some->firstChild->data;
				if ($duration == 2) {
					$rests = $rests."double-period:$subject;";
				}
			} elsif ($some->nodeName eq "Total_Duration") {
				$total_duration = $some->firstChild->data;
			} elsif ($some->nodeName eq "Id") {
				$id = $some->firstChild->data;
			} elsif ($some->nodeName eq "Activity_Group_Id") {
				$aid = $some->firstChild->data;
			} elsif ($some->nodeName eq "Students") {
				$class = $some->firstChild->data;
				my $tv_c = $form->get_widget('treeview_classs')->get_model;
				$tv_c->foreach(sub {
					my (undef,undef,$child_iter) = @_; 	 	 		
 	 				my ($c) = $tv_c->get($child_iter,0);
					if ((split/ /,$c)[1] eq $class) {
						$class = $c;
						return 1;
					}
					return 0;
				});
			} elsif ($some->nodeName eq "Weekly") {
				
			} 			
		}
		my $row = &add_to_tree($form,'tt',$class,$subject);
		$tv_tt->set($row,0,$class,1,$subject,2,$teacher,3,$total_duration,7,$rests);
	} }
	&combo_change("teachers");
}	
sub fet_equipment {			# these will become capability places
	my ($what,$form) = @_; 
} 
sub fet_rooms {
	my ($what,$form) = @_; 
	my $tv_t = $form->get_widget('treeview_classrooms')->get_model;
	foreach my $teacher ($what->getChildNodes) {		
		if ($teacher->getFirstChild) {
		my $named = ""; my $type = "";
		foreach my $name ($teacher->getChildNodes) {
			if ($name->getFirstChild) {
				if ($name->nodeName eq "Name") { 
					$named = $name->firstChild->data;
				} elsif ($name->nodeName eq "Type") { 
					my $no = $name->firstChild->data;
					$type = $type."capability-place:$no;";
				} elsif ($name->nodeName eq "Equipment") { 
					my $no = $name->firstChild->data;
	 	 			$type = $type."capability-place:$no;";
				}
			}
		}
		my $row = &find_clist_row("classrooms",$named);
		if ($row eq "new") { # add room only if new
			$tv_t->set($tv_t->append,0,$named,1,$type);
		} else {
			$row = $tv_t->get_iter_from_string($row);
			$tv_t->set($row,1,$type);
		}
	} }
	&combo_change("classrooms");
}
sub fet_time_constraints {
	my ($what,$form) = @_; 
 	my $tv_m = $form->get_widget('treeview_modules')->get_model;
	foreach my $type ($what->getChildNodes) {	
		if ($type->getFirstChild) {
# no appropriate tablix module
			if ($type->nodeName eq "ConstraintTeacherNotAvailable") {
				my $weight; my $mand; my $teacher; my $day; my $h1; my $h2;
				foreach my $param ($type->getChildNodes) {
					if ($param->getFirstChild) {
						if ($param->nodeName eq "Weight") { $weight = $param->firstChild->data;
						} elsif ($param->nodeName eq "Compulsory") { $mand = $param->firstChild->data;
						} elsif ($param->nodeName eq "Teacher_Name") { $teacher = $param->firstChild->data;
						} elsif ($param->nodeName eq "Day") { $day = $param->firstChild->data;
						} elsif ($param->nodeName eq "Start_Hour") { $h1 = $param->firstChild->data;
						} elsif ($param->nodeName eq "End_Hour") { $h2 = $param->firstChild->data;
						}
					}
				}
				my $row = &find_clist_row ('teachers',$teacher);
	# setup restriction for teacher
				if ($row ne 'new') {
					my $tv_c = $form->get_widget('treeview_classs')->get_model;
					$row = $tv_c->get_iter_from_string($row);

				}
	# start the module

# preferred period, preferred day			
			} elsif ($type->nodeName eq "ConstraintActivityPreferredTimes") {
				my $weight; my $mand; my $id; my $day; my $hour; my $ptimes;
				foreach my $param ($type->getChildNodes) {
					if ($param->getFirstChild) {
						if ($param->nodeName eq "Weight") { $weight = $param->firstChild->data;
						} elsif ($param->nodeName eq "Compulsory") { $mand = $param->firstChild->data;
						} elsif ($param->nodeName eq "Activity_Id") { $id = $param->firstChild->data;
						} elsif ($param->nodeName eq "Number_of_Preferred_Times") { $ptimes = $param->firstChild->data;
						} elsif ($param->nodeName eq "Preferred_Time") { 
							foreach my $times ($param->getChildNodes) {
								if ($times->getFirstChild) {
									if ($times->nodeName eq 'Preferred_Day') { $day = $times->firstChild->data;
									} elsif ($times->nodeName eq 'Preferred_Hour') { $hour = $times->firstChild->data;
									} 
								}
							}
							
						} 
					}
				}
	# start the module
				if ($mand eq 'yes') { $mand = 1; } else { $mand = 0; }
	 	 	 	my $row = &find_clist_row ('modules','preferred.so');
				if ($row ne 'new') {
					$row = $tv_m->get_iter_from_string($row);
					$tv_m->set($row,1,$weight,2,$mand,3,1);
	 	 	 	}				
# no appropriate tablix module 					
			} elsif ($type->nodeName eq "ConstraintActivityEndsDay") {
				my $weight; my $mand; my $id;
				foreach my $param ($type->getChildNodes) {
					if ($param->getFirstChild) {
						if ($param->nodeName eq "Weight") { $weight = $param->firstChild->data;
						} elsif ($param->nodeName eq "Compulsory") { $mand = $param->firstChild->data;
						} elsif ($param->nodeName eq "Activity_Id") { $id = $param->firstChild->data;
						}
					}
				}			
# class_freeperiod
			} elsif ($type->nodeName eq "ConstraintStudentsSetNotAvailable") {
				my $weight; my $mand; my $class; my $day; my $h1; my $h2;
				foreach my $param ($type->getChildNodes) {
					if ($param->getFirstChild) {
						if ($param->nodeName eq "Weight") { $weight = $param->firstChild->data;
						} elsif ($param->nodeName eq "Compulsory") { $mand = $param->firstChild->data;
						} elsif ($param->nodeName eq "Students") { $class = $param->firstChild->data;
						} elsif ($param->nodeName eq "Day") { $day = $param->firstChild->data;
						} elsif ($param->nodeName eq "Start_Hour") { $h1 = $param->firstChild->data;
						} elsif ($param->nodeName eq "End_Hour") { $h2 = $param->firstChild->data;
						}
					}
				}
				my $row = &find_clist_row ('classs',$class);
	# setup restriction for class
				if ($row ne 'new') {
					my $tv_c = $form->get_widget('treeview_classs')->get_model;
					$row = $tv_c->get_iter_from_string($row);
					for (my $c = $fet_periods{$h1}; $c <= $fet_periods{$h2}; $c++) {
						my $rests = $tv_c->get($row,1);
						$tv_c->set($row,1,"free-period:$c;$rests");
					}
	# start the module
	 				if ($mand eq 'yes') { $mand = 1; } else { $mand = 0; }
	 	 	 	 	$row = &find_clist_row ('modules','class_freeperiod.so');
	 				if ($row ne 'new') {
	 					$row = $tv_m->get_iter_from_string($row);
	 					$tv_m->set($row,1,$weight,2,$mand,3,1);
	 	 	 	 	}
				}
# no appropriate tablix module 				
			} elsif ($type->nodeName eq "ConstraintBasicCompulsoryTime") {
				my $weight; my $mand;
				foreach my $param ($type->getChildNodes) {
					if ($param->getFirstChild) {
						if ($param->nodeName eq "Weight") { $weight = $param->firstChild->data;
						} elsif ($param->nodeName eq "Compulsory") { $mand = $param->firstChild->data;
						}
					}
				}				
# student-holes
			} elsif ($type->nodeName eq "ConstraintStudentsNoGaps") {
				my $weight; my $mand;
				foreach my $param ($type->getChildNodes) {
					if ($param->getFirstChild) {
						if ($param->nodeName eq "Weight") { $weight = $param->firstChild->data;
						} elsif ($param->nodeName eq "Compulsory") { $mand = $param->firstChild->data;
						}
					}
				}	
	# start the module
				if ($mand eq 'yes') { $mand = 1; } else { $mand = 0; }
	 	 	 	my $row = &find_clist_row ('modules','student_holes.so');
				if ($row ne 'new') {
					$row = $tv_m->get_iter_from_string($row);
					$tv_m->set($row,1,$weight,2,$mand,3,1);
	 	 	 	}
			} 
		}
	}
}
sub fet_space_constraints {
	my ($what,$form) = @_; 
	foreach my $type ($what->getChildNodes) {	
		if ($type->getFirstChild) {
# no appropriate tablix module 		
			if ($type->nodeName eq "ConstraintBasicCompulsorySpace") {
			
# no appropriate tablix module 		
			} elsif ($type->nodeName eq "ConstraintRoomTypeNotAllowedSubjects") {
			
			} 
		}
	}
}

return 1;
