/*
 * Copyright (C) 1997, 98, 99 Free Software Foundation
 * Copyright (C) 1994,95,96,97 Eric M. Ludlam
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you can either send email to this
 * program's author (see below) or write to:
 *
 *              The Free Software Foundation, Inc.
 *              675 Mass Ave.
 *              Cambridge, MA 02139, USA. 
 *
 * Please send bug reports, etc. to zappo@gnu.org.
 *
 * $Log: gtalkc.h,v $
 * Revision 1.40  1999/11/29 17:06:17  zappo
 * Converted old crypt code into generic filter code.
 *
 * Revision 1.39  1999/08/26 11:59:35  zappo
 * Added eightbit flag to Ctxt.
 *
 * Revision 1.38  1998/10/11 11:36:08  zappo
 * Changed GTALK_VERSION to VERSION for automake.
 *
 * Revision 1.37  1998/09/22 13:28:36  zappo
 * Added gt_route prototoypes
 *
 * Revision 1.36  1998/05/01 16:40:25  zappo
 * Separated the copyrightstring define from the notice string.
 *
 * Revision 1.35  1998/01/09 22:33:20  zappo
 * Pass in the non-flag parameter to the test command.
 *
 * Revision 1.34  1998/01/04 15:16:25  zappo
 * Update copyright year.
 *
 * Revision 1.33  1997/12/14 19:18:09  zappo
 * Renamed package to gtalk, renamed symbols and files apropriately
 * Fixed copyright and email address.
 *
 * Revision 1.32  1997/12/14 16:27:09  zappo
 * The great name change.
 *
 * Revision 1.31  1997/11/05 03:46:53  zappo
 * changed crypt prototypes
 *
 * Revision 1.30  1997/11/01 13:31:01  zappo
 * Changed the type of last_answer to be signed.
 *
 * Revision 1.29  1997/10/18 03:01:16  zappo
 * Fixed two parameter less crypt return types
 *
 * Revision 1.28  1997/10/17 02:23:51  zappo
 * Added default encryption method, and added last_answer/msg to user object.
 * The last_answer is used for scanning answers out of streams of data.
 *
 * Revision 1.27  1997/10/14 02:14:23  zappo
 * Added the crypt messages for use w/ socket interface
 *
 * Revision 1.26  1997/10/07 00:13:10  zappo
 * Added a prototype
 *
 * Revision 1.25  1997/07/27 17:15:19  zappo
 * Changed to use the generic list for all windows, and adjusted some comments.
 *
 * Revision 1.24  1997/03/12 02:28:54  zappo
 * Added new suspend method.
 *
 * Revision 1.23  1997/03/12 00:28:09  zappo
 * Added new window part to user struct & prototype maintenance.
 *
 * Revision 1.22  1997/02/23 03:28:33  zappo
 * Added new cleanup flag to TalkContext, and new prototypes for gt_display
 * which allow X to turn of prompting and feedback.
 *
 * Revision 1.21  1997/02/01 14:22:42  zappo
 * Parameter maintenace.
 *
 * Revision 1.20  1997/01/28  03:22:36  zappo
 * Prototype maintenance
 *
 * Revision 1.19  1997/01/26  15:32:17  zappo
 * Now uses GTALK_VERSION which is a string for the GTALK_ macro
 *
 * Revision 1.18  1996/07/28  18:06:08  zappo
 * Added encryption fields to user struct, added new message to initiate
 * encryption, and apropriate new prototypes
 *
 * Revision 1.17  1996/02/26  00:12:57  zappo
 * Updated prototypes (removed message parsing prototypes)
 *
 * Revision 1.16  1996/02/01  02:40:54  zappo
 * Added more types to user, and removed some prototypes to other
 * places.  Added IO methods struct.
 *
 * Revision 1.15  1995/12/10  00:28:38  zappo
 * Added new TCPMethod for how to handle new connections (always accept,
 * query, never).  runstate now has an enumeration. querytype stored in
 * context, prefered name in context.  Removed obsolete TTY codes, added
 * new codes.
 *
 * Revision 1.14  1995/11/21  04:02:23  zappo
 * Added many new prototypes, added codes.
 *
 * Revision 1.13  1995/09/22  14:01:58  zappo
 * Changed version number, updated _rc routine parameters, and added
 * _scan file prototyes
 *
 * Revision 1.12  1995/09/20  23:19:29  zappo
 * Updated structures, and added new prototypes which all relate to the X
 * interface
 *
 * Revision 1.11  1995/09/14  11:35:39  zappo
 * Added a bunch of prototypes, new user state, and a new talk-client
 * type.  Also added a WindowList structure for when etalk is in display
 * mode.
 *
 * Revision 1.10  1995/07/21  02:23:04  zappo
 * Changed version number
 *
 * Revision 1.9  1995/07/16  16:12:33  zappo
 * Added a new state for a user which us UNREACHABLE meaning in the
 * process of being deleted after a failed attempt to connect.
 *
 * Revision 1.8  1995/03/25  04:09:28  zappo
 * Fixed copyright, and prototypes in non-ansi section.
 *
 * Revision 1.7  1995/03/12  20:28:03  zappo
 * Added some new headers and myappname to context, and new message types
 *
 * Revision 1.6  1995/02/11  17:50:13  zappo
 * Added ringer report, and a new shutdown prototype
 *
 * Revision 1.5  1995/02/01  03:38:38  zappo
 * the ringer id # was changed from 7 (bell) to 9 (1 abouve BS) and added
 * a fn.
 *
 * Revision 1.4  1995/01/28  16:17:48  zappo
 * Added ringer information
 *
 * Revision 1.3  1994/11/19  17:04:48  zappo
 * Added some function prototypes.
 *
 * Revision 1.2  1994/11/16  23:15:03  zappo
 * Added sockflag field, and moved some defines into this file.
 *
 * Revision 1.1  1994/08/29  23:38:06  zappo
 * Initial revision
 *
 */

#ifndef GTALK_

#define GTALK_C " (c) 1994-99 Free Software Foundation."
#define GTALK_ "GTALK version " VERSION GTALK_C


#define NUMEDITKEYS 3

/*
 * This enumeration defines what mode we are running in.  Durring
 * initialization  we define our mode, and reference via this enum to
 * define the best way to display information.
 */
enum RunState { Socket, Curses, X };
/*
 * This defines what happens when new TCP connection information is
 * offered.  RefuseConnect is not a suggested value, but is useful
 * if there is a really pesky user somewhere.
 */
enum NewTCPMethod { RefuseConnect, AlwaysConnect, QueryConnect };
/*
 * This defines how garbage collection is maintained.  Manual is
 * useful if debugging, but AutoClean should be sufficient for users
 * who just don't care about studying dead objects.  They need the
 * value 0 and 1 so they can also be used as True/False when passed
 * to etalk library functions.
 */
enum CleanupMethod { ManualClean = 0, AutoClean = 1 };

/*
 * lets define the context used thoughout
 * this talk program.
 */
struct TalkContext {
  struct HostObject  *me;		/* The current host.            */
  struct InputDevice *tty;		/* TTY to emacs or curses/X     */
  enum RunState       runstate;	        /* Current running state        */
  int                 ringerflag;       /* TRUE means ringer is active  */
  enum NewTCPMethod   querynewtcp;      /* How to know when to connect  */
  enum CleanupMethod  cleanup;		/* Auto-clean our lists flag    */
  struct InputDevice *emacs_connect;	/* emacs network port           */
  struct InputDevice *remote_connect;	/* remote connect port          */
  struct InputDevice *udp_port;		/* my udp to daemon port        */
  struct InputDevice *udp_ring;	        /* udp port to use for ring svc */
  struct InputDevice *local_daemon;	/* The local daemons address    */
  char                editkeys[3];      /* My editkeys                  */
  pid_t               pid;		/* pid, (autoconf makes pid_t)  */
  char               *myname;		/* my name                      */
  char               *myprefname;	/* my preferred long name       */
  char               *myappname; 	/* for gtalkd, name of this app */
  char               *downloadpath;     /* path to place download files */
  int                 default_filter ;  /* stores the default filter    */
  int                 message_delay;	/* delay between goofy messages */
  int                 eight_bit;        /* Non-0 enables eight bit chars*/
};

/*
 * Describe a USER.  USERS represent different connections to
 * multiple talk programs.
 */
enum TalkClientType { Unknowntalk, DATALINK, SUBPROCESS, VanillaTalk,
		      ETALK, GNUTALK, YTALK };
enum TalkUserState  { USER_NEW = 0, USER_CONNECTED = 1, 
		      USER_UNREACHABLE = 2, USER_CLOSED = 3,
		      USER_CALLING = 4
		    };

struct UserObject {
  struct GenericListNode link;	      /* Linked list part                    */
  char                  *name;	      /* name of user                        */
  char                  *longname;    /* long name which might be transferred*/
  char                  *tty;	      /* tty of remote user                  */
  char                   editkeys[3]; /* thier edit keys                     */
  int                    id;	      /* unique user id.                     */
  enum TalkClientType    type;	      /* their client type                   */
  int                    ver,num;     /* version number of their client      */
  int                    connect;     /* users remote connect port           */
  enum TalkUserState     state;	      /* state of this structure             */
  struct WindowList     *window;      /* window this user is attached to.    */
  int                    outbound_filter; /* stores the outbound filter id   */
  int                    inbound_filter;  /* stores the inbound filter id    */
  char                  *outbound_filter_data; /* outbound filter data       */
  char                  *inbound_filter_data; /* inbound filter data         */
  char                  *scanbuff;    /* buffered data scaned from this user */
  signed char            last_answer; /* last scaned answer in the user obj. */
  char                  *last_msg;    /* message buffer associated w/ above  */
  void                 (*query_fn)(); /* function called for an answer       */
				      /* query_fn(Ctxt, UserObject)          */
  struct InputDevice    *remote;      /* thier TCP io device                 */
  struct InputDevice    *local;	      /* thier device to emacs window        */
  struct InputDevice    *outpipe;     /* Outbound pipe for filter or shapp   */
  struct InputDevice    *inpipe;      /* Inbound pipe for filter or shapp    */
  struct UserObject     *datauser;    /* points to USER if shared subprocess */
};

struct WindowList {
  struct GenericListNode link;  /* linked list part                      */
  void   *group;		/* some wm need to put a user in a group */
  void   *window;		/* discussion text window                */
  void   *statusline;		/* status line window                    */
  char    listen;		/* listening flag for whisper ability    */
  char    autofill;		/* auto-fill flag                        */
  struct UserObject *user;	/* user object bound to this window      */
};

struct IfaceMethods {
  void (*close)();		/* How to close the display */
  void (*beep)();		/* How to ring a bell */
  void (*suspend)();		/* How to suspend on a C-z */
  /* Window management commands */
  void (*fix_windows)();	/* How to re-arrange windows */
  void (*clear_window)();	/* Clears out the contents of a window */
  int  (*win_width)();		/* How wide is a window in characters */
  void (*set_label)();		/* How to set a label under a window */
  /* These are editing commands */
  void (*delete_char)();	/* How to delete a character */
  void (*delete_line)();	/* How to delete a line */
  void (*delete_word)();	/* How to delete one word */
  int  (*at_fill_column)();	/* Is window needing to be filled? */
  void (*put_text)();		/* Put text into a window */
  void (*refresh_window)();	/* Refresh a window (if needed by iface) */
  void (*refresh_screen)();	/* Refresh the whole screen */
  /* These are IO and information related commands */
  void (*flush_io)();		/* How to flush any waiting io */
  char (*read_next_char)();	/* Read the next character from io source */
  void *(*create_popup)();	/* How to create a popup window */
  void (*finish_popup)();	/* After filling a popup, make it appear */
  void (*nuke_popup)();		/* Remove a popup window */
  void (*echo_area_message)();	/* Make echo area message appear */
};

/*
 * ETALK_ESCAPE is the escape code used to escape messages to TCP
 * processes, or to the socket control process.
 */
#define ETALK_ESCAPE 0x03

/*
 * The following are MESSAGETYPES used to send messages to remote talk
 * clients who may know how to read escaped messages
 */
/* TCP_PERSONAL_NAME - Messaged containing long name of specified user */
#define TCP_PERSONAL_NAME 0x03
/* TCP_CONNECT_REQUEST - Code requesting new connection to specified user */
#define TCP_CONNECT_REQUEST 0x06
/* TCP_VERSION_MESSAGE - Sends a sequece of strings stating statistics
   about ourselves, such as version number, user name, and unsolicited
   port connect. */
#define TCP_VERSION_MESSAGE 0x08
/* TCP_FILTER_CONNECTION - sends a request to make this connection
   filtered using the parameters to determine the type of filter. */
#define TCP_FILTER_CONNECTION 0x09
/***
 * Skip 0xA because that is also end of line. ;)
 ***/
/* TCP_ANSWER - The answer to a posed question or initiation.
 * This is needed to put the answer data out-of-band so that it can be
 * found within a mix of other data. */
#define TCP_ANSWER 0x0B
#define TCP_ANSWER_INVALID -1
#define TCP_ANSWER_NO 0x00
#define TCP_ANSWER_YES 0x01

/*
 * The following defines are the MESSAGETYPE sent to the emacs
 * over the TTY.  Any character not listed (ie, A-z) means a message
 * to print in the minibuffer.
 */
/* socket number of emacs_connect */
#define TTY_LOCALPORT 0x01
/* socket number of remote_connect */
#define TTY_REMOTEPORT 0x02
/* user id of new user struct */
#define TTY_USERID 0x03
/* id of user struct just turned off. */
#define TTY_DELETED 0x04
/* a minibuff message which should not be logged. */
#define TTY_NOLOG 0x05
/* a look-here command to tell parent that the address of the */
/* currently connecting person should be done on a different system. */
#define TTY_LOOK_HERE 0x08
/* a new user window is required, so emacs must make a new TCP link
   right away to handle this. */
#define TTY_NEW_USER 0x09
/* A new TCP connection is required.  It can be unsolicited, or
   automatically generaged by the reply command */
#define TTY_NEW_DATA 0x0A
/* Load in this file, as it has just been transferred to us. */
#define TTY_SHOW_FILE 0x0B
/* Etalk yorn asks emacs to ask the user a y/n question. Controlling
   process must then send some response back. */
#define TTY_YORN 0x0C
/* Filter notification will tell us when a filter is enabled between
   us and a remote user so we may display that information in the mode-line */
#define TTY_FILTER_MESSAGE  0x0D
#define TTY_FILTER_OUTBOUND 0x01
#define TTY_FILTER_INBOUND  0x02

/* These codes are used when a new connection is for a datalink.  The
 * link is classified by one of these values, for the meaning to these
 * codes and the ones following, see the file EMBEDDED.TXT
 */
#define NEWLINK_DATA 0x01
#define NEWLINK_AUX 0x02
#define NEWLINK_APP 0x03
#define NEWLINK_MAX 0x03

/* The following definitions define a PROXY specifier when initiating
 * shared applications */
#define PROXY_NONE 0x00
#define PROXY_TO_ONE 0x01
#define PROXY_TO_N 0x02
#define PROXY_MAX 0x02

/* These define application requirement codes used when starting
   shared apps. */
#define DISPREQ_NONE 0x00
#define DISPREQ_KEYBOARD 0x01
#define DISPREQ_TTY 0x02
#define DISPREQ_X 0x03
#define DISPREQ_MAX 0x03

#ifdef PROTOTYPES
/* etalk.c */
extern void gtalk_shutdown(char *message);

/* gt_scan.c */
extern void SCAN_send_version(struct TalkContext *Ctxt, struct UserObject *uo);
extern void SCAN_remote_io(struct TalkContext *Ctxt, struct UserObject *uo, char *input, int *size);
extern void SCAN_evaluate(struct TalkContext *Ctxt, struct UserObject *uo);

/* gt_curses.c */
extern struct IfaceMethods *CURS_init(struct TalkContext *Ctxt);

/* gt_x.c */
extern struct IfaceMethods *X_init(struct TalkContext *Ctxt);

/* The following will hold true for all widget sets which may be used in the
 * future... */
/* gt_display.c */
extern void DISP_close(struct TalkContext *Ctxt);
extern void DISP_init(struct TalkContext *Ctxt);
extern void DISP_input(struct TalkContext *Ctxt, struct InputDevice *dev);
extern void DISP_message(struct TalkContext *Ctxt, char *message);
extern void DISP_new_user(struct TalkContext *Ctxt, struct UserObject *user);
extern void DISP_create_popup(struct TalkContext *Ctxt, int width, int height);
extern void DISP_remote_string(struct TalkContext *Ctxt, char *text, int size, struct UserObject *user);
extern void DISP_clean();
extern void DISP_fix_windows(struct TalkContext *Ctxt);
extern void DISP_help(struct TalkContext *Ctxt);
extern int DISP_yes_or_no(struct TalkContext *Ctxt, char *query);
extern int DISP_window_displayed(struct WindowList *win);
extern void DISP_update_user(struct TalkContext *Ctxt, struct UserObject *user);
extern void DISP_reset_any_prompts(struct TalkContext *Ctxt);
extern void DISP_suppress_feedback(struct TalkContext *Ctxt, int suppress);

/* gt_data.c */
extern void DATA_link_accept(struct TalkContext *Ctxt, struct InputDevice *io);
extern int DATA_send_file(struct TalkContext *Ctxt, struct UserObject *user, char *name);
extern struct InputDevice *DATA_open_new_connection(struct TalkContext *Ctxt, struct UserObject *uo, char typecode);
extern int DATA_aux_connection(struct TalkContext *Ctxt, struct UserObject *uo, struct UserObject *auxlink, char *function);

/* gt_cmd.c */
extern void GTC_parse_command(struct TalkContext *Ctxt, struct InputDevice *dev);
extern void GTC_interpret_string(struct TalkContext *Ctxt, char *buff);
extern char *GTC_c2str(char c);
extern int GTC_test();

/* gt_daemn.c */
extern void GT_reset_ids();
extern int DMN_Lookup(struct TalkContext *Ctxt, struct InputDevice *io,
		      char *r_user, char *r_tty);
extern struct sockaddr_in *DMN_get_lookup_response(struct TalkContext *Ctxt, struct InputDevice *io);
extern int DMN_Announce(struct TalkContext *Ctxt, struct InputDevice *io,
		 char *r_user, char *r_tty);
extern void DMN_get_and_display(struct TalkContext *Ctxt,
				struct InputDevice *io);
extern int DMN_Delete(struct TalkContext *Ctxt, struct InputDevice *io,
		      enum DMN_deletion_type type);
extern int DMN_LeaveInvite(struct TalkContext *Ctxt, char *r_user, char *r_tty);
extern int DMN_Reply_Query(struct TalkContext *Ctxt, struct InputDevice *io);
extern int DMN_get_invite_response(struct TalkContext *Ctxt, struct InputDevice *io);
extern int DMN_get_announce_response(struct TalkContext *Ctxt, struct InputDevice *io);
extern int DMN_get_delete_response(struct TalkContext *Ctxt, struct InputDevice *io);
extern struct sockaddr_in *DMN_get_reply_query_response(struct TalkContext *Ctxt, struct InputDevice *io);
extern char *DMN_last_response(struct InputDevice *io);
extern int DMN_last_response_numeric(struct InputDevice *io);
extern int DMN_last_response_version(struct InputDevice *io);
extern char *DMN_last_response_user(struct InputDevice *io);
extern struct sockaddr_in *DMN_last_addr(struct InputDevice *io);

/* gt_proto.c */
extern void PROTOCOL_connect(struct TalkContext *Ctxt, int userid, int sock,
		      char *user, char *node, char *tty);
extern void PROTOCOL_wait(struct TalkContext *Ctxt, int userid,
		   char *user, char *node, char *tty);
extern void PROTOCOL_reply(struct TalkContext *Ctxt);
extern void PROTOCOL_attach(struct TalkContext *Ctxt, int userid,
		     char *user, char *node, char *tty);
extern void PROTOCOL_delete_all(struct TalkContext *Ctxt, int terminate);
extern int PROTOCOL_abort(struct TalkContext *Ctxt);
extern int PROTOCOL_test(struct TalkContext *Ctxt, char *machine);
extern char *PROTOCOL_status(struct TalkContext *Ctxt);

/* gt_strm.c */
extern void STREAM_local_read(struct TalkContext *Ctxt, struct InputDevice *io);
extern void STREAM_remote_read(struct TalkContext *Ctxt, struct InputDevice *io);

/* gt_local.c */
extern void LOCAL_new_tcp(struct TalkContext *Ctxt, struct InputDevice *io);
extern int LOCAL_new_user_tty(struct TalkContext *Ctxt, char *user, char *tty);

/* gt_user.c */
extern struct UserObject *USER_alloc();
extern struct UserObject *USER_find(int id);
extern struct UserObject *USER_iofind(struct InputDevice *io);
extern void USER_print(struct TalkContext *Ctxt);
extern void USER_hangup(struct TalkContext *Ctxt, int id);
extern void USER_clean();
extern int USER_number();
extern struct UserObject *USER_namefind(char *name, char *host);
extern void USER_send_link_commands(struct TalkContext *Ctxt, struct UserObject *uo);
extern struct UserObject *USER_finduser(char *name);
extern struct UserObject *USER_finddata(struct UserObject *user);
extern void USER_send(struct TalkContext *Ctxt, struct UserObject *uo, char *buff, int size);
extern int USER_read(struct TalkContext *Ctxt, struct UserObject *uo, char *buff, int size);
extern int USER_get_answer(struct TalkContext *Ctxt, struct UserObject *uo);
extern struct UserObject *USER_OnlyOne();

/* gt_rc.c */
extern void RC_load_all_hosts(struct TalkContext *Ctxt);
extern int RC_load_file(struct TalkContext *Ctxt, char *filename);
extern int RC_read_script(struct TalkContext *Ctxt, char *fname);

/* gt_ring.c */
extern void ETR_read(struct TalkContext *Ctxt, struct InputDevice *dev);

/* gt_route.c */
extern int ROUTE_update(struct TalkContext *Ctxt, char *destination, char *address);
extern struct route_list *ROUTE_find_destination(int destination[]);
extern struct sockaddr *ROUTE_find_destination_masked(struct HostObject *destination);
extern void ROUTE_print(struct TalkContext *Ctxt);
extern int ROUTE_number();

/* gt_filter.c */
extern int FILTER_init(struct TalkContext *Ctxt, struct UserObject *uo, int type);
extern void FILTER_describe(struct TalkContext *Ctxt);
extern char *FILTER_name(int type);
extern void FILTER_outbound(struct TalkContext *Ctxt, struct UserObject *uo, char *inbuff, char *outbuff, int insize, int *outsize);
extern void FILTER_inbound(struct TalkContext *Ctxt, struct UserObject *uo, char *inbuff, char *outbuff, int insize, int *outsize);
extern void FILTER_respond(struct TalkContext *Ctxt, struct UserObject *uo, char *type, char *data);
extern int FILTER_index(char *name);


#else /* PROTOTYPES */
/* etalk.c */
extern void gtalk_shutdown();

/* gt_scan.c */
extern void SCAN_send_version();
extern void SCAN_remote_io();
extern void SCAN_evaluate();

/* gt_curses.c */
extern struct IfaceMethods *CURS_init();

/* gt_x.c */
extern struct IfaceMethods *X_init();

/* The following will hold true for all widget sets which may be used in the
 * future... */
/* gt_display.c */
extern void DISP_close();
extern void DISP_init();
extern void DISP_input();
extern void DISP_message();
extern void DISP_new_user();
extern void DISP_create_popup();
extern void DISP_remote_string();
extern void DISP_clean();
extern void DISP_fix_windows();
extern void DISP_help();
extern int DISP_yes_or_no();
extern int DISP_window_displayed();
extern void DISP_update_user();
extern void DISP_reset_any_prompts();
extern void DISP_suppress_feedback();

/* gt_data.c */
extern void DATA_link_accept();
extern int DATA_send_file();
extern struct InputDevice *DATA_open_new_connection();
extern int DATA_aux_connection();

/* gt_cmd.c */
extern void GTC_parse_command();
extern void GTC_interpret_string();
extern char *GTC_c2str();
extern int GTC_test();

/* gt_daemn.c */
extern void GT_reset_ids();
extern int DMN_Lookup();
extern struct sockaddr_in *DMN_get_lookup_response();
extern int DMN_Announce();
extern void DMN_get_and_display();
extern int DMN_Delete();
extern int DMN_LeaveInvite();
extern int DMN_Reply_Query();
extern int DMN_get_invite_response();
extern int DMN_get_announce_response();
extern int DMN_get_delete_response();
extern struct sockaddr_in *DMN_get_reply_query_response();
extern char *DMN_last_response();
extern int DMN_last_response_numeric();
extern int DMN_last_response_version();
extern char *DMN_last_response_user();
extern struct sockaddr_in *DMN_last_addr();

/* gt_proto.c */
extern void PROTOCOL_connect();
extern void PROTOCOL_wait();
extern void PROTOCOL_reply();
extern void PROTOCOL_attach();
extern void PROTOCOL_delete_all();
extern int PROTOCOL_abort();
extern int PROTOCOL_test();
extern char *PROTOCOL_status();

/* gt_strm.c */
extern void STREAM_local_read();
extern void STREAM_remote_read();

/* gt_local.c */
extern void LOCAL_new_tcp();
extern int LOCAL_new_user_tty();

/* gt_user.c */
extern struct UserObject *USER_alloc();
extern struct UserObject *USER_find();
extern struct UserObject *USER_iofind();
extern struct UserObject *USER_finddata();
extern void USER_print();
extern void USER_hangup();
extern void USER_clean();
extern int USER_number();
extern struct UserObject *USER_namefind();
extern void USER_send_link_commands();
extern struct UserObject *USER_finduser();
extern void USER_send();
extern int USER_read();
extern int USER_get_answer();
extern struct UserObject *USER_OnlyOne();

/* gt_rc.c */
extern void RC_load_all_hosts();
extern int RC_load_file();
extern int RC_read_script();

/* gt_ring.c */
extern void ETR_read();

/* gt_route.c */
extern int ROUTE_update();
extern struct route_list *ROUTE_find_destination();
extern struct route_list *ROUTE_find_destination_masked();
extern void ROUTE_print();
extern int ROUTE_number();

/* gt_filter.c */
extern int FILTER_init();
extern void FILTER_describe();
extern char *FILTER_name();
extern void FILTER_outbound();
extern void FILTER_inbound();
extern void FILTER_respond();

#endif /* PROTOTYPES */
#endif /* GTALK_ */
