/*
 * $Id: tls_cache.h 11212 2006-06-29 20:05:48Z cbiere $
 *
 * Copyright (c) 2006, Christian Biere
 *
 *----------------------------------------------------------------------
 * This file is part of gtk-gnutella.
 *
 *  gtk-gnutella is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  gtk-gnutella is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with gtk-gnutella; if not, write to the Free Software
 *  Foundation, Inc.:
 *      59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *----------------------------------------------------------------------
 */

#ifndef _tls_cache_h_
#define _tls_cache_h_

#include "common.h"

void tls_cache_init(void);
void tls_cache_insert(const host_addr_t addr, guint16 port);
gboolean tls_cache_lookup(const host_addr_t addr, guint16 port);
void tls_cache_close(void);

#endif /* _tls_cache_h_ */
/* vi: set ts=4 sw=4 cindent: */
