/*
 *     gtkatlantic - the gtk+ monopd client, enjoy network monopoly games
 *
 *
 *  Copyright (C) 2002-2004 Rochet Sylvain
 *
 *  gtkatlantic is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <glib.h>

/* all functions in eng_conv.c convert buff
 *
 * return 1 on success
 * return 0 if error occur
 *
 * all functions kill process if error occurs when allocate memory
 */

/* -- POSSIBLE CONVERT
 *
 * this program can't create table of color
 * 8bit pictures is only black&white pictures
 *
 * convert 8, 16 or 24 bits to mask mode :
 *
 *     --  8 to mask:
 *     original:  04 10 00 ef 00 f4
 *     final:     01 01 00 01 00 01
 *
 *     -- 16 to mask:
 *     original:  ffff 0000 0000 5de2 aaaa 0000 ffff 2222
 *     final:       01   00   00   01   01   00   01   01
 *
 *     -- 32 to mask:
 *     original:  ffffff 000000 778822 fed204 000000 000000 153233
 *     final:         01     00     01     01     00     00     01
 *
 */


/* -- prototypes for eng_conv.c -- */

void eng_conv_8_to_mask(guchar * in, guchar * out, guint32 nb_pixel);
void eng_conv_16_to_mask(guchar * in, guchar * out, guint32 nb_pixel);
void eng_conv_24_to_mask(guchar * in, guchar * out, guint32 nb_pixel);

/* -- end of prototypes -- */
