// -*- C++ -*-

/* window_test_flux.cc
 * 
 * Copyright (C) 2000 GtkExtra-- Development Team  
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "window_test_flux.h"
#include <math.h>

Window_Test_Flux::Window_Test_Flux()
: m_VBox(false, 0),
  m_PlotCanvas(GTK_PLOT_LETTER_W, GTK_PLOT_LETTER_H, 1),
  m_Plot1(0, .5, .25),
  m_Button1("1"),
  m_vecDataSets(5)
{ 
  set_title("GtkExtra::PlotFlux Demo");
  set_usize(550, 650);
  m_VBox.set_border_width(0);
  add(m_VBox);

  m_ScrolledWindow.set_border_width(0);
  m_ScrolledWindow.set_policy(GTK_POLICY_ALWAYS, GTK_POLICY_ALWAYS);
  m_VBox.pack_start(m_ScrolledWindow, true, true, 0);
  
  m_PlotCanvas.set_flags(GTK_PLOT_CANVAS_DND_FLAGS);
  m_ScrolledWindow.add_with_viewport(m_PlotCanvas);

  //Plot 1:
  m_PlotCanvas.set_active_plot(m_Plot1);
  m_Plot1.set_range(-1., 1., -1., 1.4);
  m_Plot1.legends_move( .500, .05);
  m_Plot1.set_legends_border(GTK_PLOT_BORDER_NONE,0);
  m_Plot1.axis_hide_title(GTK_PLOT_AXIS_TOP);
  m_Plot1.axis_show_ticks(GTK_PLOT_AXIS_BOTTOM, 15, 3);
  m_Plot1.axis_set_ticks(GTK_PLOT_AXIS_X, 1., 1);
  m_Plot1.axis_set_ticks(GTK_PLOT_AXIS_Y, 1., 1);
  m_Plot1.axis_set_visible(GTK_PLOT_AXIS_TOP, true);
  m_Plot1.axis_set_visible(GTK_PLOT_AXIS_RIGHT, true);
  m_Plot1.x0_set_visible(true);
  m_Plot1.y0_set_visible(true);

  m_PlotCanvas.add_plot(m_Plot1, .15, .06);

  build_example1(m_Plot1);
  m_Plot1.show();
 
  m_PlotCanvas.select_item.connect(slot(this, &Window_Test_Flux::on_PlotCanvas_select_item));

  //Buttons:
  m_Button1.set_usize(20, 20); 
  m_PlotCanvas.put(m_Button1, 0, 0);
   
  m_Button1.toggled.connect(bind<gint>(slot(this, &Window_Test_Flux::on_Button_toggled), 1));

  show_all();
  
  // (show the window before printing)
  m_PlotCanvas.export_ps("demoflux.ps", GTK_PLOT_PORTRAIT, false, GTK_PLOT_LETTER);
}

Window_Test_Flux::~Window_Test_Flux()
{
}

gint Window_Test_Flux::delete_event_impl(GdkEventAny*)
{ 
  Gtk::Main::quit();
  return 0; 
}

void
Window_Test_Flux::build_example1(GtkExtra::Plot& refPlot)
{
  static gdouble px1[]={0., 0.2, 0.4, 0.6, 0.8, 1.0};
  static gdouble py1[]={.2, .4, .5, .35, .30, .40};
  static gdouble px2[]={.12, .22, .27, .12, .052, .42};
  static gdouble py2[]={.0, .05, .12, .22, .16, .1};

  Gdk_Colormap colormap = refPlot.get_colormap();

  m_vecDataSets[0] = new GtkExtra::PlotFlux();
  refPlot.add_data(m_vecDataSets[0]);
  m_vecDataSets[0]->set_points(px1, py1, px2, py2, 6);
 
  Gdk_Color color("red");
  Gdk_Colormap::get_system().alloc(color); 

  m_vecDataSets[0]->set_symbol(GTK_PLOT_SYMBOL_CIRCLE,
			GTK_PLOT_SYMBOL_OPAQUE,
			10, 2, color, color);
  m_vecDataSets[0]->set_line_attributes(GTK_PLOT_LINE_NONE,
				1, color);

  m_vecDataSets[0]->set_legend("Flux");
  m_vecDataSets[0]->show();
}


gint
Window_Test_Flux::on_PlotCanvas_select_item(GdkEventButton* event, GtkPlotCanvasChild* item)
{
  if(item)
  {
	  switch(item->type)
	  {
	    case GTK_PLOT_CANVAS_TEXT:
          printf("Item selected: TEXT\n");
          break;
	    case GTK_PLOT_CANVAS_TITLE:
          printf("Item selected: TITLE\n");
          break;
	    case GTK_PLOT_CANVAS_LEGENDS:
          printf("Item selected: LEGENDS\n");
          break;
	    case GTK_PLOT_CANVAS_PLOT:
          printf("Item selected: PLOT\n");
          break;
	    case GTK_PLOT_CANVAS_AXIS:
          printf("Item selected: AXIS\n");
          break;
	    case GTK_PLOT_CANVAS_DATA:
	    {
          printf("Item selected: DATA\n");

          /* This isn't the same as active_x and active_y - they are always 0.
          gdouble x = 0;
          gdouble y = 0;
          m_PlotCanvas.get_active_point(x, y); 
          */
          printf("Active point: %d -> %f %f\n", 
                m_PlotCanvas.gtkobj()->active_point, //Not wrapped, because I'm not sure that it's really needed.
                m_PlotCanvas.gtkobj()->active_x, //See note above.
                m_PlotCanvas.gtkobj()->active_y //See note above.
                );
           
          break;
        }
	    case GTK_PLOT_CANVAS_NONE:
          printf("Item selected: NONE\n");
          break;
	    case GTK_PLOT_CANVAS_CUSTOM:
          printf("This is a custom child. Isn't it neat?\n");
          break;
        default:
          break;
	  }
  }

  if(item->type == GTK_PLOT_CANVAS_PLOT)
	{
	  //Activate the appropriate button:
	  //This doesn't really work, because the active_plot is the previously active plot,
	  //not the plot that will be active after this signal handler returns true.
	  //However, it doesn't work in the C version either, so this is a faithful transaltion.
	  
	  GtkExtra::Plot* pPlotActive = m_PlotCanvas.get_active_plot();
	  if(pPlotActive)
	  {
	    if(pPlotActive == &m_Plot1)
	    {
	      if(!m_Button1.get_active())
	      {
	        m_Button1.set_active(true);
	      }
	    }
	    else
	    {
	      m_Button1.set_active(false);
	    }
	  }
	}

  return true;
}

//iButtonNumber parameter is from a bind<>:
void
Window_Test_Flux::on_Button_toggled(gint iButtonNumber)
{
  //Select the appropriate plot:
  //Activate the appropriate grid:
  //This doesn't seem to do anything. Maybe 'active' != 'selected'.
  //However, it doesn't work in the C version either, so this is a faithful translation.
  GtkExtra::Plot* pPlot = 0;
  if(iButtonNumber == 1)
  {
    pPlot = &m_Plot1;
  }

  if(pPlot)
  {
    m_PlotCanvas.set_active_plot(*pPlot);
  }
}

void
Window_Test_Flux::activate_plot()
{
  GtkExtra::Plot* pPlot = 0;
  Gtk::ToggleButton* pButton = 0;
  Gtk::ToggleButton* pButtonOther = 0;
  
  pPlot = &m_Plot1;
  pButton = &m_Button1;
  
  if(pPlot && pButton)
  {
    m_PlotCanvas.set_active_plot(*pPlot);
    if(!(pButton->get_active())) pButton->set_active(true);
    
    pButton->queue_draw();
  }
}


