// guitune.cc
//
//    guitune - program for tuning instruments (actually an oscilloscope)
//    Copyright (C) 1999  Florian Berger
//    Email: florian.berger@jk.uni-linz.ac.at
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License Version 2 as
//    published by the Free Software Foundation;
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//

//#include <iostream.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <linux/soundcard.h>

#include <gtk--/main.h>
#include <gtk--/box.h>
#include <gtk--/spinbutton.h>
#include <gtk--/style.h>
#include <gtk--/frame.h>

#include <unistd.h>
#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include <string.h>

#include <math.h>

#include "guitune.h"

#include "resources.h"



//globally
double KAMMERTON, KAMMERTON_LOG;



int close_unistd(int fd){ return( close(fd) ); }
// unistd - close is not visible to widget because of own close function


void MainWidget::setTuningNorm()
{
    KAMMERTON=KAMMERTON_NORM;
    KAMMERTON_LOG=KAMMERTON_LOG_NORM;
    logview->draw_it();
}

void MainWidget::setTuningWien()
{
    KAMMERTON=KAMMERTON_WIEN;
    KAMMERTON_LOG=KAMMERTON_LOG_WIEN;
    logview->draw_it();
}

void MainWidget::setTuningPhys()
{
    KAMMERTON=KAMMERTON_PHYS;
    KAMMERTON_LOG=KAMMERTON_LOG_PHYS;
    logview->draw_it();
}


void MainWidget::setTuningEqui()
{
    logview->set_nat_tuning(false);
}


void MainWidget::setTuningNat()
{
    logview->set_nat_tuning(true);
}


void MainWidget::setScaleUS()
{
    logview->setScale(LogView::us_scale);
}

void MainWidget::setScaleUSAlt()
{
    logview->setScale(LogView::us_scale_alt);
}

void MainWidget::setScaleGE()
{
    logview->setScale(LogView::german_scale);
}

void MainWidget::setScaleGEAlt()
{
    logview->setScale(LogView::german_scale_alt);
}



void MainWidget::showLogView()
{
    logview->show();
}

void MainWidget::hideLogView()
{
    logview->hide();
}

void MainWidget::showOszi()
{
    oszi->show();
}

void MainWidget::hideOszi()
{
    oszi->hide();
}

double MainWidget::getTrigger()
{
    return(oszi->getTrigFact());
}

void MainWidget::setSampFreqVal( int sampfreq )
{
    i_pAdjSF->set_value(sampfreq);
}


void MainWidget::setSampFreq()
{
    sampfreq = (int) i_pAdjSF->get_value();
//    timer->stop();
    close_unistd(audio);
    audio=init_audio();
//    timer->start(0);
    oszi->setSampleFreq(sampfreq_exact);
//    emit signalSampFreqChanged();
}


void MainWidget::setSampNrVal( int sampnr )
{
    i_pAdjSN->set_value(sampnr);
}


void MainWidget::setSampNr()
{
    sampnr = (int) i_pAdjSN->get_value();
    oszi->setSampleNr(sampnr);
//    emit signalSampNrChanged();
}


void MainWidget::setTrigger()
{
    oszi->setTrigFact(i_pAdjTR->get_value());
//    emit signalTriggerChanged();
}


void MainWidget::setTriggerVal(double value)
{
//    oszi->setTrigFact(value);
    i_pAdjTR->set_value(value);
//    i_pAdjTR->changed();
//    emit signalTriggerChanged();
}


void MainWidget::setAdaptive()
{
    bool active;
    active = i_pCBAdapt->get_active();
    oszi->setAdaptive((int)active);
}


void MainWidget::setAdaptiveVal( int adaptive )
{
    i_pCBAdapt->set_active((bool)adaptive);
}



void MainWidget::setDSPName(const char *name)
{
//    timer->stop();
    close_unistd(audio);
    strcpy(dsp_devicename,name);
    audio=init_audio();
//    timer->start(0);
}

int MainWidget::init_audio()
{
// int audio_fd;

   printf("initializing audio at %s\n",dsp_devicename);

   audio = open(dsp_devicename, O_RDONLY);
   if (audio == -1) {
      perror(dsp_devicename);
      exit(1);
   }
   fcntl(audio,F_SETFD,FD_CLOEXEC);

//   ioctl(audio, SNDCTL_DSP_RESET, 0);
   if( strcmp(dsp_devicename,"/dev/stdin")==0 ){

      printf("reading data from stdin\n");
   		blksize=32;
      printf("  blocksize=%d\n",blksize);
      printf("  sampfreq=%d\n",sampfreq);
      sampfreq_exact=sampfreq;

   }else{

      ioctl(audio, SNDCTL_DSP_SETDUPLEX, 0);

      {int caps;
          ioctl( audio, SNDCTL_DSP_GETCAPS, &caps );
          printf("OSS-Version %d\n", caps & DSP_CAP_REVISION );
       		printf("  DUPLEX   = %X\n",caps & DSP_CAP_DUPLEX   );
          printf("  REALTIME = %X\n",caps & DSP_CAP_REALTIME );
          printf("  BATCH    = %X\n",caps & DSP_CAP_BATCH    );
          printf("  COPROC   = %X\n",caps & DSP_CAP_COPROC   );
          printf("  TRIGGER  = %X\n",caps & DSP_CAP_TRIGGER  );
          printf("  MMAP     = %X\n",caps & DSP_CAP_MMAP     );
   		}

   		blksize=8;  // 2^8 = 256
  		ioctl(audio, SNDCTL_DSP_SETFRAGMENT, &blksize);
//   ioctl(audio, SNDCTL_DSP_SETBLKSIZE, &blksize);

      ioctl(audio, SNDCTL_DSP_GETBLKSIZE, &blksize);
      printf("blocksize=%d\n",blksize);
   //blksize=4096;

      ioctl(audio, SNDCTL_DSP_SYNC, NULL);
//   int a_sampsize = 8;
//      int a_sampsize = AFMT_U8;
      i_sampfmt = AFMT_S16_LE;
      ioctl(audio, SNDCTL_DSP_SAMPLESIZE, &i_sampfmt);
      int a_stereo = 0;
      ioctl(audio, SNDCTL_DSP_STEREO, &a_stereo);

      int a_speed = sampfreq;
      printf("sampfreq=%d\n",sampfreq);
      ioctl(audio, SNDCTL_DSP_SPEED, &a_speed);
      ioctl(audio, SOUND_PCM_READ_RATE, &sampfreq);
      printf("sampfreq=%d\n",sampfreq);
      sampfreq_exact=sampfreq;

   }

   //int mixer = open("/dev/mixer", O_RDONLY, 0);
   //int vol=0xFFFF;
   //ioctl(mixer, SOUND_MIXER_WRITE_MIC, &vol);
   //printf("MIC-Volume=%d\n",vol);
   //close(mixer);

// printf("close(audio)=%d\n",close(audio));
// printf("close(audio)=%d\n",close(audio));

   return(audio);
}




MainWidget::MainWidget()
//: Gtk::Window()
{
    int i;
   //InitAudio();
//   setMinimumSize(490,240);

    KAMMERTON=KAMMERTON_NORM;
    KAMMERTON_LOG=KAMMERTON_LOG_NORM;

    strcpy(dsp_devicename,"/dev/dsp");

    sampnr=1024;
    sampfreq=11048;
    processing_audio=0;
    audio = init_audio();
    printf("Audiodriver initialized\n");

    freqs[0]=KAMMERTON; lfreqs[0]=KAMMERTON_LOG;
    for(i=1;i<12;i++){
        freqs [i] = freqs [i-1] * D_NOTE;
        lfreqs[i] = lfreqs[i-1] + D_NOTE_LOG;
    }

    oszi = new OsziView;
    oszi->setSampleNr( sampnr );
    oszi->setSampleFreq(sampfreq_exact);
    logview = new LogView;
    
//    Gtk::Style style = new Gtk::Style( new void );
//    Gdk_Font font("-*-helvetica-bold-r-*-*-15-*-*-*-*-*-*-*");
    //    get_style()->set_font( font );
    
//    freqview  = new Gtk::Label("freq");
//    nfreqview = new Gtk::Label("nfreq");
    freqview  = new LCDView("");
    freqview->set_usize(100,20);
    nfreqview = new LCDView("");
    nfreqview->set_usize(100,20);
    
//    nfreqview->set_style( style );
    
    
    i_pAdjSF = new Gtk::Adjustment(
                               11024.0,  // value
                                5000.0,  // lower
                               48000.0,  // upper
                                   1.0,  // step inc
                                 100.0,  // page inc
                                     0   // page size
                                  );
    
    i_pAdjSN = new Gtk::Adjustment(
                                1024.0,  // value
                                 100.0,  // lower
                               10000.0,  // upper
                                   1.0,  // step inc
                                 100.0,  // page inc
                                     0   // page size
                                  );
    
    i_pAdjTR = new Gtk::Adjustment(
                                   0.6,  // value
                                   0.0,  // lower
                                   1.0,  // upper
                                  0.05,  // step inc
                                   0.1,  // page inc
                                     0   // page size
                                  );
    i_pCBAdapt = new Gtk::CheckButton;

    
    Gtk::VBox * pMainBox = manage( new Gtk::VBox() );
//    add( *pMainBox );

       Gtk::HBox * pHBox = manage( new Gtk::HBox() );
//       pMainBox->pack_start( *pHBox,   true, true );
       this->pack_start( *pHBox,   true, true );
          pHBox->pack_start( *oszi, true, true, 3 );
          Gtk::VBox * pRightBox = manage( new Gtk::VBox() );
          pRightBox->set_spacing(2);
          pHBox->pack_start( *pRightBox, false, false, 3 );
             Gtk::VBox * pDataBox = manage( new Gtk::VBox() );
             pDataBox->set_spacing(6);
             pRightBox->pack_start( *pDataBox,  false, false, 3 );

                Gtk::HBox * pHBox0 = manage( new Gtk::HBox() );
                pDataBox->pack_start( *pHBox0,  false, false );
                   Gtk::Label * pLabel0 = manage( new Gtk::Label("Freq: ") );
                   pHBox0->pack_start( *pLabel0,   true, true );
                   pHBox0->pack_start( *freqview,  false, false );
                Gtk::HBox * pHBox1 = manage( new Gtk::HBox() );
                pDataBox->pack_start( *pHBox1,  false, false );
                   Gtk::Label * pLabel1 = manage( new Gtk::Label("Tune: ") );
                   pHBox1->pack_start( *pLabel1,    true, true );
                   pHBox1->pack_start( *nfreqview,  false, false );

             Gtk::Frame * pAdjFrame = manage( new Gtk::Frame("Adjust:") );
             pRightBox->pack_start( *pAdjFrame,  false, false );
                Gtk::VBox * pAdjBox = manage( new Gtk::VBox() );
                pAdjBox->set_spacing(6);
                pAdjBox->set_border_width(3);
                pAdjFrame->add( *pAdjBox );

                   Gtk::HBox * pHBox2 = manage( new Gtk::HBox() );
                   pAdjBox->pack_start( *pHBox2,      false, false );
                      Gtk::Label * pLabel2 = manage( new Gtk::Label("SF: ") );
                      pHBox2->pack_start( *pLabel2,    false, false );
                      Gtk::SpinButton * pSpinSF = manage( new Gtk::SpinButton(*i_pAdjSF) );
                      pHBox2->pack_start( *pSpinSF,    false, false );
                   Gtk::HBox * pHBox3 = manage( new Gtk::HBox() );
                   pAdjBox->pack_start( *pHBox3,      false, false );
                      Gtk::Label * pLabel3 = manage( new Gtk::Label("SN: ") );
                      pHBox3->pack_start( *pLabel3,    false, false );
                      Gtk::SpinButton * pSpinSN = manage( new Gtk::SpinButton(*i_pAdjSN) );
                      pHBox3->pack_start( *pSpinSN,    false, false );
                   Gtk::HBox * pHBox4 = manage( new Gtk::HBox() );
                   pAdjBox->pack_start( *pHBox4,      false, false );
                      Gtk::Label * pLabel4 = manage( new Gtk::Label("Trig.: ") );
                      pHBox4->pack_start( *pLabel4,    false, false );
                      Gtk::SpinButton * pSpinTR = manage( new Gtk::SpinButton(*i_pAdjTR) );
                      pHBox4->pack_start( *pSpinTR,    false, false );
                   Gtk::HBox * pHBox5 = manage( new Gtk::HBox() );
                   pAdjBox->pack_start( *pHBox5,      false, false );
                      Gtk::Label * pLabel5 = manage( new Gtk::Label("Adapt.: ") );
                      pHBox5->pack_start( *pLabel5,    false, false );
                      pHBox5->pack_start( *i_pCBAdapt,    false, false );
//       pMainBox->pack_start( *logview,   false, true );
       this->pack_start( *logview,   false, true );

       logview->set_usize(0,86);
       
       pSpinSF->set_usize(70,0);
       pSpinSN->set_usize(70,0);
       pSpinTR->set_digits(2);
       
//    i_pMainBox=pMainBox;
                
//    sampfreq_input -> setValue(sampfreq);
    i_pAdjSF->value_changed.connect( slot( this, &MainWidget::setSampFreq ) );
    i_pAdjSN->value_changed.connect( slot( this, &MainWidget::setSampNr ) );
    i_pAdjTR->value_changed.connect( slot( this, &MainWidget::setTrigger ) );

    i_pAdjSF->value_changed.connect( slot( oszi, &OsziView::drawScale ) );
    i_pAdjSN->value_changed.connect( slot( oszi, &OsziView::drawScale ) );

    i_pCBAdapt->toggled.connect( slot( this, &MainWidget::setAdaptive ) );

    destroy.connect( slot(this, &MainWidget::destroy_handler) );
        
    Gtk::Main::idle.connect(  slot( this, &MainWidget::proc_audio )  );
}


int MainWidget::myread(int file, unsigned char * data, unsigned size)
{
    if(i_sampfmt==AFMT_U8){
        return( read( file, data, size ) );
    } else if(i_sampfmt==AFMT_S16_LE) {
        return( read( file, data, size )/2 );
    }
}


int MainWidget::proc_audio()
{int i,j,n,trig,trigpos;
 static int k=0;
 unsigned char *c;
 short int *s;
 unsigned char * sample_uc;
 short int *     sample_s16le;
 double ldf,mldf;
 char str[50];

   processing_audio=1;
   trigpos=0;
   sample_uc    = (unsigned char *)sample;
   sample_s16le = (short int *)sample;
   c = sample_uc;
   s = sample_s16le;
   n=0;
   n = myread(audio, c, blksize);
   if(i_sampfmt==AFMT_U8){
       for( i=0; i<n && Abs(c[i]-128)<2; i++ );
   } else if(i_sampfmt==AFMT_S16_LE) {
       for( i=0; i<n && Abs(s[i])<256; i++ );
   }
   //i=-1;
   j=0; trig=0;
   if (i<n) do {
      if(i_sampfmt==AFMT_U8){
          for( ; i<n-1; i++ )   /* n-1 because of POSTRIG uses i+1 */
              if ( POSTRIG(c,i) ) { trig=1; trigpos=i; }
      }else if(i_sampfmt==AFMT_S16_LE){
          for( ; i<n-1; i++ )   /* n-1 because of POSTRIG uses i+1 */
              if ( POSTRIG_S16(s,i) ) { trig=1; trigpos=i; }
      }
      if( trig==0 ){
          n = myread(audio, c, blksize);
          j++;
          i=0;
      }
   }while( (!trig) && j<100 );
//   else printf("No Signal %d\n",blksize);
   if( trig ){
      for( i=n-trigpos; i<sampnr; i+=n ){
          if(i_sampfmt==AFMT_U8){
              c+=n;
              n = myread(audio, c, blksize);
          }else if(i_sampfmt==AFMT_S16_LE){
              s+=n;
              n = myread(audio, (unsigned char *)s, blksize);
          }
      }
//      oszi->setSampleFreq( sampfreq_exact );
      if(i_sampfmt==AFMT_U8){
          oszi->setSamplePtr( &sample_uc[trigpos] );
      }else if(i_sampfmt==AFMT_S16_LE){
          oszi->setSamplePtr( &sample_s16le[trigpos] );
      }
//      oszi->setSampleNr( sampnr );
      oszi->paintSample();
      freq_0t = (double)sampfreq*oszi->getfreq2();
      lfreq_0t = log(freq_0t);
      while ( lfreq_0t < lfreqs[0]-D_NOTE_LOG/2.0 ) lfreq_0t+=LOG_2;
      while ( lfreq_0t >= lfreqs[0]+LOG_2-D_NOTE_LOG/2.0 ) lfreq_0t-=LOG_2;
      mldf=D_NOTE_LOG; note_0t=0;
      for( i=0; i<12; i++ ){
          ldf = fabs(lfreq_0t-lfreqs[i]);
          if (ldf<mldf) { mldf=ldf; note_0t=i; }
      }
      logview->change_lfreq(lfreq_0t);
      sprintf(str,"%0.3f",freq_0t);
      freqview->set(str);
      double nfreq_0t=freqs[note_0t];
      while( nfreq_0t/freq_0t > D_NOTE_SQRT ) nfreq_0t/=2.0;
      while( freq_0t/nfreq_0t > D_NOTE_SQRT ) nfreq_0t*=2.0;
      sprintf(str,"%0.3f",nfreq_0t);
      nfreqview->set(str);
      
//      printf("Note: %s (%lfHz) Freq=%lf\n",
//	        note[note_0t],freqs[note_0t],freq_0t);
   }
   k++;
   processing_audio=0;
   
   return true;
}



MainWidget::~MainWidget()
{
//   delete oszi;
   close_unistd(audio);
}

int MainWidget::delete_event_impl(GdkEventAny *event)
{
    printf("executing delete_event_impl(GdkEventAny *event)\n");
    return false;
}

void MainWidget::destroy_handler()
{
    printf("executing destroy_handler()\n");
    Gtk::Main::quit();
}
