/* implements gnometoasters audio API.
 * it generally takes 16bit,BigEndian,Stereo,44.1khz as its stream format
 * the drivers themselves (/dev/dsp,esd,...) are defined in separate files
 * and merely registered through the functions of this api */

#ifndef AUDIO_H
#define AUDIO_H

#include <stdio.h>
#include <string.h>
#include <gtk/gtk.h>

#include "varman.h"
#include "preferences.h"
#include "varmanwidgets.h"

#define AUDIO_MAXDRIVERS 25

/* the audio driver definition
 * all the handler functions get called with a pointer to the audio_driver 
 * structure as their only argument.The pointer is generalized to a
 * gpointer and has to be converted to (audio_driver*) before it can be used.
 * 
 * FIXME: well need an entry to register configuration screens
 * we could do this by either providing two functions show() and hide()
 * or by specifying a GtkWidget which is then handled by audio.c automatically */
typedef struct 
{
   char name[256];
   int  (*open)(gpointer driver);
   void (*close)(gpointer driver);
   int  descriptor;
   gpointer data;
} audio_driver;

/* the driver database prototype */
typedef struct 
{
   audio_driver *driver[AUDIO_MAXDRIVERS];
   int drivers;
   GList *drivernames; /* A Glist containing the names of the audio drivers
			* this list is used by the preferences setup entry
			* of the audio subsystem to display a popdown menu
			* of available drivers */
   varmanwidgets_widget *currentdriver; /* holds the currently selected driver */
   
} audio_ddb_type;

extern audio_ddb_type audio_ddb;

/* init the audio driver system */
void audio_init();
audio_driver *audio_driver_create(char *name,
				  int (*open)(gpointer driver),
				  void (*close)(gpointer driver),
				  gpointer data);
/* register an audio driver */
int audio_driver_register(audio_driver*driver);
int audio_getdriverid_by_name(char *name);

/* some convenience macros */
#define audio_getdriver_by_id(id) audio_ddb.driver[id]
#define audio_getdriver_by_name(dname) audio_ddb.driver[audio_getdriverid_by_name(dname)]
#define audio_getdriver_default audio_getdriver_by_name(varman_getvar(global_defs,"audio_default"))

/* audio user commands */
#define audio_open(driver)  driver->open((gpointer)driver)
#define audio_close(driver) driver->close((gpointer)driver)

#endif // AUDIO_H
