/* This file tracks all the changes in gnometoaster's default
 * configuration and warns the user if essential facts have changed */

#include <gtk/gtk.h>

#include "config.h"

#include "preferences.h"
#include "varman.h"
#include "dialog.h"
#include "filetypes.h"
#include "wheel.h"

#include "int.h"
#include "defaultentries.h"

#define currentversion varman_getvar_value(global_defs,"configfile_version")
#define	addinfo(text) gtk_text_insert(GTK_TEXT(updateinfo),NULL,NULL,NULL,text,-1)

/* this is the current config file version */
#define CONFIG_VERSION 18

/* started Mar 17th 2002 */
void configupdate_to18(int execute,gpointer data)
{
   if (execute==DIALOG_YES)
     {
	varman_setvar(global_defs,
		      "rec_sbgetid",
		      DEFAULTENTRIES_REC_SBGETID);
     };
};



/* started Oct 29th 2001 */
void configupdate_to17(int execute,gpointer data)
{
   if (execute==DIALOG_YES)
     {
	  filetypes_modify(filetypes_getfiletypehandler(".ogg"),
			   NULL,
			   NULL,
			   -1,
			   NULL,
			   DEFAULTENTRIES_EXEC_OGG123,
			   NULL,
			   NULL,
			   NULL,
			   -1,
			   -1,
			   NULL
			   );	
     };
};


/* started Oct 27th 2001 */
void configupdate_to16(int execute,gpointer data)
{
   if (execute==DIALOG_YES)
     {
	  filetypes_modify(filetypes_getfiletypehandler(".mp3"),
			   NULL,
			   NULL,
			   -1,
			   NULL,
			   NULL,
			   NULL,
			   NULL,
			   NULL,
			   -1,
			   -1,
			   DEFAULTENTRIES_SETTITLE_MP3
			   );	
     };
};


/* started May 12th 2001 */
void configupdate_to15(int execute,gpointer data)
{
   if (execute==DIALOG_YES)
     {
	/* Create new filetype registry entries if they don't yet exist */
	filetypes_filetypeentry *entry=filetypes_getfiletypehandler(".shn");
	if (!strcmp(entry->suffix,"default"))
	  /* Entry doesn't exist */
	  filetypes_register(filetypes_entrycreate(".shn",
						   "audio",
						   0,
						   ((preferences_bigendian)
						    ?DEFAULTENTRIES_LITTLEENDIAN
						    :DEFAULTENTRIES_BIGENDIAN),
						   DEFAULTENTRIES_EXEC_SHORTEN,
						   DEFAULTENTRIES_DETSIZE_SHN,
						   DEFAULTENTRIES_SIZEALG_SHN,
						   "",
						   0,
						   DEFAULTENTRIES_ENC_DEFAULT_SHN,
						   ""
						   ));
	entry=filetypes_getfiletypehandler(".ogg");
	if (!strcmp(entry->suffix,"default"))
	  /* Entry doesn't exist */
	  filetypes_register(filetypes_entrycreate(".ogg",
						   "audio",
						   0,
						   ((preferences_bigendian)
						    ?DEFAULTENTRIES_BIGENDIAN
                                                    :DEFAULTENTRIES_LITTLEENDIAN),
                                                   DEFAULTENTRIES_EXEC_OGG123,
						   DEFAULTENTRIES_DETSIZE_OGG,
						   DEFAULTENTRIES_SIZEALG_OGG,
						   DEFAULTENTRIES_ENCODER_OGG,
						   DEFAULTENTRIES_ENC_LENDIAN_OGG,
						   DEFAULTENTRIES_ENC_DEFAULT_OGG,
						   ""
						   ));
	varman_setvar(global_defs,
		      "rec_writetrack",
		      DEFAULTENTRIES_REC_WRITETRACK);
	varman_setvar(global_defs,
		      "rec_writecd",
		      DEFAULTENTRIES_REC_WRITECD);	
     };
};

/* started Mar 31st 2001 */
void configupdate_to14(int execute,gpointer data)
{
   if (execute==DIALOG_YES)
     {
	varman_setvar(global_defs,
		      "isotrack_tscalc",
		      DEFAULTENTRIES_ISOTRACK_TSCALC);
     };
};

/* started Jan 16th 2001 */
void configupdate_to13(int execute,gpointer data)
{
   if (execute==DIALOG_YES)
     {
	if (preferences_bigendian)
	  filetypes_modify(filetypes_getfiletypehandler(".wav"),
			   NULL,
			   NULL,
			   -1,
			   DEFAULTENTRIES_LITTLEENDIAN,
			   NULL,
			   NULL,
			   NULL,
			   NULL,
			   -1,
			   -1,
			   NULL
			   );
	varman_setvar(global_defs,
		      "isotrack_client",
		      DEFAULTENTRIES_ISOTRACK_CLIENT);
	varman_setvar(global_defs,
		      "isotrack_tsclient",
		      DEFAULTENTRIES_ISOTRACK_TSCLIENT);
	varman_setvar(global_defs,
		      "rec_daowrite",
		      DEFAULTENTRIES_REC_DAOWRITE);
     };
};

/* started Dec 11th 2000 */
void configupdate_to12(int execute,gpointer data)
{
   if (execute==DIALOG_YES)
     {
	varman_setvar(global_defs,
		      "rec_inqdrive_getmountpoint_exp",
		      DEFAULTENTRIES_REC_INQDRIVE_GETMOUNTPOINT_EXP);
	if (preferences_bigendian)
	  filetypes_modify(filetypes_getfiletypehandler(".mp3"),
			   NULL,
			   NULL,
			   -1,
			   DEFAULTENTRIES_BIGENDIAN,
			   NULL,
			   NULL,
			   NULL,
			   NULL,
			   -1,
			   -1,
			   NULL
			   );
     };
};

/* started Aug 29th 2000 */
void configupdate_to11(int execute,gpointer data)
{
   if (execute==DIALOG_YES)
     {
	filetypes_modify(filetypes_getfiletypehandler(".wav"),
			 NULL,
			 NULL,
			 -1,
			 NULL,
			 NULL,
			 NULL,
			 NULL,
			 DEFAULTENTRIES_ENCODER_WAV,
			 -1,
			 -1,
			 NULL
			 );
     };
};

/* started Aug 28th 2000 */
void configupdate_to10(int execute,gpointer data)
{
   if (execute==DIALOG_YES)
     {
	filetypes_modify(filetypes_getfiletypehandler(".mp3"),
			 NULL,
			 NULL,
			 -1,
			 NULL,
			 NULL,
			 NULL,
			 NULL,
			 DEFAULTENTRIES_ENCODER_MP3,
			 DEFAULTENTRIES_ENC_LENDIAN_MP3,
			 DEFAULTENTRIES_ENC_DEFAULT_MP3,
			 NULL
			 );
	filetypes_modify(filetypes_getfiletypehandler(".wav"),
			 NULL,
			 NULL,
			 -1,
			 NULL,
			 NULL,
			 NULL,
			 NULL,
			 DEFAULTENTRIES_ENCODER_WAV,
			 DEFAULTENTRIES_ENC_LENDIAN_WAV,
			 DEFAULTENTRIES_ENC_DEFAULT_WAV,
			 NULL
			 );
     };
};

/* started Aug 14th 2000 */
void configupdate_to9(int execute,gpointer data)
{
   if (execute==DIALOG_YES)
     {
	varman_setvar(global_defs,
		      "audiotrack_read",
		      DEFAULTENTRIES_AUDIOTRACK_READ);
     };
};

/* Inform the user about the new drive scheme and the requirement
 * for manual interaction */
void configupdate_to9_critical(int execute,gpointer data)
{
   dialog_ok(_("This Version of Gnometoaster is providing a new\n"
	       "drive setup scheme. You have to reconfigure your\n"
	       "CDROM and recorder settings. Usually, all it takes\n"
	       "is pressing the \"Scan Bus\" button in Gnometoaster's\n"
	       "new drive setup\n"));
};

/* started Jun. 04th 2000 */
void configupdate_to8(gint execute,gpointer data)
{
   if (execute==DIALOG_YES)
     {
	varman_setvar(global_defs,
		      "isotrack_client",
		      DEFAULTENTRIES_ISOTRACK_CLIENT);
	varman_setvar(global_defs,
		      "isotrack_mount",
		      DEFAULTENTRIES_ISOTRACK_MOUNT);
	varman_setvar(global_defs,
		      "isotrack_umount",
		      DEFAULTENTRIES_ISOTRACK_UMOUNT);
	varman_setvar(global_defs,
		      "isotrack_msoption",
		      DEFAULTENTRIES_ISOTRACK_MSOPTION);
	varman_setvar(global_defs,
		      "rec_daowrite",
		      DEFAULTENTRIES_REC_DAOWRITE);
	varman_setvar(global_defs,
		      "rec_fixate",
		      DEFAULTENTRIES_REC_FIXATE);
	varman_setvar(global_defs,
		      "rec_writetrack",
		      DEFAULTENTRIES_REC_WRITETRACK);
	varman_setvar(global_defs,
		      "rec_cleardisc",
		      DEFAULTENTRIES_REC_CLEARDISC);
	varman_setvar(global_defs,
		      "rec_ejectdisc",
		      DEFAULTENTRIES_REC_EJECTDISC);
	varman_setvar(global_defs,
		      "rec_writetrack",
		      DEFAULTENTRIES_REC_WRITETRACK);
	varman_setvar(global_defs,
		      "rec_getmsinfo",
		      DEFAULTENTRIES_REC_GETMSINFO);
	filetypes_modify(filetypes_getfiletypehandler(".mp3"),
			 NULL,
			 NULL,
			 -1,
			 NULL,
			 DEFAULTENTRIES_EXEC_MPG123,
			 "",
			 DEFAULTENTRIES_SIZEALG_MP3,
			 NULL,
			 -1,
			 -1,
			 NULL
			 );
     };
};

/* started Apr. 15th 2000 */
void configupdate_to7(gint execute,gpointer data)
{
   if (execute==DIALOG_YES)
     {
	varman_setvar(global_defs,
		      "isotrack_tscalc",
		      DEFAULTENTRIES_ISOTRACK_TSCALC);
     };
};

/* started Mar. 28th 2000 */
void configupdate_to6(gint execute,gpointer data)
{
   if (execute==DIALOG_YES)
     {
	filetypes_modify(filetypes_getfiletypehandler(".wav"),
			 NULL,
			 NULL,
			 -1,
			 NULL,
			 NULL,
			 NULL,
			 DEFAULTENTRIES_SIZEALG_WAV,
			 NULL,
			 -1,
			 -1,
			 NULL
			 );
     };
};

/* started Feb. 20th 2000 */
void configupdate_to5(gint execute,gpointer data)
{
   if (execute==DIALOG_YES)
     {
	varman_setvar(global_defs,
		      "isotrack_client",
		      DEFAULTENTRIES_ISOTRACK_CLIENT
		      );
	varman_setvar(global_defs,
		      "rec_writetrack",
		      DEFAULTENTRIES_REC_WRITETRACK
		      );
     };
};

/* started Jan. 08th 2000 */
void configupdate_to4(gint execute,gpointer data)
{
   if (execute==DIALOG_YES)
     {
	varman_setvar(global_defs,
		      "isotrack_client",
		      DEFAULTENTRIES_ISOTRACK_CLIENT
		      );
     };
};

/* started Nov. 20th */
void configupdate_to3(gint execute,gpointer data)
{
   if (execute==DIALOG_YES)
     {
	filetypes_modify(filetypes_getfiletypehandler(".mp3"),
			 NULL,
			 NULL,
			 -1,
			 NULL,
			 DEFAULTENTRIES_EXEC_MPG123,
			 NULL,
			 NULL,
			 NULL,
			 -1,
			 -1,
			 NULL
			 );
	varman_setvar(global_defs,
		      "isotrack_client",
		      DEFAULTENTRIES_ISOTRACK_CLIENT
		      );
     };
};

/* started Oct 19th */
void configupdate_to2(gint execute,gpointer data)
{
   if (execute==DIALOG_YES)
     {
	varman_setvar(global_defs,
		      "isotrack_client",
		      DEFAULTENTRIES_ISOTRACK_CLIENT
		      );
     };
};

void configupdate_to1(gint execute,gpointer data)
{
   if (execute==DIALOG_YES)
     {
	varman_setvar(global_defs,
		      "rec_writetrack",
		      DEFAULTENTRIES_REC_WRITETRACK
		      );
	varman_setvar(global_defs,
		      "rec_fixate",
		      DEFAULTENTRIES_REC_FIXATE
		      );
	varman_setvar(global_defs,
		      "rec_cleardisc",
		      DEFAULTENTRIES_REC_CLEARDISC
		      );
     };
};

void configupdate_confignewerthanexe(gint execute,gpointer data)
{
   if (execute==DIALOG_NO)
     {
	/* don't save settings */
	preferences_saveonexit=0;
	/* exit gnometoaster as soon as it enters the main loop */
	gtk_main_quit();
     };
};

static gchar *messages[] =
{
   N_("A Configfile for a newer version\n"
      "of Gnometoaster was found.\n"
      "Continuing may be dangerous because\n"
      "of possible changes in the file\n"
      "structure which may destroy your\n"
      "entire configuration.\n"
      "Do you want to run Gnometoaster anyway ?\n"),

   N_("Introducing multisession toc and dummy write\n"
      "functionality into gnometoaster requires a few\n"
      "modifications in gnometoaster's configuration setup\n"
      "I can do the necessary modifications\n"
      "automatically.You will lose\n"
      "your customized configuration\n"
      "of \"Preferences/Recorder/Trackwrite command\",\n"
      "\"Preferences/Recorder/Fixating Command\"\n"
      "and \"Preferences/Recorder/Clear Disc\"\n"
      "If you want to modify those entries yourself,\n"
      "just answer NO to this question.\n"
      "(New Variables rec_multisession,rec_dummymode)\n"),

   N_("This version of Gnometoaster switches the underlying\n"
      "filesystem creator from mkhybrid to mkisofs.\n"
      "You can,of course,continue to use mkhybrid.\n"
      "Just answer no to this question in this case.\n"),

   N_("This update fixes a bug in the mp3 client call\n"
      "which made gnometoaster record non-cd-quality\n"
      "mp3 files with 2x or 4x the speed of the original.\n"
      "(modifies filetype registry's mp3 entry).\n\n"
      "Also,El Torito bootable support requires your mkisofs\n"
      "calls to be modified.\n"),

   N_("This version of Gnometoaster enables setting the\n"
      "volume id of an iso track from fsedit.\n"
      "To accomplish this,the default mkisofs call\n"
      "in both the standard and the multisession version.\n"
      "has to be modified.\n"),

   N_("This version of Gnometoaster makes it possible to calculate\n"
      "the tracksize of an isotrack accurately by calling mkisofs\n"
      "for that purpose. Some further cleanups rid the configuration\n"
      "of a separate multisession isotrack call,incorporating multi-\n"
      "session support into the main iso image call as an option.\n"
      "One of the immediate results of those efforts is that now\n"
      "we can safely give the calculated tracksize to cdrecord\n"
      "to support recorders needing this value in advance.\n"
      "However,to accomplish that,the cdrecord write_track call\n"
      "has to be updated.\n"),

   N_("This version of Gnometoaster is capable of calculating the\n"
      "Tracksize of an audio track created from a wav file accurately.\n"
      "To make use of this feature,the tracksize detection line\n"
      "of the wav file filetype registry entry needs to be changed.\n"),

   N_("In order to fix a bug calculating the tracksize of an El Torito\n"
      "bootable filesystem,Gnometoaster needs to update the calculation\n"
      "rules stored in isotrack_tscalc.\n"),

   N_(
      "This fix removes the -a option from the default mkisofs call\n"
      "to meet the requirements of recent mkisofs versions which would\n"
      "otherwise reject the call and create wrong track sizes for\n"
      "iso tracks.\n"
      "Also, several calls must be\n"
      "updated to match the new drive setup scheme.\n"
      "Apart from that, a bug recording/playing mono mp3s has been\n"
      "fixed in the default mpg123 call.\n"
      "Finally, from this version on gnometoaster can calculate the\n"
      "tracksize of mp3 audio tracks internally.\n"
      "Your configfile will be changed to facilitate this new\n"
      "functionality.\n"),

   N_("We have do makde a few adjustments to the standard DAE call\n"
      "in Gnometoaster's preferences in order to support an additional\n"
      "field of Gnometoaster's drive setup scheme.\n"),

   N_("This version of Gnometoaster introduces the capability to store\n"
      "audio tracks to your harddrive as files. Gnometoaster will\n"
      "now adjust it's preferences to support storing audio tracks\n"
      "to your harddrive as either .wav or .mp3 files (where the latter\n"
      "is the default).\n"),

   N_("This version fixes a wrong sox call for audiotrack->wav conversion.\n"
      "in your filetype registry.\n"),

   N_("This version of Gnometoaster fixes a bug in the mountpoint autodetect\n"
      "expression of your recorder setup\n"
      "If you're running on a Big Endian system (e.g. PowerPC) I'll fix\n"
      "some parameters for the mp3 decoder to work properly\n"),

   N_("This version will fix broken .wav functionality on Big Endian Systems (e.g. PowerPC).\n"
      "It also removes the option to configure the filesystem destination area from your preferences.\n"
      "The symbolic link tree will be built in your temp directory from now on.\n"
      "Also note that the default cdrdao call will be changed to support CD-Text writing which implies making \"generic-mmc\" it's default driver\n"
      ),

   N_("Due to changes in the commandline parameters of mkisofs in recent releases\n"
      "Gnometoaster's tracksize detection scheme for ISO tracks needs to be changed.\n"
      ),
   N_("This version of GnomeToaster introduces two new filetypes supported by default:\n"
      "Ogg-Vorbis and Shorten. I will now create the corresponding filetype registry entries\n"
      "for those filetypes. If you want to actually use them, also make sure to install the commandline tools\n"
      "needed to decode them. GnomeToaster will tell you about the tools you need when you start using\n"
      "the new filetypes. (Note: In case you already have entries for .ogg or .shn "
      "in your filetypes registry, those entries will be left untouched)."
      "\n"
      "This version of GnomeToaster also adds native support for buffer-underrun protection "
      "schemes of all kind (burn-proof, just-link, ...) as far as supported by cdrecord."),
   N_("This version of GnomeToaster will automatically set the title and artist ID3 tags\n"
      "of any mp3 files encoded through it using the mp3info tool.\n"
      "This requires an additional commandline call to be inserted into the mp3 encoder profile\n"
      "of GnomeToaster's internal filetypes registry.\n"
      "Do you want me to perform all necessary changes for you ?\n"),
   N_("This version of GnomeToaster adapts to a new commandline scheme to be applied\n"
      "for ogg123, the ogg-vorbis file decoder.\n"
      "Answering this question with yes will break compatibility with\n"
      "versions of ogg123 older than 1.0rc2\n"),
   N_("This version of GnomeToaster will fix the recorder detection\n"
      "scheme to be able to properly autodetect some USB recorders.\n"
      "Thanks to Alec Flett for telling me about the problem and also\n"
      "providing a solution to it.\n")
};

static gchar *firstrun=
  N_("You're running Gnometoaster for the first time.\n"
     "All Preferences have been set to default values.\n"
     "Make sure you change all settings to match your system!");

/* execute an updatehandler if config version is older than what it's defined
 * for. updatehandlers themselves check the result var and react accordingly.
 * There's no break statement in this switch structure, so once a match
 * was found, all consequent commands will be executed as well */
#define execifneeded(bla,ver) if (currentversion<=ver) bla(result,data)

void configupdate_updateall(int result,gpointer data)
{
   execifneeded(configupdate_to1,0);
   execifneeded(configupdate_to2,1);
   execifneeded(configupdate_to3,2);
   execifneeded(configupdate_to4,3);
   execifneeded(configupdate_to5,4);
   execifneeded(configupdate_to6,5);
   execifneeded(configupdate_to7,6);
   execifneeded(configupdate_to8,7);
   execifneeded(configupdate_to9,8);
   execifneeded(configupdate_to10,9);
   execifneeded(configupdate_to11,10);
   execifneeded(configupdate_to12,11);
   execifneeded(configupdate_to13,12);
   execifneeded(configupdate_to14,13);
   execifneeded(configupdate_to15,14);
   execifneeded(configupdate_to16,15);
   execifneeded(configupdate_to17,16);
   execifneeded(configupdate_to18,17);

   /* increase configfile version number */
   varman_setvar_value(global_defs,"configfile_version",CONFIG_VERSION);
};

/* Execute those regardless of what the user says (don't even ask ;-)) */
void configupdate_critical()
{
   /* make our macro happy */
   int result=DIALOG_YES;
   gpointer data=NULL;

   execifneeded(configupdate_to9_critical,8);
};

void configupdate_run()
{
   /* if updating from an older version */
   if (!preferences_freshinstall)
     {

	if (CONFIG_VERSION<currentversion)
	  {
	     dialog_question(_(messages[0]), configupdate_confignewerthanexe, NULL);
	  };
	/* build version upgrade info text */
	if (CONFIG_VERSION>currentversion)
	  {
	     int x;
	     GtkWidget *textandadj=gtk_hbox_new(0,0);
	     GtkWidget *scrolling;
	     GtkWidget *updateinfo=gtk_text_new(NULL,NULL);
	     gtk_text_set_editable(GTK_TEXT(updateinfo),0);
	     gtk_text_set_word_wrap(GTK_TEXT(updateinfo),1);
	     scrolling=gtk_vscrollbar_new(GTK_TEXT(updateinfo)->vadj);
	     gtk_box_pack_start(GTK_BOX(textandadj),updateinfo,1,1,1);
	     gtk_widget_show(updateinfo);
	     gtk_box_pack_start(GTK_BOX(textandadj),scrolling,0,0,0);
	     gtk_widget_show(scrolling);
	     wheel_connect(updateinfo,GTK_TEXT(updateinfo)->vadj,4);

	     /* those handlers have to be executed anyway.
	      * Usually, those handlers request user interaction */
	     configupdate_critical();

	     for (x=currentversion+1;x<=CONFIG_VERSION;x++)
	       addinfo(_(messages[x]));

	     dialog_showuserwidget(_("Configfile maintenance informations"),
				   textandadj,
				   DIALOG_USERWIDGET_QUESTION,
				   configupdate_updateall,NULL);
	  };
     }
   else
     {
	/* There's no configfile yet */
	dialog_ok(_(firstrun) );
	/* set configfile version number */
	varman_setvar_value(global_defs,"configfile_version",CONFIG_VERSION);
     };
};
