#include "gtweakui.h"
#include <stdio.h>

void hide_about(GtkWidget *widget, gpointer data) {
	gtk_widget_hide(data);
}

gboolean delete_about(GtkWidget *widget, GdkEvent *event, gpointer data) {
	gtk_widget_hide(data);
	return TRUE;
}

void about(GtkWidget *widget, gpointer data) {
	static GladeXML *ad = NULL;
	static GtkWidget *about_dialog;
	GtkWidget *b;
	GString *title;
	if (ad == NULL) {
		ad = glade_xml_new(gnome_program_locate_file(gtweakui, GNOME_FILE_DOMAIN_APP_DATADIR, "about.glade", FALSE, NULL), NULL, NULL);
		
		about_dialog = xmlg(ad, "about");
		if (data != NULL)
			gtk_window_set_transient_for(GTK_WINDOW(about_dialog), GTK_WINDOW(data));
		xsc (ad, "close_button", "clicked", hide_about, about_dialog);
		gsc(about_dialog, "delete_event", delete_about, about_dialog);
		title = g_string_new("<b> ");
		title = g_string_append(title, "gTweakUI");
		title = g_string_append(title, " ");
		title = g_string_append(title, PACKAGE_VERSION);
		title = g_string_append(title, "</b>");
		gtk_label_set_markup(GTK_LABEL(xmlg(ad, "title")), title->str);
		g_string_free(title, TRUE);
	} else {
		gtk_widget_show(about_dialog);
	}
}
