/* GXemul: $Id: alpha_lcareg.h,v 1.2 2006/06/16 18:31:26 debug Exp $ */
/* $NetBSD: lcareg.h,v 1.8 1997/09/05 02:14:31 thorpej Exp $ */

#ifndef ALPHA_LCAREG_H
#define	ALPHA_LCAREG_H

/*
 * Copyright (c) 1995 Carnegie-Mellon University.
 * All rights reserved.
 *
 * Authors: Jeffrey Hsu, Jason R. Thorpe
 * 
 * Permission to use, copy, modify and distribute this software and
 * its documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" 
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND 
 * FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 *
 *  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
 *  School of Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 *
 * any improvements or extensions that they make and grant Carnegie the
 * rights to redistribute these changes.
 */

/*
 * 21066 chip registers
 */

#define REGVAL(r)	(*(volatile int32_t *)ALPHA_PHYS_TO_K0SEG(r))
#define REGVAL64(r)	(*(volatile int64_t *)ALPHA_PHYS_TO_K0SEG(r))

/*
 * Base addresses
 */
#define LCA_IOC_BASE	0x180000000ULL		/* LCA IOC Regs */
#define LCA_PCI_SIO	0x1c0000000ULL		/* PCI Sp. I/O Space */
#define LCA_PCI_CONF	0x1e0000000ULL		/* PCI Conf. Space */
#define LCA_PCI_SPARSE	0x200000000ULL		/* PCI Sparse Space */
#define LCA_PCI_DENSE	0x300000000ULL		/* PCI Dense Space */

#define LCA_IOC_HAE	LCA_IOC_BASE		/* Host Address Ext. (64) */
#define	IOC_HAE_ADDREXT	0x00000000f8000000ULL
#define	IOC_HAE_RSVSD	0xffffffff07ffffffULL

#define LCA_IOC_CONF	(LCA_IOC_BASE + 0x020)	/* Configuration Cycle Type */

#define LCA_IOC_STAT0	(LCA_IOC_BASE + 0x040)	/* Status 0 */
#define	IOC_STAT0_CMD	0x000000000000000fULL	/* PCI command mask */
#define	IOC_STAT0_ERR	0x0000000000000010ULL	/* IOC error indicator R/W1C */
#define	IOC_STAT0_LOST	0x0000000000000020ULL	/* IOC lose error info R/W1C */
#define	IOC_STAT0_THIT	0x0000000000000040ULL	/* test hit */
#define	IOC_STAT0_TREF	0x0000000000000080ULL	/* test reference */
#define	IOC_STAT0_CODE	0x0000000000000700ULL	/* code mask */
#define	IOC_STAT0_CODESHIFT 8
#define	IOC_STAT0_P_NBR	0x00000000ffffe000ULL	/* page number mask */

#define LCA_IOC_STAT1	(LCA_IOC_BASE + 0x060)	/* Status 1 */
#define	IOC_STAT1_ADDR	0x00000000ffffffffULL	/* PCI address mask */

#define	LCA_IOC_TBIA	(LCA_IOC_BASE + 0x080)	/* TLB Invalidate All */
#define	LCA_IOC_TB_ENA	(LCA_IOC_BASE + 0x0a0)	/* TLB Enable */
#define	IOC_TB_ENA_TEN	0x0000000000000080ULL

#define LCA_IOC_W_BASE0	(LCA_IOC_BASE + 0x100)	/* Window Base */
#define LCA_IOC_W_MASK0	(LCA_IOC_BASE + 0x140)	/* Window Mask */
#define LCA_IOC_W_T_BASE0 (LCA_IOC_BASE + 0x180) /* Translated Base */

#define LCA_IOC_W_BASE1	(LCA_IOC_BASE + 0x120)	/* Window Base */
#define LCA_IOC_W_MASK1	(LCA_IOC_BASE + 0x160)	/* Window Mask */
#define LCA_IOC_W_T_BASE1 (LCA_IOC_BASE + 0x1a0) /* Translated Base */

#define	IOC_W_BASE_W_BASE 0x00000000fff00000ULL	/* Window base value */
#define	IOC_W_BASE_SG	  0x0000000100000000ULL	/* Window uses SGMAPs */
#define	IOC_W_BASE_WEN	  0x0000000200000000ULL	/* Window enable */

#define	IOC_W_MASK_1M	0x0000000000000000ULL	/* 1MB window */
#define	IOC_W_MASK_2M	0x0000000000100000ULL	/* 2MB window */
#define	IOC_W_MASK_4M	0x0000000000300000ULL	/* 4MB window */
#define	IOC_W_MASK_8M	0x0000000000700000ULL	/* 8MB window */
#define	IOC_W_MASK_16M	0x0000000000f00000ULL	/* 16MB window */
#define	IOC_W_MASK_32M	0x0000000001f00000ULL	/* 32MB window */
#define	IOC_W_MASK_64M	0x0000000003f00000ULL	/* 64MB window */
#define	IOC_W_MASK_128M	0x0000000007f00000ULL	/* 128M window */
#define	IOC_W_MASK_256M	0x000000000ff00000ULL	/* 256M window */
#define	IOC_W_MASK_512M	0x000000001ff00000ULL	/* 512M window */
#define	IOC_W_MASK_1G	0x000000003ff00000ULL	/* 1GB window */
#define	IOC_W_MASK_2G	0x000000007ff00000ULL	/* 2GB window */
#define	IOC_W_MASK_4G	0x00000000fff00000ULL	/* 4GB window */

#define	IOC_W_T_BASE	0x00000000fffffc00ULL	/* page table base */

#endif	/*  ALPHA_LCAREG_H  */
