/* 
 * File: trackinfo.h
 *
 * Copyright (c) 2005 Johannes Heimansberg
 *
 * requires XMMS2 DR2 or better
 *
 * Released under the GNU General Public License v2
 */

#ifndef __TRACKINFO_H__
#define __TRACKINFO_H__
#include <glib.h>
#include <xmmsclient/xmmsclient.h>
#include <xmmsclient/xmmsclient-glib.h>

struct _trackinfo
{
	gchar    artist[512];
	gchar    title[512];
	gchar    album[512];
	gchar    date[128];
	gchar    comment[512];
	gchar    genre[128];
	gchar    channel[256];
	gint32   playtime;
	gchar    url[1024];
	gchar    full_title[1200];
	gint32   bitrate;
	gint32   samplerate;
	gint32   filesize;
	gchar    filetype[256];
	gint     min;
	gint     sec;
	gint32   id;
	gboolean vbr;
	gboolean stream;
	gboolean no_album;
	gboolean no_artist;
	gboolean no_bitrate;
	gboolean no_playtime;
	gboolean no_title;
	gboolean no_samplerate;
	gboolean no_filesize;
};

typedef struct _trackinfo trackinfo;

void      trackinfo_update(xmmsc_result_t *res, trackinfo *track);

gchar    *trackinfo_get_album_str(trackinfo *track);
gchar    *trackinfo_get_artist_str(trackinfo *track);
gchar    *trackinfo_get_bitrate_str_alloc(trackinfo *track);
gchar    *trackinfo_get_channel_str(trackinfo *track);
gchar    *trackinfo_get_comment_str(trackinfo *track);
gchar    *trackinfo_get_date_str(trackinfo *track);
gint32    trackinfo_get_file_size(trackinfo *track);
void      trackinfo_get_full_title(gchar *target, gint target_length,
                                   trackinfo *track, gboolean show_time);
gchar    *trackinfo_get_genre_str(trackinfo *track);
guint     trackinfo_get_id(trackinfo *track);
gchar    *trackinfo_get_mimetype_str(trackinfo *track);
guint     trackinfo_get_minutes(trackinfo *track);
gint32    trackinfo_get_playtime(trackinfo *track);
gchar    *trackinfo_get_playtime_str_alloc(trackinfo *track);
gchar    *trackinfo_get_samplerate_str_alloc(trackinfo *track);
guint     trackinfo_get_seconds(trackinfo *track);
gchar    *trackinfo_get_title_str(trackinfo *track);
gchar    *trackinfo_get_url_str(trackinfo *track);
gboolean  trackinfo_has_album(trackinfo *track);
gboolean  trackinfo_has_artist(trackinfo *track);
gboolean  trackinfo_has_bitrate(trackinfo *track);
gboolean  trackinfo_has_file_size(trackinfo *track);
gboolean  trackinfo_has_playtime(trackinfo *track);
gboolean  trackinfo_has_samplerate(trackinfo *track);
gboolean  trackinfo_has_title(trackinfo *track);
gboolean  trackinfo_is_stream(trackinfo *track);
gboolean  trackinfo_is_vbr(trackinfo *track);

#endif
