module Data.List
  ( elemIndex         -- :: (Eq a) => a -> [a] -> Maybe Int
  , elemIndices       -- :: (Eq a) => a -> [a] -> [Int]

  , find              -- :: (a -> Bool) -> [a] -> Maybe a
  , findIndex         -- :: (a -> Bool) -> [a] -> Maybe Int
  , findIndices       -- :: (a -> Bool) -> [a] -> [Int]
   
  , nub               -- :: (Eq a) => [a] -> [a]
  , nubBy             -- :: (a -> a -> Bool) -> [a] -> [a]

  , delete            -- :: (Eq a) => a -> [a] -> [a]
  , deleteBy          -- :: (a -> a -> Bool) -> a -> [a] -> [a]
  , (\\)              -- :: (Eq a) => [a] -> [a] -> [a]
  , deleteFirstsBy    -- :: (a -> a -> Bool) -> [a] -> [a] -> [a]
   
  , union             -- :: (Eq a) => [a] -> [a] -> [a]
  , unionBy           -- :: (a -> a -> Bool) -> [a] -> [a] -> [a]

  , intersect         -- :: (Eq a) => [a] -> [a] -> [a]
  , intersectBy       -- :: (a -> a -> Bool) -> [a] -> [a] -> [a]

  , intersperse       -- :: a -> [a] -> [a]
  , transpose         -- :: [[a]] -> [[a]]
  , partition         -- :: (a -> Bool) -> [a] -> ([a], [a])

  , group             -- :: Eq a => [a] -> [[a]]
  , groupBy           -- :: (a -> a -> Bool) -> [a] -> [[a]]

  , inits             -- :: [a] -> [[a]]
  , tails             -- :: [a] -> [[a]]

  , isPrefixOf        -- :: (Eq a) => [a] -> [a] -> Bool
  , isSuffixOf        -- :: (Eq a) => [a] -> [a] -> Bool

  , mapAccumL         -- :: (a -> b -> (a,c)) -> a -> [b] -> (a,[c])
  , mapAccumR         -- :: (a -> b -> (a,c)) -> a -> [b] -> (a,[c])

  , sort              -- :: (Ord a) => [a] -> [a]
  , sortBy            -- :: (a -> a -> Ordering) -> [a] -> [a]

  , insert            -- :: (Ord a) => a -> [a] -> [a]
  , insertBy          -- :: (a -> a -> Ordering) -> a -> [a] -> [a]

  , maximumBy         -- :: (a -> a -> Ordering) -> [a] -> a
  , minimumBy         -- :: (a -> a -> Ordering) -> [a] -> a

  , genericLength     -- :: (Integral a) => [b] -> a
  , genericTake       -- :: (Integral a) => a -> [b] -> [b]
  , genericDrop       -- :: (Integral a) => a -> [b] -> [b]
  , genericSplitAt    -- :: (Integral a) => a -> [b] -> ([b], [b])
  , genericIndex      -- :: (Integral a) => [b] -> a -> b
  , genericReplicate  -- :: (Integral a) => a -> b -> [b]

  , unfoldr            -- :: (b -> Maybe (a, b)) -> b -> [a]

  , zip4, zip5, zip6, zip7
  , zipWith4, zipWith5, zipWith6, zipWith7
  , unzip4, unzip5, unzip6, unzip7

  , map               -- :: ( a -> b ) -> [a] -> [b]
  , (++)              -- :: [a] -> [a] -> [a]
  , concat            -- :: [[a]] -> [a]
  , filter            -- :: (a -> Bool) -> [a] -> [a]
  , head              -- :: [a] -> a
  , last              -- :: [a] -> a
  , tail              -- :: [a] -> [a]
  , init              -- :: [a] -> [a]
  , null              -- :: [a] -> Bool
  , length            -- :: [a] -> Int
  , (!!)              -- :: [a] -> Int -> a
  , foldl             -- :: (a -> b -> a) -> a -> [b] -> a
  , foldl'            -- :: (a -> b -> a) -> a -> [b] -> a
  , foldl1            -- :: (a -> a -> a) -> [a] -> a
  , scanl             -- :: (a -> b -> a) -> a -> [b] -> [a]
  , scanl1            -- :: (a -> a -> a) -> [a] -> [a]
  , foldr             -- :: (a -> b -> b) -> b -> [a] -> b
  , foldr1            -- :: (a -> a -> a) -> [a] -> a
  , scanr             -- :: (a -> b -> b) -> b -> [a] -> [b]
  , scanr1            -- :: (a -> a -> a) -> [a] -> [a]
  , iterate           -- :: (a -> a) -> a -> [a]
  , repeat            -- :: a -> [a]
  , replicate         -- :: Int -> a -> [a]
  , cycle             -- :: [a] -> [a]
  , take              -- :: Int -> [a] -> [a]
  , drop              -- :: Int -> [a] -> [a]
  , splitAt           -- :: Int -> [a] -> ([a], [a])
  , takeWhile         -- :: (a -> Bool) -> [a] -> [a]
  , dropWhile         -- :: (a -> Bool) -> [a] -> [a]
  , span              -- :: (a -> Bool) -> [a] -> ([a], [a])
  , break             -- :: (a -> Bool) -> [a] -> ([a], [a])

  , lines             -- :: String   -> [String]
  , words             -- :: String   -> [String]
  , unlines           -- :: [String] -> String
  , unwords           -- :: [String] -> String
  , reverse           -- :: [a] -> [a]
  , and               -- :: [Bool] -> Bool
  , or                -- :: [Bool] -> Bool
  , any               -- :: (a -> Bool) -> [a] -> Bool
  , all               -- :: (a -> Bool) -> [a] -> Bool
  , elem              -- :: a -> [a] -> Bool
  , notElem           -- :: a -> [a] -> Bool
  , lookup            -- :: (Eq a) => a -> [(a,b)] -> Maybe b
  , sum               -- :: (Num a) => [a] -> a
  , product           -- :: (Num a) => [a] -> a
  , maximum           -- :: (Ord a) => [a] -> a
  , minimum           -- :: (Ord a) => [a] -> a
  , concatMap         -- :: (a -> [b]) -> [a] -> [b]
  , zip               -- :: [a] -> [b] -> [(a,b)]
  , zip3  
  , zipWith           -- :: (a -> b -> c) -> [a] -> [b] -> [c]
  , zipWith3
  , unzip             -- :: [(a,b)] -> ([a],[b])
  , unzip3

  ) where

import Prelude
import List

foldl'           :: (a -> b -> a) -> a -> [b] -> a
foldl' f a []     = a
foldl' f a (x:xs) = let a' = f a x in a' `seq` foldl' f a' xs

