/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: hxcleng.h,v 1.13.2.2 2004/07/09 02:05:40 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _HXCLIENTENGINE_
#define _HXCLIENTENGINE_

#include "chxelst.h"
#include "hxmon.h"
#include "hxclreg.h"
#include "statinfo.h"
#include "strminfo.h"
#include "hxshtdn.h"
#include "hxupgrd.h"
#include "hxerror.h"
#if defined(HELIX_FEATURE_LITEPREFS)
#include "chxliteprefs.h"
#endif

#ifdef _UNIX
#include "hxengin.h"
#endif

class	HXCommonClassFactory;
class	HXScheduler;
class   HXOptimizedSchedulerBase;
class	HXPreferences;
class	HXNetworkServices;
class	HXHyperNavigate;
class	HXThreadHyperNavigate;
class	HXClientRegistry;
class	CHXAudioSession;
class	HXCoreGuiHook;
class	Plugin2Handler;
class	HXPluginManager;
class	BaseHandler;
class	HXAutoConfig;
class	CHXPlayerSinkControl;
class	HXCoreComm;
class   HXMutex;
class	HXValidator;
class	HXExternalResourceManager;
class	CHXCredentialsCache;
class	CHXResMgr;
class	HXXMLParser;
class	HXCookies;
class	HXCookiesHelper;
class	HXPreferredTransportManager;
class	HXProxyManager;
class	CMediumBlockAllocator;
class	HXViewSource;
class	CHXMapStringToOb;
class   HXOverlayManager;
class	HXNetInterface;
class	HXPlayer;
class	HXCookies;

struct	IHXClientAdviseSink;
struct	IHXErrorMessages;
struct	IHXCommonClassFactory;
struct	IHXClientEngine;
struct	IHXMimeTypeMapper;
struct	IHXRegistry;
struct	IHXHyperNavigate;
struct  IHXPreferences;
struct  IHXShutDownEverything;
struct	IHXValidator;
struct  IHXSiteEventHandler;
struct	IHXXMLParser;
struct  IHXSystemRequired;
struct  IHXMultiPlayPauseSupport;
struct	IHXProxyAutoConfig;
struct	IHXNetInterfaces;
struct  IHXBandwidthManager;

#if defined(HELIX_FEATURE_SYSTEMREQUIRED)
class HXSystemRequired : public IHXSystemRequired
{
protected:
    LONG32		    m_lRefCount;
public:
    HXSystemRequired() {m_lRefCount = 0;}
    ~HXSystemRequired() {};
    /*
     * IUnknown methods
     */
    STDMETHOD(QueryInterface)	(THIS_
				REFIID riid,
				void** ppvObj);

    STDMETHOD_(ULONG32,AddRef)	(THIS);

    STDMETHOD_(ULONG32,Release)	(THIS);

    /*
     * IHXSystemRequired methods
     */

    /************************************************************************
     *	Method:
     *		IHXSystemRequired::HasFeatures
     *	Purpose:
     *		Check if required features are present on the system.
     *  Returns:
     *		HXR_OK -    features are here, no upgrade required;
     *			    all features are removed from pFeatures.
     *		HXR_FAIL -  some features are missing;
     *			    pFeatures contains only those features 
     *			    that need upgrade.
     *
     */			      
    STDMETHOD(HasFeatures)  (THIS_ 
			    IHXUpgradeCollection* pFeatures);
};
#endif /* HELIX_FEATURE_SYSTEMREQUIRED */

class HXClientEngine : 
			public IHXClientEngine
#if defined _UNIX && !defined _VXWORKS
                      , public IHXClientEngineSelector
                      , public IHXAsyncIOSelection
#endif
		      , public IHXClientEngineSetup
		      , public IHXInterruptState
		      , public IHXShutDownEverything
		      , public IHXOverrideDefaultServices
		      , public IHXErrorMessages
                      , public IHXClientEngineMapper
		      , public IHXCoreMutex
#if defined(_MACINTOSH) && defined(_CARBON) && defined(THREADS_SUPPORTED)
		      , public IHXMacBlitMutex
#endif
{
protected:
    LONG32		    m_lRefCount;
    ULONG32		    m_ulPlayerIndex;

    INT32		    m_unRegistryID;
    HXClientRegistry*	    m_pRegistry;

    HXCommonClassFactory*  m_pCommonClassFactory;
    IHXCommonClassFactory* m_pCommonClassFactoryOverride;
    CMediumBlockAllocator*  m_pAllocator;
    HXScheduler*	    m_pScheduler;
    HXOptimizedSchedulerBase* m_pOptimizedScheduler;
    IHXPreferences*	    m_pPreferences;

#if defined(HELIX_FEATURE_NO_INTERNAL_PREFS)
    IHXPreferences*	    m_pOrigPreferences;
#elif defined(HELIX_FEATURE_LITEPREFS)
    CHXLitePrefs*	    m_pOrigPreferences;
#else
    HXPreferences*	    m_pOrigPreferences;
#endif

    CHXAudioSession*	    m_pAudioSession;
    HXNetworkServices*	    m_pOrigNetworkServices;
    IHXNetworkServices*    m_pNetworkServices;
#ifdef _UNIX
    IHXAsyncIOSelection*   m_pAsyncIOSelection;
    BOOL                    m_bNetworkThreading;
#endif
    HXCookies*		    m_pCookies;
    HXCookiesHelper*	    m_pCookiesHelper;
    HXNetInterface*	    m_pNetInterfaces;

    IHXProxyAutoConfig*    m_pProxyAutoConfig;

    IHXHyperNavigate*	    m_pHyperNavigate;
    HXThreadHyperNavigate* m_pOrigHyperNavigate;
    HXValidator*	    m_pValidator;
    IHXBandwidthManager*    m_pASM;
    CHXPlayerSinkControl*   m_pPlayerSinkControl;
    CHXCredentialsCache*   m_pCredentialsCache;
    CHXResMgr*		    m_pResMgr;
    HXExternalResourceManager*	m_pExternalResourceManager;
    HXXMLParser*	    m_pXMLParser;
    HXViewSource*	    m_pViewSource;
    IHXSystemRequired*	    m_pSystemRequired;

#if defined(_UNIX) || defined(__TCS__)
    IHXSiteEventHandler*   m_pSiteEventHandler;
#endif

    HXProxyManager*	    m_pProxyManager;

    HXPreferredTransportManager*   m_pPreferredTransportManager;
    HXOverlayManager*              m_pOverlayManager;
    IHXMultiPlayPauseSupport*	    m_pMultiPlayPauseSupport;

    //List to store the plugins for information reguarding created players.
    CHXSimpleList*	    m_pSingleLoadPlugins;

public:

#if defined(_STATICALLY_LINKED) || !defined(HELIX_FEATURE_PLUGINHANDLER2)
#if defined(HELIX_CONFIG_CONSOLIDATED_CORE)
    BaseHandler*            m_pPlugin2Handler;
#else /* HELIX_CONFIG_CONSOLIDATED_CORE */
    HXPluginManager*	    m_pPlugin2Handler;
#endif /* HELIX_CONFIG_CONSOLIDATED_CORE */
#else
    Plugin2Handler*	    m_pPlugin2Handler;
#endif /* _STATICALLY_LINKED */

    HXClientEngine(void);
    ~HXClientEngine(void);

    /*
     * IUnknown methods
     */
    STDMETHOD(QueryInterface)	(THIS_
				REFIID riid,
				void** ppvObj);

    STDMETHOD_(ULONG32,AddRef)	(THIS);

    STDMETHOD_(ULONG32,Release)	(THIS);

    /*
     * IHXClientEngine methods
     */

    /************************************************************************
     *	Method:
     *	    IHXClientEngine::CreatePlayer
     *	Purpose:
     *	    Creates a new IHXPlayer instance.
     *
     */
    STDMETHOD(CreatePlayer)	(THIS_
				REF(IHXPlayer*)    pPlayer);

    /************************************************************************
     *	Method:
     *	    IHXClientEngine::ClosePlayer
     *	Purpose:
     *	    Called by the engine when it is done using the player...
     *
     */
    STDMETHOD(ClosePlayer)	(THIS_
				IHXPlayer*    pPlayer);

    /************************************************************************
     *	Method:
     *	    IHXClientEngine::GetPlayerCount
     *	Purpose:
     *	    Returns the current number of IHXPlayer instances supported by
     *	    this client engine instance.
     */
    STDMETHOD_(UINT16, GetPlayerCount)(THIS);

    /************************************************************************
     *	Method:
     *	    IHXClientEngine::GetPlayer
     *	Purpose:
     *	    Returns the Nth IHXPlayer instances supported by this client 
     *	    engine instance.
     */
    STDMETHOD(GetPlayer)	(THIS_
				UINT16		nPlayerNumber,
				REF(IUnknown*)	pUnknown);

    /************************************************************************
     *	Method:
     *	    IHXClientEngine::EventOccurred
     *	Purpose:
     *	    Clients call this to pass OS events to all players. HXxEvent
     *	    defines a cross-platform event.
     */
    STDMETHOD(EventOccurred)	(THIS_
				HXxEvent* /*IN*/ pEvent);

	/*
	 *	IHXMimeTypeMapper methods
	 */

    STDMETHOD(MapFromExtToMime)	(THIS_
				const char*	    /*IN*/  pExtension,
				REF(const char*)    /*OUT*/ pMimeType);
#ifdef _UNIX
    STDMETHOD_(INT32,Select) (THIS_
			      INT32 n,
			      fd_set* readfds,
			      fd_set* writefds,
			      fd_set* exceptfds,
			      struct timeval* timeout);

    STDMETHOD(Add)           (THIS_
			      IHXCallback* pCallback,
			      INT32         lFileDescriptor,
			      UINT32        ulFlags);
    STDMETHOD(Remove)        (THIS_
			      INT32         lFileDescriptor,
			      UINT32        ulFlags);

    CHXSimpleList*            m_select_callbacks;
#endif

    /*
     * IHXClientEngineSetup methods
     */

    /************************************************************************
     *	Method:
     *	    IHXClientEngineSetup::Setup
     *	Purpose:
     *      Top level clients use this interface to over-ride certain basic 
     *	    interfaces are: IHXPreferences, IHXHyperNavigate
     */
    STDMETHOD(Setup)		(THIS_
				IUnknown* pContext);

    /*
     * IHXInterruptState methods
     */
    STDMETHOD_(BOOL,AtInterruptTime)	(THIS);

    STDMETHOD(EnterInterruptState)	(THIS);

    STDMETHOD(LeaveInterruptState)	(THIS);

    STDMETHOD(EnableInterrupt)		(THIS_
					BOOL	bEnable);
    
    STDMETHOD_(BOOL, IsInterruptEnabled) (THIS);

    /*
     * IHXShutDownEverything methods
     */

    /************************************************************************
     *	Method:
     *	    IHXShutDownEverything::ShutDown
     *	Purpose:
     *	    Shutdown all the renderers/fileformats
     *
     */
    STDMETHOD(ShutDown)		(THIS);

    /************************************************************************
     *	Method:
     *	    IHXShutDownEverything::StopAllOtherPlayers
     *	Purpose:
     *	    Stop all the players in other processes if they use audio
     *
     */
    STDMETHOD(StopAllOtherPlayers)	(THIS);

    /************************************************************************
     *	Method:
     *	    IHXShutDownEverything::AskAllOtherPlayersToReload
     *	Purpose:
     *	    Ask all other players in other processes to reload their 
     *	    DLLs.
     *
     */
    STDMETHOD(AskAllOtherPlayersToReload)	(THIS);

    /************************************************************************
     *	Method:
     *	    IHXShutDownEverything::AskAllOtherPlayersToUnload
     *	Purpose:
     *	    Ask all other players in other processes to unload their 
     *	    unused DLLs.
     *
     */

    STDMETHOD(AskAllOtherPlayersToUnload)	(THIS);

    /*
     * IHXOverrideDefaultServices methods
     */

    /************************************************************************
     *  Method:
     *      IHXOverrideDefaultServices::OverrideServices
     *  Purpose:
     *      Override default services provided by the G2 system.
     * 
     */
    STDMETHOD(OverrideServices)         (THIS_
				IUnknown* pContext);
    /*
     *  IHXErrorMessages methods
     */

    /************************************************************************
     *	Method:
     *	    IHXErrorMessages::Report
     *	Purpose:
     *	    Call this method to report an error, event, or status message.
     *	Parameters:
     *
     *	    const UINT8	unSeverity
     *	    Type of report. This value will impact how the player, tool, or
     *	    server will react to the report. Possible values are described 
     *	    above. Depending on the error type, an error message with the 
     *	    RMA code, anda string translation of that code will be displayed. 
     *	    The error dialog includes a "more info" section that displays the
     *	    user code and string, and a link to the more info URL. In the 
     *	    server these messages are logged to the log file.
     *
     *	    const ULONG32   ulHXCode
     *	    Well known RMA error code. This will be translated to a text
     *	    representation for display in an error dialog box or log file.
     *
     *	    const ULONG32   ulUserCode
     *	    User specific error code. This will NOT be translated to a text
     *	    representation. This can be any value the caller wants, it will
     *	    be logged or displayed but not interpretted.
     *
     *	    const char*	    pUserString
     *	    User specific error string. This will NOT be translated or 
     *	    modified. This can be any value the caller wants, it will
     *	    be logged or displayed but not interpretted.
     *
     *	    const char*	    pMoreInfoURL
     *	    User specific more info URL string.
     *
     */
    STDMETHOD(Report)		(THIS_
				const UINT8	unSeverity,  
				HX_RESULT	ulHXCode,
				const ULONG32	ulUserCode,
				const char*	pUserString,
				const char*	pMoreInfoURL);

    /************************************************************************
     *	Method:
     *	    IHXErrorMessages::GetErrorText
     *	Purpose:
     *	    Call this method to get the text description of a RMA error code.
     *	Parameters:
     *	    HX_RESULT ulHXCode (A RMA error code)
     *  Return Value:
     *	    IHXBuffer* containing error text.
     */
    STDMETHOD_(IHXBuffer*, GetErrorText)	(THIS_
						HX_RESULT	ulHXCode);

    /************************************************************************
     *	Method:
     *	    IHXClientEngineMapper::GetPlayerBySite
     *	Purpose:
     *	    Returns the IHXPlayer instance supported by this client 
     *	    engine instance that contains the specified IHXSite.
     */
    STDMETHOD(GetPlayerBySite)	(THIS_
				IHXSite*	pSite,
				REF(IUnknown*)	pUnknown);

    /************************************************************************
     *	Method:
     *	    IHXCoreMutex::LockCoreMutex
     *	Purpose:
     *      Call this method to lock the client engine's core mutex.
     */
    STDMETHOD(LockCoreMutex)    (THIS);

    /************************************************************************
     *	Method:
     *	    IHXCoreMutex::UnlockCoreMutex
     *	Purpose:
     *      Call this method to unlock the client engine's core mutex.
     */
    STDMETHOD(UnlockCoreMutex)    (THIS);

#if defined(_MACINTOSH) && defined(_CARBON) && defined(THREADS_SUPPORTED)

    /************************************************************************
     *	Method:
     *	    IHXMacBlitMutex::LockMacBlitMutex
     *	Purpose:
     *      Call this method to lock the Mac blitting mutex
     */
    STDMETHOD(LockMacBlitMutex)    (THIS);

    /************************************************************************
     *	Method:
     *	    IHXMacBlitMutex::UnlockMacBlitMutex
     *	Purpose:
     *      Call this method to unlock the Mac blitting mutex
     */
    STDMETHOD(UnlockMacBlitMutex)    (THIS);

#endif

    STDMETHOD(StopAudioPlayback)	(THIS);

    virtual void Close();

    HXMutex*	GetCoreMutex()	{return m_pCoreMutex;};

    CHXResMgr*	GetResMgr() {return m_pResMgr;};

    void	NotifyPlayState(BOOL bInPlayingState);

    HXCookies*	GetCookies() {return m_pCookies;};

    UINT32	m_lROBActive;

protected:
    void			_Initialize();
    virtual CHXAudioSession*	NewAudioSession();
    virtual HXPlayer*		NewPlayer();
    virtual HXCookies*		NewCookies();
    void			CreatePrefIfNoExist(const char* pName, const char* pValue);
    void			CreatePluginDir();
    void			CreateCodecDir();
    void			InitializeThreadedObjects();
    void			InitializeRegistry();
    IHXBuffer*			CreateBufferAndSetToString(const char* pStr);
    void			InitPaths();

    CHXSimpleList		m_PlayerList;
    HX_RESULT			m_LastError;
    HX_BITFIELD			m_bIsSchedulerStarted : 1;
    HX_BITFIELD			m_bInitialized : 1;
    BOOL			m_bUseCoreThread;
    HX_BITFIELD			m_bUseCoreThreadExternallySet : 1;
    HXCoreComm*			m_pCoreComm;
    HXMutex*			m_pCoreMutex;
#if defined(_MACINTOSH) && defined(_CARBON) && defined(THREADS_SUPPORTED)
    BOOL			m_bUseMacBlitMutex;
    HXMutex*			m_pMacBlitMutex;
#endif
    const char*			m_AUName;
};

#endif // HXClientEngine

