/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: makebomb.h,v 1.1.26.1 2004/07/09 01:54:36 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef MAKEBOMB_H
#define MAKEBOMB_H

// Forward class declarations
class PXImage;

class PXMakeBombImage
{
public:
    PXMakeBombImage();
    virtual ~PXMakeBombImage() {};

    HX_RESULT MakeBombImage(IUnknown* pContext, UINT32 ulW, UINT32 ulH,
                            UINT32 ulBackColor, REF(PXImage*) rpBombImage);
private:
    struct PXBitmapFileHeader
    {
        UINT16 bfType;
        UINT32 bfSize;
        UINT16 bfReserved1;
        UINT16 bfReserved2;
        UINT32 bfOffBits;
    };

    struct PXBitmapInfoHeader
    {
        UINT32 biSize;
        INT32  biWidth;
        INT32  biHeight;
        UINT16 biPlanes;
        UINT16 biBitCount;
        UINT32 biCompression;
        UINT32 biSizeImage;
        INT32  biXPelsPerMeter;
        INT32  biYPelsPerMeter;
        UINT32 biClrUsed;
        UINT32 biClrImportant;
    };

    struct PXRGBQuad
    {
        BYTE    rgbBlue;
        BYTE    rgbGreen;
        BYTE    rgbRed;
        BYTE    rgbReserved;
    };

    PXBitmapInfoHeader  m_cInfo;
    PXRGBQuad*          m_pColorMap;
    BYTE*               m_pBits;
    UINT32              m_ulRowBytes;
    static const UINT32 m_ulOriginalSize;
    static const BYTE   m_pImageBuffer[];
    static const UINT32 m_ulImageBufferLength;
    static const BOOL   m_bRowsInverted;

    UINT32 GetPixel(INT32 lX, INT32 lY);
};

#endif
