/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: pxff2.h,v 1.1.26.1 2004/07/09 01:51:59 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef PXFF_H
#define PXFF_H

// Forward declarations
typedef _INTERFACE IHXRequest                IHXRequest;
typedef _INTERFACE IHXFormatResponse         IHXFormatResponse;
typedef _INTERFACE IHXFileObject             IHXFileObject;
typedef _INTERFACE IHXBuffer                 IHXBuffer;
typedef _INTERFACE IHXPacket                 IHXPacket;
typedef _INTERFACE IHXCommonClassFactory     IHXCommonClassFactory;
typedef _INTERFACE IHXErrorMessages          IHXErrorMessages;
typedef _INTERFACE IHXFileStat               IHXFileStat;
typedef _INTERFACE IHXPoolPathAdjustment     IHXPoolPathAdjustment;
typedef _INTERFACE IHXRealPixFileFormatCodec IHXRealPixFileFormatCodec;
class PXFileFormatCodecManager;
class PXWireFormatManager;
class PXFileHandler;
class PXFileHandler;
class CHXPtrArray;
class PXScheduler;
class PXRealPixFile;


class CRealPixFileFormat : public CHXBaseCountingObject,
                           public IHXPlugin,
                           public IHXFileFormatObject,
                           public IHXInterruptSafe,
                           public IHXThreadSafeMethods
{
public:
    CRealPixFileFormat();
    virtual ~CRealPixFileFormat();

    // IUnknown methods
    STDMETHOD(QueryInterface)  (THIS_ REFIID riid, void** ppvObj);
    STDMETHOD_(UINT32,AddRef)  (THIS);
    STDMETHOD_(UINT32,Release) (THIS);

     // IHXPlugin methods
    STDMETHOD(GetPluginInfo) (THIS_ REF(BOOL)        bMultipleLoad,
                                    REF(const char*) pDescription,
                                    REF(const char*) pCopyright,
                                    REF(const char*) pMoreInfoURL,
                                    REF(ULONG32)     ulVersionNumber);
    STDMETHOD(InitPlugin)    (THIS_ IUnknown*        pContext);

    // IHXFileFormatObject methods
    STDMETHOD(GetFileFormatInfo) (THIS_ REF(const char**)   pFileMimeTypes,
                                        REF(const char**)   pFileExtensions,
                                        REF(const char**)   pFileOpenNames);
    STDMETHOD(InitFileFormat)    (THIS_ IHXRequest*        pRequest,
                                        IHXFormatResponse* pFormatResponse,
                                        IHXFileObject*     pFileObject);
    STDMETHOD(Close)             (THIS);
    STDMETHOD(GetFileHeader)     (THIS);
    STDMETHOD(GetStreamHeader)   (THIS_ UINT16              usStreamNumber);
    STDMETHOD(GetPacket)         (THIS_ UINT16              usStreamNumber);
    STDMETHOD(Seek)              (THIS_ UINT32              ulRequestedTime);

    // IHXInterruptSafe methods
    STDMETHOD_(BOOL,IsInterruptSafe) (THIS);

    // PXFileHandler response methods
    STDMETHOD(ReadRPFileDone)    (THIS_ HX_RESULT status, IHXBuffer* pBuffer);
    STDMETHOD(StatImageFileDone) (THIS_ HX_RESULT status, UINT32 ulInstance,
                                        UINT32 ulSize, IHXBuffer* pMimeTypeStr);
    STDMETHOD(ReadImageFileDone) (THIS_ HX_RESULT status, UINT32 ulInstance, IHXBuffer* pBuffer);
    STDMETHOD(ShutdownDone)      (THIS_ HX_RESULT status, UINT32 ulInstance);

    // IHXThreadSafeMethods methods
    STDMETHOD_(UINT32,IsThreadSafe)(THIS);

    // CRealPixFileFormat methods
    static HX_RESULT STDAPICALLTYPE HXCreateInstance(IUnknown** ppIUnknown);
protected:
    enum
    {
        kStateConstructed,
        kStateError,
        kStatePluginInitialized,
        kStateReadingRPFile,
        kStateImageStat,
        kStateFileFormatInitialized,
        kStateGetFileHeaderShutdown,
        kStateFileHeaderSent,
        kStateAwaitingGetPacket,
        kStateReadingImageFile,
        kStateStreamDone,
        kStateShutdown,
        kStateClosed
    };

    INT32                       m_lRefCount;
    IUnknown*                   m_pContext;
    IHXCommonClassFactory*      m_pCommonClassFactory;
    IHXRequest*                 m_pRequest;
    IHXFormatResponse*          m_pFileFormatResponse;
    IHXFileObject*              m_pRPFileObject;
    IHXPoolPathAdjustment*	m_pPoolPathAdjustment;
    PXFileFormatCodecManager*   m_pCodecManager;
    PXWireFormatManager*        m_pWireFormatManager;
    PXFileHandler*              m_pRPFileHandler;
    PXFileHandler*              m_pImageFileHandler;
    CHXPtrArray*                m_pFileHandlerArray;
    PXScheduler*                m_pPacketScheduler;
    PXRealPixFile*              m_pRealPixFile;
    IHXRealPixFileFormatCodec*  m_pCodec;
    UINT32                      m_ulSessionHandle;
    BOOL                        m_bImageParseActive;
    UINT32                      m_ulState;
    BOOL                        m_bRealPixLicensed;
    UINT32                      m_ulStrictnessLevel;
    BOOL                        m_bShutdownRPFile;
    IHXBuffer*                  m_pAcceptMetaInfoStr;

    static const IID            m_IID;
    static const char*          m_pszDescription;
    static const char*          m_pszCopyright;
    static const char*          m_pszMoreInfoURL;
    static const char*          m_ppszFileMimeTypes[];
    static const char*          m_ppszFileExtensions[];
    static const char*          m_ppszFileOpenNames[];
    static const char*          m_ppszStreamMimeTypes[];
    static const UINT32         m_ulStreamVersion;

    void                        Deallocate();
    HX_RESULT                   InitFromRPFile();
    void                        ShutdownAllFileHandlers(BOOL bShutdownRPFile);
    void                        ReleaseAllFileHandlers();
    HX_RESULT                   CreateImageFile(const char* pszImageName, IHXFileObject* pFileObject);
    void                        ReportError(UINT32 ulErrorID, const char* pszArg1, const char* pszArg2,
                                            const UINT8 ucSeverity, HX_RESULT ulHXCode);
    void                        ReportError(const UINT8 ucSeverity, HX_RESULT ulHXCode, IHXBuffer* pErrorStr);
    HX_RESULT                   GetRegistrySettings(REF(BOOL)   rbLicensed,
                                                    REF(UINT32) rulStrictnessLevel);
    HX_RESULT                   CheckForCodecs(REF(IHXBuffer*) rpImageNameStr);
    HX_RESULT                   AddCodecsToWireFormatManager();
    HX_RESULT                   ParseRealPixFile(IHXBuffer*    pBuffer,
                                                 PXRealPixFile* pRealPixFile,
                                                 UINT32         ulStrictnessLevel);
    void                        SendFailPacket(HX_RESULT retVal);
    HX_RESULT			AllowPoolPathAdjustment(REF(IHXBuffer*) pNameStr);
};

#endif
