/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: brushff.h,v 1.3.2.1 2004/07/09 01:57:42 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */


#ifndef BRUSHFF_H
#define BRUSHFF_H

// Forward declarations
typedef _INTERFACE IHXRequest            IHXRequest;
typedef _INTERFACE IHXFormatResponse     IHXFormatResponse;
typedef _INTERFACE IHXFileObject         IHXFileObject;
typedef _INTERFACE IHXBuffer             IHXBuffer;
typedef _INTERFACE IHXCommonClassFactory IHXCommonClassFactory;


class CBrushFileFormat : public CHXBaseCountingObject,
                         public IHXPlugin,
                         public IHXFileFormatObject,
                         public IHXFileResponse
{
public:
    CBrushFileFormat();
    virtual ~CBrushFileFormat();

    // IUnknown methods
    STDMETHOD(QueryInterface)  (THIS_ REFIID riid, void** ppvObj);
    STDMETHOD_(UINT32,AddRef)  (THIS);
    STDMETHOD_(UINT32,Release) (THIS);

    // IHXPlugin methods
    STDMETHOD(GetPluginInfo) (THIS_ REF(BOOL)        rbLoadMultiple,
                                    REF(const char*) rpszDescription,
                                    REF(const char*) rpszCopyright,
                                    REF(const char*) rpszMoreInfoURL,
                                    REF(UINT32)      rulVersionNumber);
    STDMETHOD(InitPlugin)    (THIS_ IUnknown*        pContext);

    // IHXFileFormatObject methods
    STDMETHOD(GetFileFormatInfo) (THIS_ REF(const char**)  rppszFileMimeTypes,
                                        REF(const char**)  rppszFileExtensions,
                                        REF(const char**)  rppszFileOpenNames);
    STDMETHOD(InitFileFormat)    (THIS_ IHXRequest*        pRequest,
                                        IHXFormatResponse* pFormatResponse,
                                        IHXFileObject*     pFileObject);
    STDMETHOD(GetFileHeader)   (THIS);
    STDMETHOD(GetStreamHeader) (THIS_ UINT16 usStreamNum);
    STDMETHOD(GetPacket)       (THIS_ UINT16 usStreamNum);
    STDMETHOD(Seek)            (THIS_ UINT32 ulRequestedTime);
    STDMETHOD(Close)           (THIS);

    // IHXFileResponse methods
    STDMETHOD(InitDone)  (THIS_ HX_RESULT status);
    STDMETHOD(SeekDone)  (THIS_ HX_RESULT status);
    STDMETHOD(ReadDone)  (THIS_ HX_RESULT status, IHXBuffer *pBuffer);
    STDMETHOD(WriteDone) (THIS_ HX_RESULT status);
    STDMETHOD(CloseDone) (THIS_ HX_RESULT status);

    // CBrushFileFormat methods
    static HX_RESULT STDAPICALLTYPE HXCreateInstance(IUnknown** ppIUnknown);
    static HX_RESULT STDAPICALLTYPE CanUnload2(void);
protected:
    enum
    {
        kStateConstructed,
        kStateError,
        kStatePluginInitialized,
        kStateFileInitPending,
        kStateFileReadPending,
        kStateFileFormatInitialized,
        kStateFileHeaderSent,
        kStateReadyForGetPacket,
        kStateFileSeekPending,
        kStateFileClosePending,
        kStateStreamDoneSent,
        kDefaultPacketSize      = 480,
        kDefaultBitrate         = 500,
        kDefaultDuration        = 5000,
        kDefaultPreroll         = 1000
    };

    INT32                    m_lRefCount;
    IUnknown*                m_pContext;
    IHXFileObject*           m_pFileObject;
    IHXFormatResponse*       m_pFormatResponse;
    IHXCommonClassFactory*   m_pCommonClassFactory;
    IHXBuffer*               m_pFileBuffer;
    UINT32                   m_ulState;
    BOOL                     m_bNullBrush;

    static const char* const m_pszDescription;
    static const char* const m_pszCopyright;
    static const char* const m_pszMoreInfoURL;
    static const char* const m_ppszFileMimeTypes[];
    static const char* const m_ppszFileExtensions[];
    static const char* const m_ppszFileOpenNames[];
    static const char* const m_pszStreamMimeType;
    static const UINT32      m_ulContentVersion;
    static const UINT32      m_ulStreamVersion;

    void                    Deallocate();
    void                    Reset();
    BOOL                    IsNullBrush(IHXRequest* pRequest);
};

#endif
