/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: evnthook.h,v 1.1.22.1 2004/07/09 01:58:01 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef EVNTHOOK_H
#define EVNTHOOK_H

// Forward declarations
typedef _INTERFACE IHXSite IHXSite;
class CSmilDocumentRenderer;
class CHXString;
class CHXMapPtrToPtr;

class CSmilEventHookResponse
{
public:
    // IUnknown methods
    STDMETHOD(QueryInterface)    (THIS_ REFIID riid, void** ppvObj) PURE;
    STDMETHOD_(ULONG32, AddRef)  (THIS) PURE;
    STDMETHOD_(ULONG32, Release) (THIS) PURE;

    // CSmilEventHookResponse methods
    STDMETHOD(HandleMouseMove)        (THIS_ void*       pWindow,
                                             const char* pRegionID,
                                             const char* pMediaID,
                                             UINT16      uXPos,
                                             UINT16      uYPos,
					     UINT32      kRMAEvent,
					     REF(BOOL)   bHandleSetCursor) PURE;
    STDMETHOD(HandleLButtonUp)        (THIS_ const char* pRegionID,
                                             const char* pMediaID,
                                             UINT16 uXPos, UINT16 uYPos,
                                             REF(BOOL) rbHandled) PURE;
    STDMETHOD(HandleGotFocus)         (THIS_ const char* pRegionID,
                                             const char* pMediaID) PURE;
    STDMETHOD(HandleLostFocus)        (THIS_ const char* pRegionID,
                                             const char* pMediaID) PURE;
    STDMETHOD(HandleCharEvent)        (THIS_ UINT16 uChar) PURE;
    STDMETHOD_(BOOL, HandleSetCursor) (THIS) PURE;
    STDMETHOD(AddShowEvents)          (THIS_ const char* pRegionName, IHXSite* pSite) PURE;
};

class CSmilEventHook: public IHXEventHook
{
public:
    CSmilEventHook(CSmilEventHookResponse* pResponse,
                   const char*             pRegionName,
                   const char*             pChannelName,
                   BOOL                    bNoRegion,
                   const char*             pszMediaID);
    virtual ~CSmilEventHook();

    // IUnknown methods
    STDMETHOD(QueryInterface)    (THIS_ REFIID riid, void** ppvObj);
    STDMETHOD_(ULONG32, AddRef)  (THIS);
    STDMETHOD_(ULONG32, Release) (THIS);

    // IHXEventHook methods
    STDMETHOD(HandleEvent) (IHXSite* pSite, HXxEvent* pEvent);
    STDMETHOD(SiteAdded)   (IHXSite* pSite);
    STDMETHOD(SiteRemoved) (IHXSite* pSite);

    // CSmilEventHook methods
    const char* GetRegionName() const;
    const char* GetChannelName() const;
    const char* GetMediaID() const;
private:
    INT32                   m_lRefCount;
    CSmilEventHookResponse* m_pResponse;
    CHXString*              m_pRegionName;
    CHXString*              m_pChannelName;
    CHXMapPtrToPtr*         m_pSiteMap;
    CHXString*              m_pMediaID;
    // ONLY HX_BITFIELD MEMBERS SHOULD GO BELOW THIS LINE!
    // ALL OTHER MEMBER TYPES SHOULD GO ABOVE THIS LINE!
    HX_BITFIELD             m_bNoRegion : 1;
};

#endif
