/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: layout.h,v 1.2.16.1 2004/07/09 01:58:01 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef LAYOUT_H
#define LAYOUT_H

// Forward declarations
typedef _INTERFACE IHXSite     IHXSite;
typedef _INTERFACE IHXSiteUser IHXSiteUser;
class CHXSimpleList;
class CSmilRegion;
class CHXString;
class CSmilRootLayout;
#if defined(HELIX_FEATURE_SMIL2_MULTIWINDOWLAYOUT)
class CSmilViewport;
#endif /* #if defined(HELIX_FEATURE_SMIL2_MULTIWINDOWLAYOUT) */
class CSmilPassiveSiteWatcher;
class CSmilSiteUser;

typedef enum
{
    BoxDimensionWidth,
    BoxDimensionHeight
}
BoxDimension;

class CSmilBasicBox
{
public:
    CSmilBasicBox();
    virtual ~CSmilBasicBox();

    virtual HX_RESULT computeDimension(BoxDimension eDim) = 0;
    virtual HX_RESULT resolveFromChildren(BoxDimension eDim) = 0;

    CSmilBasicBox*           m_pParent;
    CHXSimpleList*           m_pChildList;
    HXxRect                  m_Rect;
    HXxRect                  m_RectNoZoom;
    IHXSite*                m_pSite;
    CSmilPassiveSiteWatcher* m_pPassiveSiteWatcher;
    CSmilSiteUser*           m_pSiteUser;
    ResizeBehavior           m_eResizeBehavior;
    double                   m_dZoomScaleFactorX;
    double                   m_dZoomScaleFactorY;
    CHXSimpleList*           m_pChildRendererSiteList;
    // ONLY HX_BITFIELD MEMBERS SHOULD GO BELOW THIS LINE!
    // ALL OTHER MEMBER TYPES SHOULD GO ABOVE THIS LINE!
    HX_BITFIELD              m_bWidthResolved : 1;
    HX_BITFIELD              m_bDefaultWidthAssigned : 1;
    HX_BITFIELD              m_bHeightResolved : 1;
    HX_BITFIELD              m_bDefaultHeightAssigned : 1;
    HX_BITFIELD              m_bSiteChangingSize : 1;
    HX_BITFIELD              m_bNested : 1;

    HX_RESULT addChild(CSmilBasicBox* pBox);
    HX_RESULT addRendererSiteChild(IHXSite* pSite);
    HX_RESULT removeRendererSiteChild(IHXSite* pSite);
    
    BOOL      isResolved(BoxDimension eDim);
    HX_RESULT computeChildrenMax(BoxDimension eDim,
                                 BOOL         bAllMustBeValid,
                                 REF(INT32)   rlMax);
};

class CSmilBasicRegion : public CSmilBasicBox
{
public:
    CSmilBasicRegion(CSmilRegion* pSmilRegion);
    virtual ~CSmilBasicRegion();

    virtual HX_RESULT computeDimension(BoxDimension eDim);
    virtual HX_RESULT resolveFromChildren(BoxDimension eDim);
    static  HX_RESULT resolveDimension(double dLeft,  CSS2Type eLeftType,
                                       double dRight, CSS2Type eRightType,
                                       double dWidth, CSS2Type eWidthType,
                                       BOOL bHaveParentWidth, double dParentWidth,
                                       REF(INT32) rlRectMin,
                                       REF(INT32) rlRectMax);

    CSmilRegion*   m_pSmilRegion;
    HXxRect        m_rect;
    HXxRect        m_originalRect;
    HXxSize        m_mediaSize;
    HXxSize        m_originalMediaSize;
    LayoutRect     m_LayoutRect;
    INT32          m_lZIndex;
    Fit            m_eFit;
    CHXString      m_region;
    UINT32         m_ulBackgroundColor;
    CSS2Type       m_eBackgroundColorType;
    double         m_dSoundLevel;
    ShowBackground m_eShowBackground;
    // ONLY HX_BITFIELD MEMBERS SHOULD GO BELOW THIS LINE!
    // ALL OTHER MEMBER TYPES SHOULD GO ABOVE THIS LINE!
    HX_BITFIELD    m_bMediaSizeSet : 1;
    HX_BITFIELD    m_bImplicitRegion : 1;
    HX_BITFIELD    m_bWidthUnspecified : 1;
    HX_BITFIELD    m_bHeightUnspecified : 1;
    HX_BITFIELD    m_bUnderRootLayout : 1;
};

class CSmilBasicRootLayout : public CSmilBasicBox
{
public:
    CSmilBasicRootLayout();
    virtual ~CSmilBasicRootLayout();

    virtual HX_RESULT computeDimension(BoxDimension eDim);
    virtual HX_RESULT resolveFromChildren(BoxDimension eDim);

    void           SetParserRootLayout(CSmilRootLayout* pRoot);
    BOOL           IsRootLayoutElementPresent() const;
    BOOL           IsWidthSet() const;
    BOOL           IsHeightSet() const;
    UINT32         GetWidth() const;
    UINT32         GetHeight() const;
    UINT32         GetBackgroundColor() const;

    CSmilRootLayout* m_pRoot;
    HXxSize          m_OriginalSize;
    // ONLY HX_BITFIELD MEMBERS SHOULD GO BELOW THIS LINE!
    // ALL OTHER MEMBER TYPES SHOULD GO ABOVE THIS LINE!
    HX_BITFIELD      m_bOriginalWidthSet : 1;
    HX_BITFIELD      m_bOriginalHeightSet : 1;
};

inline BOOL CSmilBasicRootLayout::IsRootLayoutElementPresent() const
{
    return (m_pRoot ? TRUE : FALSE);
}

#if defined(HELIX_FEATURE_SMIL2_MULTIWINDOWLAYOUT)

class CSmilBasicViewport : public CSmilBasicBox
{
public:
    CSmilBasicViewport(CSmilViewport* pPort);
    virtual ~CSmilBasicViewport();

    virtual HX_RESULT computeDimension(BoxDimension eDim);
    virtual HX_RESULT resolveFromChildren(BoxDimension eDim);

    CSmilViewport* m_pPort;
    UINT32         m_ulNumActiveMedia;
    CHXString      m_id;
    HXxSize        m_OriginalSize;
    // ONLY HX_BITFIELD MEMBERS SHOULD GO BELOW THIS LINE!
    // ALL OTHER MEMBER TYPES SHOULD GO ABOVE THIS LINE!
    HX_BITFIELD    m_bOpen : 1;
    HX_BITFIELD    m_bOriginalWidthSet : 1;
    HX_BITFIELD    m_bOriginalHeightSet : 1;
    HX_BITFIELD    m_bViewportIsSetup : 1;
};

#endif /* #if defined(HELIX_FEATURE_SMIL2_MULTIWINDOWLAYOUT) */

#endif
