/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: siteuser.h,v 1.1.22.1 2004/07/09 01:58:01 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef SITEUSER_H
#define SITEUSER_H

// Forward declarations
typedef _INTERFACE IHXSite          IHXSite;
typedef _INTERFACE IHXValues        IHXValues;
typedef _INTERFACE IHXBuffer        IHXBuffer;
typedef _INTERFACE IHXErrorMessages IHXErrorMessages;
typedef struct _HXBitmapInfoHeader  HXBitmapInfoHeader;
class CSmilSiteUser;

class CSmilSiteUserResponse
{
public:
    // IUnknown methods
    STDMETHOD(QueryInterface)    (THIS_ REFIID riid, void** ppvObj) PURE;
    STDMETHOD_(ULONG32, AddRef)  (THIS) PURE;
    STDMETHOD_(ULONG32, Release) (THIS) PURE;

    // CSmilSiteUserResponse methods
    STDMETHOD(SiteUserAttachSite)  (THIS_ CSmilSiteUser* pUser, IHXSite* pSite) PURE;
    STDMETHOD(SiteUserDetachSite)  (THIS_ CSmilSiteUser* pUser) PURE;
    STDMETHOD(SiteUserHandleEvent) (THIS_ CSmilSiteUser* pUser, HXxEvent* pEvent) PURE;
};

class CSmilSiteUser : public IHXSiteUser,
                      public IHXValues
{
public:
    CSmilSiteUser(CSmilSiteUserResponse* pResponse,
                  UINT32                 ulBackgroundColor,
                  IUnknown*              pContext,
                  BOOL                   bIsARoot,
                  const char*            pszID);
    virtual ~CSmilSiteUser();

    // IUnknown methods
    STDMETHOD(QueryInterface)    (THIS_ REFIID riid, void** ppvObj);
    STDMETHOD_(ULONG32, AddRef)  (THIS);
    STDMETHOD_(ULONG32, Release) (THIS);

    // IHXSiteUser methods
    STDMETHOD(AttachSite)               (THIS_ IHXSite* pSite);
    STDMETHOD(DetachSite)               (THIS);
    STDMETHOD(HandleEvent)              (THIS_ HXxEvent* pEvent);
    STDMETHOD_(BOOL,NeedsWindowedSites) (THIS);

    // IHXValues methods
    STDMETHOD(SetPropertyULONG32)      (THIS_ const char* pName, ULONG32 ulVal);
    STDMETHOD(GetPropertyULONG32)      (THIS_ const char* pName, REF(ULONG32) rulVal);
    STDMETHOD(GetFirstPropertyULONG32) (THIS_ REF(const char*) rpName, REF(ULONG32) rulVal);
    STDMETHOD(GetNextPropertyULONG32)  (THIS_ REF(const char*) rpName, REF(ULONG32) rulVal);
    STDMETHOD(SetPropertyBuffer)       (THIS_ const char* pName, IHXBuffer* pVal);
    STDMETHOD(GetPropertyBuffer)       (THIS_ const char* pName, REF(IHXBuffer*) rpVal);
    STDMETHOD(GetFirstPropertyBuffer)  (THIS_ REF(const char*) rpName, REF(IHXBuffer*) rpVal);
    STDMETHOD(GetNextPropertyBuffer)   (THIS_ REF(const char*) rpName, REF(IHXBuffer*) rpVal);
    STDMETHOD(SetPropertyCString)      (THIS_ const char* pName, IHXBuffer* pVal);
    STDMETHOD(GetPropertyCString)      (THIS_ const char* pName, REF(IHXBuffer*) rpVal);
    STDMETHOD(GetFirstPropertyCString) (THIS_ REF(const char*) rpName, REF(IHXBuffer*) rpVal);
    STDMETHOD(GetNextPropertyCString)  (THIS_ REF(const char*) rpName, REF(IHXBuffer*) rpVal);

    // CSmilSiteUser methods
    STDMETHOD(SetBackgroundColor)                  (THIS_ UINT32 ulBackgroundColor);
    STDMETHOD_(UINT32,GetBackgroundColor)          (THIS);
    STDMETHOD(Close)                               (THIS);
    STDMETHOD_(UINT32,GetLastMediaEndOverrideTime) (THIS);
    STDMETHOD(SetLastMediaEndOverrideTime)         (THIS_ UINT32 ulTime);
    STDMETHOD(Redraw)                              (THIS);
private:
    INT32                  m_lRefCount;
    CSmilSiteUserResponse* m_pResponse;
    UINT32                 m_ulBackgroundColor;
    IHXSite*              m_pSite;
    IHXValues*            m_pValues;
    char*                  m_pszID;
    UINT32                 m_ulLastMediaEndOverrideTime;
    IHXErrorMessages*     m_pErrorMessages;
    HXBitmapInfoHeader*   m_pBitmapInfoHeader;
    BYTE*                  m_pucBuffer;
    UINT32                 m_ulLastBackgroundColor;
    // ONLY HX_BITFIELD MEMBERS SHOULD GO BELOW THIS LINE!
    // ALL OTHER MEMBER TYPES SHOULD GO ABOVE THIS LINE!
    HX_BITFIELD            m_bIsARoot : 1;

    HX_RESULT SetupBuffer();
};

#endif
