/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: smcallbk.cpp,v 1.2.12.1 2004/07/09 01:58:01 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

// system
// include
#include "hxtypes.h"
#include "hxwintyp.h"
#include "hxcom.h"
#include "hxengin.h"
#include "smiltype.h"
#include "hxvport.h"
#include "hxcore.h"
#include "hxclsnk.h"
#include "hxgroup.h"
#include "hxmmrkr.h"
#include "ihxpckts.h"
#include "hxsite2.h"
#include "hxerror.h"
// pncont
#include "hxstring.h"
#include "hxslist.h"
// rmasmil
#include "smlelem.h"
// smlrendr
#include "evnthook.h"
#include "siteuser.h"
#include "passivsw.h"
#include "layout.h"
#include "smcallbk.h"
#include "hxinter.h" // smldoc.h dependency
#include "smldoc.h"
// pndebug
#include "hxheap.h"
#ifdef _DEBUG
#undef HX_THIS_FILE		
static const char HX_THIS_FILE[] = __FILE__;
#endif


HandlePendingSchedulingCallback::HandlePendingSchedulingCallback()
{
    m_lRefCount             = 0;
    m_pSmilDocumentRenderer = NULL;
    m_PendingHandle         = 0;
    m_bIsCallbackPending    = FALSE;
}

HandlePendingSchedulingCallback::~HandlePendingSchedulingCallback()
{
}

STDMETHODIMP HandlePendingSchedulingCallback::QueryInterface(REFIID riid, void** ppvObj)
{
    HX_RESULT retVal = HXR_OK;

    if (ppvObj)
    {
        if (IsEqualIID(riid, IID_IUnknown))
        {
            AddRef();
            *ppvObj = this;
        }
        else if (IsEqualIID(riid, IID_IHXCallback))
        {
	    AddRef();
	    *ppvObj = (IHXCallback*)this;
        }
        else
        {
            *ppvObj = NULL;
            retVal  = HXR_NOINTERFACE;
        }
    }
    else
    {
        retVal = HXR_FAIL;
    }

    return retVal;
}

STDMETHODIMP_(ULONG32) HandlePendingSchedulingCallback::AddRef()
{
    return InterlockedIncrement(&m_lRefCount);
}

STDMETHODIMP_(ULONG32) HandlePendingSchedulingCallback::Release()
{
    if (InterlockedDecrement(&m_lRefCount) > 0)
    {
	return m_lRefCount;
    }

    delete this;
    return 0;
}


STDMETHODIMP HandlePendingSchedulingCallback::Func(void)
{
    HX_RESULT retVal = HXR_OK;

    m_PendingHandle      = 0;
    m_bIsCallbackPending = FALSE;

    if (m_pSmilDocumentRenderer)
    {
	m_pSmilDocumentRenderer->handlePendingScheduling();
    }

    return retVal;
}

CHyperlinkCallback::CHyperlinkCallback(CSmilDocumentRenderer* pDocRend)
{
    m_lRefCount          = 0;
    m_pDocRend           = pDocRend;
    m_bIsCallbackPending = FALSE;
    m_PendingHandle      = 0;
    m_pAnchor            = NULL;
    m_pExtraAnchorsList  = NULL;
}

CHyperlinkCallback::~CHyperlinkCallback()
{
    if (m_pExtraAnchorsList)
    {
	HX_ASSERT(m_pExtraAnchorsList->GetCount() == 0);
	m_pExtraAnchorsList->RemoveAll();
	HX_DELETE(m_pExtraAnchorsList);
    }
}

STDMETHODIMP CHyperlinkCallback::QueryInterface(REFIID riid, void** ppvObj)
{
    HX_RESULT retVal = HXR_OK;

    if (ppvObj)
    {
        if (IsEqualIID(riid, IID_IUnknown))
        {
            AddRef();
            *ppvObj = (IUnknown*) (IHXCallback*) this;
        }
        else if (IsEqualIID(riid, IID_IHXCallback))
        {
            AddRef();
            *ppvObj = (IHXCallback*) this;
        }
        else
        {
            *ppvObj = NULL;
            retVal  = HXR_NOINTERFACE;
        }
    }
    else
    {
        retVal = HXR_FAIL;
    }

    return retVal;
}

STDMETHODIMP_(ULONG32) CHyperlinkCallback::AddRef()
{
    return InterlockedIncrement(&m_lRefCount);
}

STDMETHODIMP_(ULONG32) CHyperlinkCallback::Release()
{
    if (InterlockedDecrement(&m_lRefCount) > 0)
    {
        return m_lRefCount;
    }

    delete this;
    return 0;
}

STDMETHODIMP CHyperlinkCallback::Func(void)
{
    HX_RESULT retVal = HXR_OK;
    
    m_PendingHandle      = 0;
    m_bIsCallbackPending = FALSE;

    if (m_pDocRend)
    {
        m_pDocRend->handleHyperlinkTraversal(m_pAnchor, TRUE);
	// /Allow for multiple simultaneous onLoad URLs to be fired after a
	// seek forward, related to fix for PR 67170 and PR 67536:
	// go through list of extra anchors, if any, and hurl them too:
	if (m_pExtraAnchorsList)
	{
	    LISTPOSITION lPos = m_pExtraAnchorsList->GetHeadPosition();
	    while (lPos)
	    {
		LISTPOSITION lPosOfCurTmpVal = lPos;
		// /Gets val at lPos and then moves lPos to next node in list:
		CSmilAAnchorElement* pNextAnchor = (CSmilAAnchorElement*)
			m_pExtraAnchorsList->GetNext(lPos);
		// /Remove it from the list so it won't hurl in next callback:
		m_pExtraAnchorsList->RemoveAt(lPosOfCurTmpVal);

		if (pNextAnchor)
		{
		    m_pDocRend->handleHyperlinkTraversal(pNextAnchor, TRUE);
		}
	    }
	    HX_DELETE(m_pExtraAnchorsList);
	}
    }

    return retVal;
}


HX_RESULT
CHyperlinkCallback::AddAdditionalAnchor(CSmilAAnchorElement* pAnchor)
{
    HX_RESULT pnrslt = pAnchor? HXR_OK : HXR_INVALID_PARAMETER;
    if (pAnchor)
    {
	if (!m_pExtraAnchorsList)
	{
	    m_pExtraAnchorsList = new CHXSimpleList;
	}
	if (m_pExtraAnchorsList)
	{
	    m_pExtraAnchorsList->AddTail((void*)pAnchor);
	}
	else
	{
	    pnrslt = HXR_OUTOFMEMORY;
	}
    }

    return pnrslt;
}

HX_RESULT
CHyperlinkCallback::ClearExtraAnchorList()
{
    HX_RESULT hxrslt = HXR_OK;
    if (m_pExtraAnchorsList)
    {
	LISTPOSITION lPos =
		m_pExtraAnchorsList->GetHeadPosition();
	while (lPos)
	{
	    LISTPOSITION lPosOfCurTmpVal = lPos;
	    CSmilAAnchorElement* pNextAnchor =
		    (CSmilAAnchorElement*)m_pExtraAnchorsList->GetNext(lPos);
	    // /Remove it from the list so it won't hurl:
	    m_pExtraAnchorsList->RemoveAt(lPosOfCurTmpVal);
	}
	HX_DELETE(m_pExtraAnchorsList);
    }

    return hxrslt;
}

