/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: textsvcs.h,v 1.1.2.1 2004/07/09 01:50:49 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

 
/****************************************************************************
 *  Text Services for rendering text onto a bitmap
 *
 */

#ifndef _TEXTSVCS_H_
#define _TEXTSVCS_H_

#include "ft2build.h"
#include FT_FREETYPE_H

#define TXTSVCS_MAX_FONT_NOPATH_FILENAME   64

#define USE_SAME_FAMILY_AS_PRIOR_CALL	NULL
#define USE_SAME_BOLD_AS_PRIOR_CALL	0xFF
#define USE_SAME_ITALICS_AS_PRIOR_CALL	0xFF


class CTextServices
{
  private:
    FT_Library  m_hLibrary; // /This is a "handle" (i.e., pointer)
    FT_Face     m_hFace;    // /This is a "handle" (i.e., pointer)

    char*	m_pFontDirectory;
    ULONG32	m_ulStrLenFontDir;

  public:
    CTextServices() : m_hLibrary(NULL), m_hFace(NULL),
	    m_pFontDirectory(NULL), m_ulStrLenFontDir(0) {};
    ~CTextServices()
    {
	FT_Done_Face(m_hFace);
	FT_Done_FreeType(m_hLibrary);
	HX_VECTOR_DELETE(m_pFontDirectory);
    }

    HX_RESULT renderText(const char* pszString, UCHAR* pOffscreenBitmap,
	    LONG32 lOffscreenWidth, LONG32 lOffscreenHeight,
	    LONG32 lOffscreenDepth,
	    INT32 lPosStartX, INT32 lPosStartY,
	    BOOL bDoAntialias,
	    FT_Encoding ftCharsetEncoding,
	    const char* pszFontFamily,
	    BOOL bIsBold,
	    BOOL bIsItalicized,
	    UINT32 ulAvgCharWidthPixels, UINT32 ulCharHeightPixels,
	    UINT32 ulARGBforegroundColor);

    HX_RESULT renderTextSameFontFace(const char* pszString,
	    UCHAR* pOffscreenBitmap,
	    LONG32 lOffscreenWidth, LONG32 lOffscreenHeight,
	    LONG32 lOffscreenDepth,
	    INT32 lPosStartX, INT32 lPosStartY,
	    BOOL bDoAntialias,
	    FT_Encoding ftCharsetEncoding,
	    UINT32 ulAvgCharWidthPixels /*0 to default*/,
	    UINT32 ulCharHeightPixels,
	    UINT32 ulARGBforegroundColor);

    HX_RESULT bltToBitmapFromBitmap(UCHAR* pOffscreenBitmap,
	    LONG32 lOffscreenWidth, LONG32 lOffscreenHeight, LONG32 lOffscreenDepth,
	    INT32 lPosX, INT32 lPosY, FT_Bitmap* pGlyphBitmap,
	    UINT32 ulARGBforegroundColor);

    HX_RESULT
    getFontFileName(const char* pszFontFamily,
	    BOOL bIsBold, BOOL bIsItalicized,
	    CHXString& CHXStrFontFileName /* OUT */);
};


#endif /*_TEXTSVCS_H_. */
