/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: HXEQEngine.h,v 1.2.2.3 2004/07/09 01:49:47 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 *   1/24/98 Ken Cooke
 *   7/99 Greg Conklin
 * 
 * ***** END LICENSE BLOCK ***** */

/*
 * See below for usage API
 *
 */

#if (defined _M_IX86) && (defined _WINDOWS)
//#define _EQ_X86_WINDOWS // XXXSEH: Adds dependencies on other modules.
#endif

#ifdef _EQ_X86_WINDOWS
#include "limiter.h"
#include "codecutil.h"
#endif


#define EQ_FIXED_HEADROOM_BITS  4          /* 4 bits of headroom */
#define EQ_FLOAT_0DB            32768.0f   /* floating point value representing 0 dB */
#define EQ_FLT2FIX_SCALE        (1<<(31-EQ_FIXED_HEADROOM_BITS))/(EQ_FLOAT_0DB)

#define EQ_NRATES				7		/* number of sampling rates */
#define EQ_MAXCHANS				2		/* allows multiple channels */
#define EQ_MAXBANDS				12		/* number of bands at highest rate */
#define EQ_ROOMSIZEBAND			10		/* the band number indicating the room size */
#define EQ_REVERBBAND			11		/* the band number indicating the reverb intensity */
#define EQ_SUSTAINBAND			12		/* the band number indicating the reverb sustain */

#define EQ_NBANDS_8000			8
#define EQ_NBANDS_11025			8
#define EQ_NBANDS_16000			9
#define EQ_NBANDS_22050			9
#define EQ_NBANDS_32000			10
#define EQ_NBANDS_44100			10
#define EQ_NBANDS_48000			10

#define EQ_MAXGAIN				144		/* +18 dB */
#define EQ_MINGAIN				-144	/* -18 dB */
/*
 * If nsamps > EQ_MAXSAMPS, processing is tiled in EQ_MAXSAMPS chunks.
 * For good performance on 8KB data cache, should be <1024.
 */
#define EQ_MAXSAMPS			512

// reverb defines
#define REVERB_NUM_ECHOS		10
#define REVERB_MAX_ECHO_DELAY	500

/*
 * Stuct that holds entire EQ state.
 */
typedef struct EQSTATE {
	int ratecode;							/* sampling rate code */
	int nchans;								/* number of channels */
	int nbands;								/* number of filter bands */
	// equalizer variables...
	float iflt[EQ_MAXSAMPS];				/* input floats */
	float ihist[EQ_MAXCHANS][2];			/* input history */
	float oflt[EQ_MAXSAMPS];				/* output floats */
	float ohist[EQ_MAXCHANS][2*EQ_MAXBANDS];	/* filter output history */
	float filtgain[EQ_MAXBANDS];			/* filter gains */
	float pregain;							/* input pre-gain */
	int autopregain;						/* 0/1 = pregain disabled/enabled */
	float pwrLevelMeasure;                  /* Measurement of the maximum sample level */
	const float *coeff;							/* pointer into filter coeffs */
	// reverb variables...
	float *eqhist;							/* history of input samples is used to process reverb */
	float *eqhist_end;						/* pointer to the end of the history ring buffer */
	float *eqhist_head;						/* pointer to the head of the history ring buffer */
	float *eqhist_start;					/* pointer to the start of the current block of samples */
	float *echoPtr[REVERB_NUM_ECHOS];		/* pointers to the past for each echo */
	float gain;								/* feedback gain of echo */
	float echoFiltState[EQ_MAXCHANS][REVERB_NUM_ECHOS];	/* the state of the low-pass IIR echo filters */
	float echoFiltCoeff;					/* the IIR filter coefficient */
	int	  reverb;							/* overall reverb level */
	int   roomsize;							/* parameter determining the delay of echos */
	float mean[EQ_MAXCHANS];				/* mean of signal after reverb -- to correct for drift */
	unsigned int timer;						/* keeps track of time */
	float *itlbuf;                          /* interleaved buffer of float or fixed32 samples */
#ifdef _EQ_X86_WINDOWS
	LIMSTATE *limState;                     /* state info for peak limiter */
#endif

} EQSTATE, *EQPTR;

#ifdef __cplusplus
extern "C" 
{
#endif // __cplusplus


/*
 * EQ functions.  See definitions for usage...
 */
EQPTR EQInit(int samprate, int nchans);

int EQProcess(EQPTR eq, short *inpcm, short *outpcm, int nsamps);

void EQSetGain(EQPTR eq, int *dbgain);

void EQSetReverb(EQPTR eq, int roomsize, int reverb);

void EQGetReverb(EQPTR eq, int *roomsize, int *reverb);

void EQSetPreGain(EQPTR eq, int pregain);

void EQGetPreGain(EQPTR eq, int *pregain);

void EQEnableAutoPreGain(EQPTR eq, int enable);

void EQResetReverb(EQPTR eq);

void EQFree(EQPTR eq);


#ifdef __cplusplus
}
#endif // __cplusplus
