/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: package_info.cpp,v 1.1.4.3 2004/07/09 01:49:06 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */
/*
 *  package_info.cpp - information about this package
 *
 */

#include "hxtypes.h"
#include <stdio.h>
#include <string.h>
#include "hxplayer.ver"
#include "package_info.h"
#include "package_name.h"
//#include "product_version.h"


#define CMDLN_HELP_CMDS \
"-v          --version                   Print version number and exit\n" \
"-h          --help                      Print command-line help and exit\n" \
"-s          --silent                    Perform a silent install\n" \
"-p          --progress-only             Perform a non-interactive install\n" \
"-nb         --no-backup                 Don't backup files if reinstalling\n" \
"-d <dir>    --dest <dir>                Install to directory <dir>\n" \
"-cfg <file>                             Read Installer config file <file>\n" \

#define CMDLN_HELP_PASS \
"--password <password>                   Use password <password>\n"

#define CMDLN_HELP_CONFIG \
"Note: An Installer config file consists of a list of Name=Value pairs,\n" \
"one pair per line, which specify default values for various settings.\n" \
"The list of supported Names includes:\n" \
"    AdminPort={port}    AdminRealm={realm}   AdminPassword={passwd}\n" \
"    HTTPPort={port}     EncoderRealm={realm} EncoderPassword={passwd}\n" \
"    MonitorPort={port}  ContentRealm={realm} MonitorPassword={passwd}\n" \
"    RTSPPort={port}     AdminUserID={user}   DefInstallPath={path}\n" \
"    PNAPort={port}      EncoderUserID={user} LoggingStyle={style}\n" \
"    MMSPort={port}      LicenseFile={file}\n" \
"It can also specify several flags that control the installer's behavior,\n" \
"with values of 0 indicating false and 1 indicating true:\n" \
"    BackupOldFiles={0/1}   SilentInstall={0/1}\n"


const char*
PackageInfo::Name()
{
    return PACKAGE_NAME;
}

const char*
PackageInfo::VersionString()
{
    static char *szVer = 0;
    if (!szVer)
    {
        szVer = new char[256];
        sprintf (szVer, "%s (%s)",
                 PACKAGE_NAME,
		 TARVER_STRING_VERSION);
    }
    
    return szVer;
}

const char*
PackageInfo::CommandLineHelpString(BOOL bPass)
{
    return bPass ? CMDLN_HELP_CMDS CMDLN_HELP_PASS "\n" CMDLN_HELP_CONFIG :
        CMDLN_HELP_CMDS "\n" CMDLN_HELP_CONFIG;
}
