# custom  macros
%define reldate %(date '+%Y%m%d')

Summary     : The Helix Player is the Helix Community\'s open source media player for consumers.
Name        : HelixPlayer
Version     : _REPLACE_VERSION_
Release     : %{reldate}
Group       : Applications/Multimedia
License     : RPSL, EULA
Vendor      : RealNetworks, Inc
URL         : https://player.helixcommunity.org/
Packager    : Helix Player Community <users@player.helixcommunity.org>
Source0     : install.bz2
Prefix      : /usr/local
Requires    : gtk2
Obsoletes   : G2player, RealOne
BuildRoot   : %{_tmppath}/%{name}-buildroot
AutoReqProv     : no
# Disables generating dependencies automatically

%description
The Helix Player 1.0 is an open-source media player built in the Helix 
Community for consumers. Built using GTK, it plays open source formats, 
like Ogg Vorbis and Theora using the powerful Helix DNA Client Media 
Engine.

%prep
rm -rf %buildroot
mkdir -p %buildroot/usr/local/HelixPlayer

###############################################
# %setup macro
# -c      : Create directory before unpacking.
# -n name : Name the directory as name
# -T      : Disable the automatic unpacking of the archives.
# -q      : Run quiety with minimum output
###############################################
%setup -c -q

%install
mkdir -p %buildroot/usr/local
cp -a . %buildroot/usr/local/HelixPlayer/
# this is not needed
rm -rf %buildroot/usr/local/HelixPlayer/Bin

%post
( 
    APPNAME=HelixPlayer
    TARGET=hxplay
    INSTDIR="$RPM_INSTALL_PREFIX/$APPNAME"

    # setup the hxplay script
    "$INSTDIR/postinst/confscript.sh" "$INSTDIR" > /dev/null

    # setup the bin link (try to find a good location for it)
    for BINDIR in "/usr/bin" "$RPM_INSTALL_PREFIX/bin" ; do
    if [ -d "$BINDIR" ] ; then
        ln -sf "$INSTDIR/$TARGET" "$BINDIR"
        break;
    fi
    done

    # setup mozilla
    for MOZDIR in "/usr/lib/mozilla/plugins" "/usr/lib/browser-plugins" "/opt/mozilla/lib/plugins" "/usr/lib/firefox/plugins" "/usr/lib/mozilla-firefox/plugins" "/usr/lib/netscape/plugins" "/opt/mozilla/plugins" "/opt/netscape/plugins"; do
    if [ -d "$MOZDIR" ] ; then
        ln -sf "$INSTDIR/mozilla/nphelix.so" "$MOZDIR"
        ln -sf "$INSTDIR/mozilla/nphelix.xpt" "$MOZDIR"
    fi
    done

    # setup .mo files
    LOCALEDIR="/usr/share/locale"
    for LANGUAGE in `ls $INSTDIR/share/locale`; do
    if [ -d "$LOCALEDIR/$LANGUAGE/LC_MESSAGES" ] ; then
        cp "$INSTDIR/share/locale/$LANGUAGE/player.mo" "$LOCALEDIR/$LANGUAGE/LC_MESSAGES/hxplay.mo"
        cp "$INSTDIR/share/locale/$LANGUAGE/widget.mo" "$LOCALEDIR/$LANGUAGE/LC_MESSAGES/libgtkhx.mo"
    fi
    done

    # find gnome, install desktop files
    for PREFIX in "/opt/gnome" "/usr" ; do
    if [ -d "$PREFIX" ] ; then
        SHARE="$PREFIX/share"
        test -d "$SHARE/application-registry" && \
        install -p -m644 "$INSTDIR/share/$TARGET.applications" \
        "$SHARE/application-registry"
        test -d "$SHARE/applications" && \
        install -p -m644 "$INSTDIR/share/$TARGET.desktop" \
        "$SHARE/applications"
        test -d "$SHARE/mime-info" && \
        install -p -m644 "$INSTDIR/share/$TARGET.keys" \
        "$SHARE/mime-info"
        test -d "$SHARE/mime-info" && \
        install -p -m644 "$INSTDIR/share/$TARGET.mime" \
        "$SHARE/mime-info"

        # install icons
        PIXMAPS="$SHARE/pixmaps"
        test -d "$PIXMAPS" && \
        install -p -m644 "$INSTDIR/share/hxplay.png" "$PIXMAPS"

        HICOLOR="$SHARE/icons/hicolor"
        if [ -d "$HICOLOR" ] ; then
            for SIZE in "16x16" "32x32" "48x48" "128x128" "192x192" ; do
                mkdir -p "$HICOLOR/$SIZE"
                mkdir -p "$HICOLOR/$SIZE/apps"
                mkdir -p "$HICOLOR/$SIZE/mimetypes"

                ICON="$INSTDIR/share/icons/${TARGET}_$SIZE.png"
                if [ -f "$ICON" ] ; then
                    cp "$ICON" "$HICOLOR/$SIZE/apps/$TARGET.png"
                fi

                for MIME in \
                    "application-generic" \
                    "audio-generic"       \
                    "text-realtext"       \
                    "video-generic"       \
                    "video-ogg"           \
                    "application-ogg"     \
                    "application-ogg"     \
                    "application-ram"     \
                    "application-rpm"     \
                    "application-smil"    \
                    "application-rm"      \
                    "audio-aiff"          \
                    "audio-au"            \
                    "audio-mp3"           \
                    "audio-mp4"           \
                    "audio-ogg"           \
                    "audio-ra"            \
                    "audio-wav"           \
                    "video-avi"           \
                    "video-mov"           \
                    "video-rv"            \
                    "video-swf" ; do
                    ICON="$INSTDIR/share/icons/mime-${MIME}_$SIZE.png"
                    if [ -f "$ICON" ] ; then
                        cp "$ICON" "$HICOLOR/$SIZE/mimetypes/${TARGET}-${MIME}.png"
                    fi
                done
            done
        fi
    fi
    done
)

%preun
if [ "$1" = 0 ] ; then
(
    INSTDIR="$RPM_INSTALL_PREFIX/$APPNAME"

    # remove .mo files
    LOCALEDIR="/usr/share/locale"
    for LANGUAGE in `ls $INSTDIR/share/locale`; do
        rm -f "$LOCALEDIR/$LANGUAGE/LC_MESSAGES/hxplay.mo"
        rm -f "$LOCALEDIR/$LANGUAGE/LC_MESSAGES/libgtkhx.mo"
    done
)
fi

%postun
if [ "$1" = 0 ] ; then
( 
    APPNAME=HelixPlayer
    TARGET=hxplay
    INSTDIR="$RPM_INSTALL_PREFIX/$APPNAME"

    # remove backup file
    rm -f "$INSTDIR/$TARGET.bak"

    # remove the bin link (try to find where we put it)
    for BINDIR in "/usr/bin" "$RPM_INSTALL_PREFIX/bin" ; do
    if [ -h "$BINDIR/$TARGET" ] ; then
        rm -f "$BINDIR/$TARGET"
    fi
    done

    # remove mozilla plugin
    for MOZDIR in "/usr/lib/mozilla" ; do
    rm -f "$MOZDIR/plugins/nphelix.so"
    rm -f "$MOZDIR/plugins/nphelix.xpt"
    done

    # find gnome, remove desktop files
    for PREFIX in "/opt/gnome" "/usr" ; do
    if [ -d "$PREFIX" ] ; then
        SHARE="$PREFIX/share"
        rm -f "$SHARE/application-registry/$TARGET.applications" 
        rm -f "$SHARE/applications/$TARGET.desktop" 
        rm -f "$SHARE/mime-info/$TARGET.keys" 
        rm -f "$SHARE/mime-info/$TARGET.mime"

        # uninstall icons
        PIXMAPS="$SHARE/pixmaps"
        rm -f "$PIXMAPS/$TARGET.png"

        HICOLOR="$SHARE/icons/hicolor"
        if [ -d "$HICOLOR" ] ; then
            for SIZE in "16x16" "32x32" "48x48" "128x128" "192x192" ; do

                rm -f "$HICOLOR/$SIZE/apps/$TARGET.png"

                for MIME in \
                    "application-generic" \
                    "application-ogg"     \
                    "application-ram"     \
                    "application-rpm"     \
                    "application-smil"    \
                    "application-rm"      \
                    "audio-aiff"          \
                    "audio-au"            \
                    "audio-mp3"           \
                    "audio-mp4"           \
                    "audio-ogg"           \
                    "audio-ra"            \
                    "audio-wav"           \
                    "video-avi"           \
                    "video-mov"           \
                    "video-rv"            \
                    "video-swf" ; do
                    rm -f "$HICOLOR/$SIZE/mimetypes/${TARGET}-${MIME}.png"
                done
            done 
        fi
    fi
    done
)
fi

%clean
rm -rf %buildroot

%files
#####################################################
# %defattr sets the default attributes for all files
#####################################################
%defattr(-,root,root)
/usr/local/HelixPlayer

%changelog
* Mon Dec 13 2004 Ryan Gammon <rgammon@real.com>
- Adding locales

* Mon Jun 8 2004 Ryan Gammon <rgammon@real.com>
- Adding /usr/share/pixmap, document icons

* Mon Jun 7 2004 Nicholas Hart <nhart@real.com>
- added .mime/.keys/.applications files

* Wed May 5 2004 Ryan Gammon <rggammon@helixcommunity.org>
- Updating icons

* Thu Jan 13 2004  Nicholas Hart <nhart@helixcommunity.org>
- tweaked some paths to deal with tarball generated by player/installer/app
- changed, reformatted some of the package info

* Sat Dec 27 2003 Thomas Chung <tchung@linuxinstall.org> 0.2.0.0-20031224
- First RPM build for Fedora Core 1
