/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: ihxmimeassocmanager.h,v 1.4.4.3 2004/07/09 01:48:38 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef __ihxmimeassocmanager_h
#define __ihxmimeassocmanager_h


_INTERFACE IHXAppInfo;
_INTERFACE IHXAppInfoEnum;
_INTERFACE IHXMimeInfo;
_INTERFACE IHXMimeInfoEnum;



// {19C3CDBC-D943-4338-9242-220086605B4B}
DEFINE_GUID(IID_IHXMimeAssocManager,
	    0x19c3cdbc, 0xd943, 0x4338,
	    0x92, 0x42, 0x22, 0x0, 0x86, 0x60, 0x5b, 0x4b);


DECLARE_INTERFACE_(IHXMimeAssocManager, IUnknown)
{
    // app methods
    STDMETHOD_(BOOL, AppExists)(THIS_ const char* pAppId) CONSTMETHOD PURE;
    STDMETHOD(GetApp)     (THIS_ const char* pAppId,
			   REF(IHXAppInfo*) pAppInfo) CONSTMETHOD PURE;
    STDMETHOD(SetApp)     (THIS_ const char* pAppId,
			   IHXAppInfo* pAppInfo) PURE;
    STDMETHOD(RemoveApp)  (THIS_ const char* pAppId) PURE;
    STDMETHOD(EnumApps)   (THIS_ REF(IHXAppInfoEnum*) pEnum) CONSTMETHOD PURE;

    // mime methods
    STDMETHOD_(BOOL, MimeExists)(THIS_ const char* pMimeId) CONSTMETHOD PURE;
    STDMETHOD(GetMime)    (THIS_ const char* pMimeId,
			   REF(IHXMimeInfo*) pMimeInfo) CONSTMETHOD PURE;
    STDMETHOD(SetMime)    (THIS_ const char* pMimeId,
			   IHXMimeInfo* pMimeInfo) PURE;
    STDMETHOD(RemoveMime) (THIS_ const char* pMimeId) PURE;
    STDMETHOD(EnumMimes)  (THIS_ REF(IHXMimeInfoEnum*) pEnum) CONSTMETHOD PURE;

    // assoc methods
    STDMETHOD_(BOOL, AssocExists)(THIS_ const char* pMimeId,
				  const char* pAppId) CONSTMETHOD PURE;
    STDMETHOD_(INT32, AssocSupported)(THIS_ const char* pMimeId,
				      const char* pAppId) CONSTMETHOD PURE;
    STDMETHOD(GetAssoc)   (THIS_ const char* pMimeId,
			   REF(const char*) pAppId) CONSTMETHOD PURE;
    STDMETHOD(SetAssoc)   (THIS_ const char* pMimeId,
			   const char* pAppId) PURE;
    STDMETHOD(RemoveAssoc)(THIS_ const char* pMimeId,
			   const char* pAppId) PURE;
    STDMETHOD(EnumAppAssocs)(THIS_ const char* pAppId,
			     REF(IHXMimeInfoEnum*) pEnum) CONSTMETHOD PURE;
    STDMETHOD(EnumMimeAssocs)(THIS_ const char* pMimeId,
			      REF(IHXAppInfoEnum*) pEnum) CONSTMETHOD PURE;

    // information methods
    STDMETHOD(GetMimeSystemInfo) (THIS_ REF(const char*) pName,
				  REF(const char*) pDescription,
				  REF(UINT32) uVersion) PURE;

    // general mime database operations
    STDMETHOD(Init)       (THIS) PURE;
    STDMETHOD(Reload)     (THIS) PURE;
    STDMETHOD(Commit)     (THIS) PURE;
    STDMETHOD(Shutdown)   (THIS) PURE;
};



#endif /* #ifndef __ihxmimeassocmanager_h */
