/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: mwinsite.cpp,v 1.3.20.1 2004/07/09 01:59:19 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include "minisite.h"
#include "mwinsite.h"
#include "hlxosstr.h"

char*   CHXWinSite::zm_pszWindowClassName   = "HXWinVideoClass";
char*   CHXWinSite::zm_pszWindowName        = "HXWinVideoWindow";
INT32   CHXWinSite::zm_nInstanceCount       = 0;

/************************************************************************
 *  Function:
 *    CHXWinSiteWindowedProc
 */
LRESULT HXEXPORT CHXWinSiteWindowedProc
(
    HWND hWnd,
    UINT message,
    WPARAM uParam,
    LPARAM lParam
    )
{
    return (DefWindowProc(hWnd, message, uParam, lParam));
}

/************************************************************************
 *  Method:
 *    Constructor
 */
CHXWinSite::CHXWinSite(IUnknown* pContext, IUnknown* pUnkOuter, INT32 lZorder)
 :  CMiniBaseSite(pContext, pUnkOuter, lZorder)
{
}


/************************************************************************
 *  Method:
 *    Destructor
 */
CHXWinSite::~CHXWinSite()
{                   
}


/************************************************************************
 *  Method:
 *    IHXSiteWindowed::Create
 */
void* 
CHXWinSite::_Create(void* ParentWindow, UINT32 style)
{
    /*
     * Make sure the window class is registered.
     */
	OS_STRING_TYPE osstrWindowClassName(zm_pszWindowClassName);

    if (0 == zm_nInstanceCount)
    {
        WNDCLASS wndClass;
        
        wndClass.style = 0; 
        wndClass.lpfnWndProc = CHXWinSiteWindowedProc; 
        wndClass.cbClsExtra = 0; 
        wndClass.cbWndExtra = 0; 
        wndClass.hInstance = GetModuleHandle(NULL);
        wndClass.hIcon = NULL; 
        wndClass.hCursor = NULL; 
        wndClass.hbrBackground = NULL;
        wndClass.lpszMenuName = NULL; 
        wndClass.lpszClassName = osstrWindowClassName; 
        
        ::RegisterClass(&wndClass);
    }
    
    zm_nInstanceCount++;
    
    HWND hWnd = CreateWindowEx(NULL,
                               OS_STRING(zm_pszWindowClassName), 
                               OS_STRING(zm_pszWindowName), 
                               style, 
                               0, 
                               0,
                               0,
                               0,
                               (HWND)ParentWindow, 
                               NULL, 
                               GetModuleHandle(NULL), 
                               NULL);
    
    return hWnd;
}

/************************************************************************
 *  Method:
 *    IHXSiteWindowed::Destroy
 */
void 
CHXWinSite::_Destroy(HXxWindow* pWindow) 
{
    BOOL retVal = ::DestroyWindow((HWND) pWindow->window);
    
    if (zm_nInstanceCount > 0)
    {
        zm_nInstanceCount--;
    }
    
    if (0 == zm_nInstanceCount)
    {
        ::UnregisterClass(OS_STRING(zm_pszWindowClassName), GetModuleHandle(NULL));
    }
}

void
CHXWinSite::_SetSize(HXxSize size)
{
    /*
     * Change the size of the window using platform specific calls.
     * Note: the size being requested is the "client" size for the
     * window, so we need to actually determine the outer rect size.
     * We do this by getting the current window rect and client rect,
     * the difference is the "extra" size associated with any window
     * dressing.
     */
    HWND tempHwnd = (HWND) GetWindow()->window;
    RECT rect1,
         clientRect;
    ::GetWindowRect(tempHwnd,&rect1);  
    ::GetClientRect(tempHwnd, &clientRect);

    // Make the window's client size equal to the video's size
    int nWidthDelta = (rect1.right - rect1.left) -
                      (clientRect.right - clientRect.left);

    int nHeightDelta = (rect1.bottom - rect1.top) -
                       (clientRect.bottom - clientRect.top); 


    MapWindowPoints(NULL, GetParent(tempHwnd), (POINT*)&rect1, 2);
    _MoveWindow(tempHwnd,
                (int)rect1.left, (int)rect1.top,
                (int)size.cx + nWidthDelta,
                (int)size.cy + nHeightDelta,
                TRUE);
}

void CHXWinSite::_SetPosition(HXxPoint position)
{
    //Since I just flattened the window structure this function has to
    //me modified to take that into account.
    if(m_pWindow->window && !m_bWindowCreatedByCreate)
    {
        //_MoveWindow((HWND)m_pWindow->window,
        //            (int)m_topleft.x,
        //            (int)m_topleft.y,
        //            (int)m_size.cx ,
        //            (int)m_size.cy ,
        //            TRUE);
    }
    else
    {
        _MoveWindow((HWND) GetWindow()->window,
                    (int)position.x,
                    (int)position.y,
                    (int)m_size.cx ,
                    (int)m_size.cy ,
                    TRUE);
    }
}

BOOL CHXWinSite::_MoveWindow( void* win,
                              INT32 X,
                              INT32 Y,
                              INT32 nWidth,
                              INT32 nHeight,
                              BOOL bRepaint)
{
    return ::MoveWindow((HWND)win,X,Y,nWidth,nHeight,bRepaint);
}

