/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: macsurf.h,v 1.4.34.1 2004/07/09 01:58:34 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _MACSURF_H_
#define _MACSURF_H_

#ifdef _MAC_MACHO
#include <QuickTime/QuickTime.h>
#else
#include <ImageCompression.h>
#endif

#include "basesurf.h"


class CMacSurface : public CBaseSurface
{
public:
	friend class CMacRootSurface;
	friend class CHXMacSite;
	
		CMacSurface(IUnknown* pContext, CHXBaseSite* pSite);
	virtual	~CMacSurface();
    
    /*
     *  Virtual Functions which must me implemented by each OS.
     */
    virtual void	_ReleaseSurface(CBaseRootSurface* pSurface);
    virtual void	_DrawBlack(void* pWindow);
    virtual void	__Sleep(int milliseconds);
    virtual HX_RESULT	_BltToPrimary(REF(HXxRect) rDestRect, REF(HXxRect) rSrcRect);
    virtual void	_CreateBuffer();
    virtual HX_RESULT	_GetCaps(UINT32 *pfSurfaceCaps);
    virtual HX_RESULT	_CreateOverlay(BOOL bOverlay, int cid, int x, int y);
    virtual HX_RESULT	_LockInternalSurface(UCHAR** ppSurfPtr, LONG32* pnSurfPitch, REF(HXxSize) srcSize);
    virtual HX_RESULT	_UnlockInternalSurface(UCHAR* pSurfPtr);
    virtual void	_SetupDCObjects(HXxDC hxxDC, void** phOldBrush, void** phOldPen);
    virtual void	_FillRectangle(HXxDC hxxDC, UINT32 left, UINT32 top, UINT32 right, UINT32 bottom);
    virtual void	_RestoreDCObjects(HXxDC hxxDC, void* hOldBrush, void* hOldPen);
    virtual void	_GetCompositionSurfaceHXxDC(HXxDC *hdc);
    virtual void	_ReleaseCompositionSurfaceHXxDC(HXxDC hdc);
    virtual INT32	_InsureColorMatch(INT32 InColor);
    virtual void	_SetColorKey(INT32 nColorSpaceLowValue, INT32 nColorSpaceHighValue);
    virtual void	_UpdateOverlay(HXxRect* src, HXxRect* dest, INT32 inFlags);
    virtual BOOL	_IsSurfaceVisible();
    virtual void	_ReleaseSurface();
    virtual HXxDC	_GetDC(HXxWindow*);
    virtual void	_ReleaseDC(HXxWindow*, HXxDC);
    virtual void	_GetWindowDeviceCords(HXxRect* rect);
    
            BOOL	_OverlayAvailable();
    virtual BOOL	_AllowsOverlayShrinking();
    
    static void		CleanUpOverlay();

private:
    static CHXSimpleList	zm_SurfaceList;

    void		ConstructOverlay(long screenCoorX, long screenCoorY,
    				long screenWidth, long screenHeight,
    				long sourceWidth, long sourceHeight,
    				RgnHandle maskRgn);
    RgnHandle		BuildOverlayVisRgn();
        
public:
    static void*		zm_pOverlayBuf;
    static long			zm_nOverlayRowBytes;
    static RgnHandle		zm_OverlayMaskRgn;
    static BOOL			zm_bSafeToOverlayBlit;
    static CMacSurface*		zm_pOverlaySurface;
    static BOOL			zm_bOverlayRequiresKeyColor;
    static BOOL			zm_bOverlayRequiresDrawBand;
    
    static BOOL				zm_bUsingFauxCodec;
    static ImageSequence		zm_SequenceID;
    static ImageDescriptionHandle	zm_ImageDescriptionHandle;
    static long				zm_nOverlayBufferSize;
    
    static void*			zm_pHoldOverlayBuf;
    static long				zm_nHoldOverlayBufSize;
};

#endif
